/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import micropolisj.engine.Micropolis;
import micropolisj.engine.MicropolisMessage;
import micropolisj.engine.ZoneStatus;
import micropolisj.gui.ColorParser;
import micropolisj.gui.MainWindow;
import micropolisj.gui.MicropolisDrawingArea;

public class NotificationPane
extends JPanel {
    JLabel headerLbl;
    JViewport mapViewport;
    MicropolisDrawingArea mapView;
    JPanel mainPane;
    JComponent infoPane;
    static final Dimension VIEWPORT_SIZE = new Dimension(160, 160);
    static final Color QUERY_COLOR = new Color(255, 165, 0);
    static final ResourceBundle strings = MainWindow.strings;
    static final ResourceBundle mstrings = ResourceBundle.getBundle("micropolisj.CityMessages");
    static final ResourceBundle s_strings = ResourceBundle.getBundle("micropolisj.StatusMessages");

    public NotificationPane(Micropolis engine) {
        super(new BorderLayout());
        this.setVisible(false);
        this.headerLbl = new JLabel();
        this.headerLbl.setOpaque(true);
        this.headerLbl.setHorizontalAlignment(0);
        this.headerLbl.setBorder(BorderFactory.createRaisedBevelBorder());
        this.add((Component)this.headerLbl, "North");
        JButton dismissBtn = new JButton(strings.getString("notification.dismiss"));
        dismissBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotificationPane.this.onDismissClicked();
            }
        });
        this.add((Component)dismissBtn, "South");
        this.mainPane = new JPanel(new BorderLayout());
        this.add((Component)this.mainPane, "Center");
        JPanel viewportContainer = new JPanel(new BorderLayout());
        viewportContainer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 4, 8, 4), BorderFactory.createLineBorder(Color.BLACK)));
        this.mainPane.add((Component)viewportContainer, "West");
        this.mapViewport = new JViewport();
        this.mapViewport.setPreferredSize(VIEWPORT_SIZE);
        this.mapViewport.setMaximumSize(VIEWPORT_SIZE);
        this.mapViewport.setMinimumSize(VIEWPORT_SIZE);
        viewportContainer.add((Component)this.mapViewport, "Center");
        this.mapView = new MicropolisDrawingArea(engine);
        this.mapViewport.setView(this.mapView);
    }

    private void onDismissClicked() {
        this.setVisible(false);
    }

    void setPicture(Micropolis engine, int xpos, int ypos) {
        Dimension sz = VIEWPORT_SIZE;
        this.mapView.setEngine(engine);
        Rectangle r = this.mapView.getTileBounds(xpos, ypos);
        this.mapViewport.setViewPosition(new Point(r.x + r.width / 2 - sz.width / 2, r.y + r.height / 2 - sz.height / 2));
    }

    public void showMessage(Micropolis engine, MicropolisMessage msg, int xpos, int ypos) {
        this.setPicture(engine, xpos, ypos);
        if (this.infoPane != null) {
            this.mainPane.remove(this.infoPane);
            this.infoPane = null;
        }
        this.headerLbl.setText(mstrings.getString(msg.name() + ".title"));
        this.headerLbl.setBackground(ColorParser.parseColor(mstrings.getString(msg.name() + ".color")));
        JLabel myLabel = new JLabel("<html><p>" + mstrings.getString(msg.name() + ".detail") + "</p></html>");
        myLabel.setPreferredSize(new Dimension(1, 1));
        this.infoPane = myLabel;
        this.mainPane.add((Component)myLabel, "Center");
        this.setVisible(true);
    }

    public void showZoneStatus(Micropolis engine, int xpos, int ypos, ZoneStatus zone) {
        this.headerLbl.setText(strings.getString("notification.query_hdr"));
        this.headerLbl.setBackground(QUERY_COLOR);
        String buildingStr = zone.building != -1 ? s_strings.getString("zone." + zone.building) : "";
        String popDensityStr = s_strings.getString("status." + zone.popDensity);
        String landValueStr = s_strings.getString("status." + zone.landValue);
        String crimeLevelStr = s_strings.getString("status." + zone.crimeLevel);
        String pollutionStr = s_strings.getString("status." + zone.pollution);
        String growthRateStr = s_strings.getString("status." + zone.growthRate);
        this.setPicture(engine, xpos, ypos);
        if (this.infoPane != null) {
            this.mainPane.remove(this.infoPane);
            this.infoPane = null;
        }
        JPanel p = new JPanel(new GridBagLayout());
        this.mainPane.add((Component)p, "Center");
        this.infoPane = p;
        GridBagConstraints c1 = new GridBagConstraints();
        GridBagConstraints c2 = new GridBagConstraints();
        c1.gridx = 0;
        c2.gridx = 1;
        c2.gridy = 0;
        c1.gridy = 0;
        c1.anchor = 17;
        c2.anchor = 17;
        c1.insets = new Insets(0, 0, 0, 8);
        c2.weightx = 1.0;
        p.add((Component)new JLabel(strings.getString("notification.zone_lbl")), c1);
        p.add((Component)new JLabel(buildingStr), c2);
        ++c2.gridy;
        c1.gridy = c2.gridy++;
        p.add((Component)new JLabel(strings.getString("notification.density_lbl")), c1);
        p.add((Component)new JLabel(popDensityStr), c2);
        c1.gridy = c2.gridy++;
        p.add((Component)new JLabel(strings.getString("notification.value_lbl")), c1);
        p.add((Component)new JLabel(landValueStr), c2);
        c1.gridy = c2.gridy++;
        p.add((Component)new JLabel(strings.getString("notification.crime_lbl")), c1);
        p.add((Component)new JLabel(crimeLevelStr), c2);
        c1.gridy = c2.gridy++;
        p.add((Component)new JLabel(strings.getString("notification.pollution_lbl")), c1);
        p.add((Component)new JLabel(pollutionStr), c2);
        c1.gridy = c2.gridy;
        p.add((Component)new JLabel(strings.getString("notification.growth_lbl")), c1);
        p.add((Component)new JLabel(growthRateStr), c2);
        ++c1.gridy;
        c1.gridwidth = 2;
        c1.weighty = 1.0;
        p.add((Component)new JLabel(), c1);
        this.setVisible(true);
    }
}

