/*
 * Decompiled with CFR 0.152.
 */
package rescue;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import rescue.JukeBox;
import rescue.MissionObject;
import rescue.RescueIO;
import rescue.RunRescue;
import rescue.SunAudioJukeBox;
import rescue.panels.BigMapPanel;
import rescue.panels.ContainerPanel;
import rescue.panels.InterfacePanel;
import rescue.panels.ShipInfoPanel;
import rescue.panels.ShipsPanel;
import rescue.panels.SmallMapPanel;
import rescue.qdxml.DocHandler;
import rescue.qdxml.QDParser;
import rescue.spaceobjects.ImageObject;

public class MissionLoader
implements DocHandler {
    private Vector MissionObjects;
    private Vector MissionWindows;
    private Component bigmap;
    private String missionName;
    private RunRescue rescue;
    private Vector containers;
    private Vector panels;
    private MissionObject cmo;
    private ContainerPanel cmf;
    private InterfacePanel cip;
    private JToolBar ctb;
    private String XMLFile;
    private URL path;
    private String previewURL;
    private Icon previewIcon;
    private boolean cluster;
    private boolean external;
    private ShipsPanel shiplist;
    private ShipsPanel baselist;
    private ShipInfoPanel shipinfo;
    private JukeBox jukebox;
    private boolean loadSO;

    public MissionLoader(RunRescue r, URL base, String file) throws Exception {
        this.XMLFile = file;
        this.rescue = r;
        this.path = base;
        this.MissionObjects = new Vector();
        this.readXML(true);
    }

    private void readXML(boolean l) throws Exception {
        this.loadSO = l;
        InputStreamReader isr = new InputStreamReader(RescueIO.getInputStream(new URL(this.path, this.XMLFile)));
        QDParser.parse(this, isr);
        isr.close();
    }

    public String getXMLFileName() {
        return this.XMLFile;
    }

    public Icon getIcon() {
        if (this.previewURL != null && this.previewIcon == null) {
            try {
                this.previewIcon = new ImageIcon(ImageIO.read(RescueIO.getInputStream(new URL(this.path, this.previewURL))));
            }
            catch (Exception ex) {
                this.previewURL = null;
                return null;
            }
        }
        return this.previewIcon;
    }

    public void loadImagesForSetup() {
        for (int i = 0; i < this.MissionObjects.size(); ++i) {
            try {
                ((MissionObject)this.MissionObjects.get(i)).loadImagesForSetup();
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void loadImagesForGame() {
        if (this.MissionWindows == null) {
            this.loadImagesForSetup();
            try {
                this.jukebox = new SunAudioJukeBox();
            }
            catch (Exception ex) {
                System.err.println("unable to create jukebox!");
                ex.printStackTrace();
                this.jukebox = new JukeBox(){

                    public void setUpSound(String a, URL b) {
                    }

                    public void playSound(String a) {
                    }

                    public void stopSound(String a) {
                    }
                };
            }
            this.MissionWindows = new Vector();
            this.containers = new Vector();
            this.panels = new Vector();
            for (int i = 0; i < this.MissionObjects.size(); ++i) {
                try {
                    ((MissionObject)this.MissionObjects.get(i)).loadImagesForGame();
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            try {
                this.readXML(false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public String toString() {
        return this.missionName;
    }

    public ImageObject[] getSpaceObjects(Vector t) throws Exception {
        int i;
        int a = 0;
        for (int i2 = 0; i2 < this.MissionObjects.size(); ++i2) {
            a += ((MissionObject)this.MissionObjects.elementAt(i2)).getNumber();
        }
        ImageObject[] v = new ImageObject[a];
        a = 0;
        for (i = 0; i < this.MissionObjects.size(); ++i) {
            a = ((MissionObject)this.MissionObjects.elementAt(i)).makeSpaceObjects(v, this.cluster, a, t);
        }
        for (i = 0; i < this.MissionObjects.size(); ++i) {
            ((MissionObject)this.MissionObjects.elementAt(i)).setLikes(v);
        }
        this.jukebox.load();
        return v;
    }

    public boolean getExternal() {
        return this.external;
    }

    public void setExternal(boolean a) {
        this.external = a;
    }

    public String getMissionName() {
        return this.missionName;
    }

    public MissionObject getPlayerObject() {
        return this.cmo;
    }

    public Vector getMissionObjects() {
        return this.MissionObjects;
    }

    public Component getBigMap() {
        return this.bigmap;
    }

    public Vector getPanels() {
        return this.panels;
    }

    public Vector getWindows() {
        return this.MissionWindows;
    }

    public ShipsPanel getShipList() {
        return this.shiplist;
    }

    public ShipsPanel getBaseList() {
        return this.baselist;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String elem, Hashtable h) throws Exception {
        if (this.loadSO) {
            if (elem.equals("mission")) {
                this.missionName = (String)h.get("name");
                this.previewURL = (String)h.get("preview");
                return;
            } else if (elem.equals("object")) {
                this.cmo = new MissionObject((String)h.get("name"), new URL(this.path, (String)h.get("image")), new URL(this.path, (String)h.get("small")), h.get("info") != null ? new URL(this.path, (String)h.get("info")) : null, (String)h.get("number"), (String)h.get("type"));
                this.MissionObjects.add(this.cmo);
                return;
            } else if (elem.equals("like")) {
                this.cmo.addLike((String)h.get("who"), (String)h.get("amount"));
                return;
            } else if (elem.equals("name")) {
                this.cmo.addName((String)h.get("value"), h.get("image") != null ? new URL(this.path, (String)h.get("image")) : null);
                return;
            } else if (elem.equals("options")) {
                this.cmo.setMinMax((String)h.get("min"), (String)h.get("max"));
                return;
            } else if (elem.equals("preset")) {
                this.cmo.setPreset((String)h.get("name"), (String)h.get("value"));
                return;
            } else if (elem.equals("maxtotalenergy")) {
                this.cmo.setInfoMaxTotalEnergy((String)h.get("value"));
                return;
            } else if (elem.equals("maxphaserbanks")) {
                this.cmo.setInfoMaxPhaserBanks((String)h.get("value"));
                return;
            } else if (elem.equals("maxtorpedosleft")) {
                this.cmo.setInfoMaxTorpedosLeft((String)h.get("value"));
                return;
            } else if (elem.equals("maxshieldpower")) {
                this.cmo.setInfoMaxShieldPower((String)h.get("value"));
                return;
            } else if (elem.equals("maxwarp")) {
                this.cmo.setInfoWarp((String)h.get("value"));
                return;
            } else if (elem.equals("maximpulse")) {
                this.cmo.setInfoImpulse((String)h.get("value"));
                return;
            } else if (elem.equals("jump")) {
                this.cmo.setInfoJump((String)h.get("value"));
                return;
            } else if (elem.equals("turn")) {
                this.cmo.setInfoTurn((String)h.get("value"));
                return;
            } else if (elem.equals("maxphaserintensity")) {
                this.cmo.setInfoPhaser((String)h.get("value"));
                return;
            } else if (elem.equals("maxtorpedosalvo")) {
                this.cmo.setInfoTorpedos((String)h.get("value"));
                return;
            } else if (elem.equals("maxtractorpower")) {
                this.cmo.setInfoTractor((String)h.get("value"));
                return;
            } else if (elem.equals("maxcloakpower")) {
                this.cmo.setInfoCloak((String)h.get("value"));
                return;
            } else {
                if (!elem.equals("spaceObjects")) return;
                if ("yes".equals((String)h.get("cluster"))) {
                    this.cluster = true;
                    return;
                } else {
                    if (!"no".equals((String)h.get("cluster"))) throw new Exception("unexpected value for cluster: " + (String)h.get("cluster"));
                    this.cluster = false;
                }
            }
            return;
        } else if (elem.equals("container")) {
            if (this.cmf != null) {
                this.containers.add(this.cmf);
            }
            if (this.containers.isEmpty()) {
                this.cmf = new ContainerPanel((String)h.get("name"), (String)h.get("x"), (String)h.get("y"));
                this.MissionWindows.add(this.cmf);
                return;
            } else {
                this.cmf = new ContainerPanel();
                ((ContainerPanel)this.containers.lastElement()).add((Component)this.cmf, (String)h.get("constraints"));
            }
            return;
        } else if (elem.equals("toolbar")) {
            this.ctb = new JToolBar();
            this.ctb.setRollover(true);
            this.cmf.add((Component)this.ctb, (String)h.get("constraints"));
            return;
        } else if (elem.equals("bigmap")) {
            this.bigmap = new BigMapPanel(this.rescue, Integer.parseInt((String)h.get("w")), Integer.parseInt((String)h.get("h")));
            this.cmf.add(this.bigmap, (String)h.get("constraints"));
            return;
        } else if (elem.equals("smallmap")) {
            SmallMapPanel tmp = new SmallMapPanel(this.rescue, Integer.parseInt((String)h.get("w")), Integer.parseInt((String)h.get("h")));
            this.panels.add(tmp);
            this.cmf.add((Component)tmp, (String)h.get("constraints"));
            return;
        } else if (elem.equals("panel")) {
            if (h.get("nob") == null) {
                this.cip = new InterfacePanel(this.rescue, Integer.parseInt((String)h.get("w")), Integer.parseInt((String)h.get("h")));
            } else {
                this.cip = new InterfacePanel(this.rescue);
                this.cip.setupImages(new URL(this.path, (String)h.get("on")), new URL(this.path, (String)h.get("off")), new URL(this.path, (String)h.get("up")), new URL(this.path, (String)h.get("down")), new URL(this.path, (String)h.get("map")), Integer.parseInt((String)h.get("nob")));
            }
            this.panels.add(this.cip);
            this.cmf.add((Component)this.cip, (String)h.get("constraints"));
            return;
        } else if (elem.equals("shiplist")) {
            this.shiplist = new ShipsPanel(this.rescue, Integer.parseInt((String)h.get("w")), Integer.parseInt((String)h.get("h")), 1);
            this.panels.add(this.shiplist);
            this.cmf.add((Component)this.shiplist, (String)h.get("constraints"));
            return;
        } else if (elem.equals("baselist")) {
            this.baselist = new ShipsPanel(this.rescue, Integer.parseInt((String)h.get("w")), Integer.parseInt((String)h.get("h")), 2);
            this.panels.add(this.baselist);
            this.cmf.add((Component)this.baselist, (String)h.get("constraints"));
            return;
        } else if (elem.equals("button")) {
            JButton button = new JButton((String)h.get("name"));
            button.setActionCommand((String)h.get("action"));
            if (this.ctb == null) return;
            this.ctb.add(button);
            return;
        } else if (elem.equals("separator")) {
            if (this.ctb == null) return;
            this.ctb.addSeparator();
            return;
        } else if (elem.equals("text")) {
            JTextArea text = new JTextArea("Welcome to Rescue! Max");
            text.setBorder(null);
            text.setBackground(Color.BLACK);
            text.setForeground(Color.WHITE);
            text.setEditable(false);
            JScrollPane textScroll = new JScrollPane(text);
            textScroll.setBorder(null);
            Dimension size = new Dimension(Integer.parseInt((String)h.get("w")), Integer.parseInt((String)h.get("h")));
            textScroll.setPreferredSize(size);
            textScroll.setMinimumSize(size);
            textScroll.setMaximumSize(size);
            this.cmf.add((Component)textScroll, (String)h.get("constraints"));
            return;
        } else if (elem.equals("image")) {
            this.cip.setupImages(new URL(this.path, (String)h.get("on")), new URL(this.path, (String)h.get("off")), new URL(this.path, (String)h.get("up")), new URL(this.path, (String)h.get("down")), new URL(this.path, (String)h.get("map")), Integer.parseInt((String)h.get("nob")));
            return;
        } else if (elem.equals("color")) {
            this.cip.setCommandValue((String)h.get("action"), Integer.parseInt((String)h.get("value")), h.get("tooltip") != null ? (String)h.get("tooltip") : null);
            return;
        } else if (elem.equals("infotext")) {
            this.cip.setInfoText((String)h.get("type"), Integer.parseInt((String)h.get("x")), Integer.parseInt((String)h.get("y")), Integer.parseInt((String)h.get("w")), Integer.parseInt((String)h.get("h")), Integer.parseInt((String)h.get("lx")), Integer.parseInt((String)h.get("ly")), h.get("color") != null ? MissionLoader.getColor((String)h.get("color")) : Color.BLACK);
            return;
        } else if (elem.equals("infobar")) {
            this.cip.setInfoBar((String)h.get("type"), Integer.parseInt((String)h.get("x")), Integer.parseInt((String)h.get("y")), Integer.parseInt((String)h.get("w")), Integer.parseInt((String)h.get("h")), (String)h.get("direction"));
            return;
        } else if (elem.equals("shipinfo")) {
            this.shipinfo = new ShipInfoPanel(Integer.parseInt((String)h.get("w")), Integer.parseInt((String)h.get("h")), this.rescue);
            this.panels.add(this.shipinfo);
            this.cmf.add((Component)this.shipinfo, (String)h.get("constraints"));
            return;
        } else if (elem.equals("guitheme")) {
            if (((String)h.get("external")).equals("yes")) {
                this.external = true;
                return;
            } else {
                if (!((String)h.get("external")).equals("no")) throw new Exception("unexpected value for external: " + (String)h.get("external"));
                this.external = false;
            }
            return;
        } else if (elem.equals("sound")) {
            this.jukebox.setUpSound((String)h.get("name"), new URL(this.path, (String)h.get("file")));
            return;
        } else {
            if (!elem.equals("names") && !elem.equals("info") && !elem.equals("likes") && !elem.equals("sounds")) return;
            return;
        }
    }

    public void endElement(String elem) {
        if (!this.loadSO) {
            if (elem.equals("container")) {
                this.cmf = null;
                if (!this.containers.isEmpty()) {
                    this.cmf = (ContainerPanel)this.containers.lastElement();
                    this.containers.remove(this.cmf);
                }
            } else if (elem.equals("panel")) {
                this.cip = null;
            } else if (elem.equals("toolbar")) {
                this.ctb = null;
            }
        }
    }

    public void text(String text) {
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public boolean getCluster() {
        return this.cluster;
    }

    public void setCluster(boolean a) {
        this.cluster = a;
    }

    public ShipInfoPanel getShipInfoPanel() {
        return this.shipinfo;
    }

    public static Color getColor(String s) throws Exception {
        if (s.equals("black")) {
            return Color.BLACK;
        }
        if (s.equals("blue")) {
            return Color.BLUE;
        }
        if (s.equals("cyan")) {
            return Color.CYAN;
        }
        if (s.equals("darkgray")) {
            return Color.DARK_GRAY;
        }
        if (s.equals("gray")) {
            return Color.GRAY;
        }
        if (s.equals("green")) {
            return Color.GREEN;
        }
        if (s.equals("lightgray")) {
            return Color.LIGHT_GRAY;
        }
        if (s.equals("magenta")) {
            return Color.MAGENTA;
        }
        if (s.equals("orange")) {
            return Color.ORANGE;
        }
        if (s.equals("pink")) {
            return Color.PINK;
        }
        if (s.equals("red")) {
            return Color.RED;
        }
        if (s.equals("white")) {
            return Color.WHITE;
        }
        if (s.equals("yellow")) {
            return Color.YELLOW;
        }
        throw new Exception("unknown color " + s);
    }
}

