/*
 * Decompiled with CFR 0.152.
 */
package rescue.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rescue.MissionLoader;
import rescue.MissionObject;
import rescue.RunRescue;
import rescue.qdxml.XMLFileFilter;

public class MissionSetup
extends JDialog
implements ActionListener {
    private JPanel mainPanel = new JPanel();
    private RunRescue rescue;
    private MissionLoader currentMission;
    private GridBagConstraints gbc;
    private JRadioButton custom;
    private Box thebox;
    private JCheckBox clusterSimilarTypes;
    private Vector changlings;
    private JLabel missionRank;
    private String newGameOptions;
    private JLabel missionName;
    private JComboBox missionsBox;

    public MissionSetup(Frame parent, boolean modal) {
        super(parent, "Mission Setup", modal);
        this.initGUI();
        this.getContentPane().add(this.mainPanel);
    }

    public MissionSetup(Frame parent, boolean modal, RunRescue r, String missions) {
        this(parent, modal);
        this.rescue = r;
        JPanel topPanel = null;
        if (missions == null) {
            topPanel = new JPanel();
            topPanel.setLayout(new FlowLayout());
            JButton loadButton = new JButton("Load Mission");
            loadButton.setActionCommand("load");
            loadButton.addActionListener(this);
            topPanel.add(loadButton);
            topPanel.add(new JLabel("Current Mission Name:"));
            this.missionName = new JLabel();
            topPanel.add(this.missionName);
        } else {
            topPanel = this.makeDropDownTopPanel();
        }
        this.getContentPane().add((Component)topPanel, "North");
        if (missions == null) {
            this.loadMission(this.rescue.getMission());
        } else {
            this.loadMissions(r.getMissionsRootURL(), missions);
        }
    }

    public JPanel makeDropDownTopPanel() {
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new FlowLayout());
        topPanel.add(new JLabel("Mission:"));
        this.missionsBox = new JComboBox();
        this.missionsBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component tmp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setIcon(((MissionLoader)value).getIcon());
                return tmp;
            }
        });
        this.missionsBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    MissionSetup.this.loadMission((MissionLoader)e.getItem());
                }
            }
        });
        topPanel.add(this.missionsBox);
        return topPanel;
    }

    public void loadMissions(final URL base, final String options) {
        new Thread(){

            public void run() {
                String[] split = options.split("\\,");
                for (int c = 0; c < split.length; ++c) {
                    try {
                        MissionLoader ml = new MissionLoader(MissionSetup.this.rescue, base, split[c]);
                        MissionSetup.this.missionsBox.addItem(ml);
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }.start();
    }

    private void initGUI() {
        this.setResizable(false);
        JLabel missionSetup = new JLabel("Mission Setup", 0);
        missionSetup.setFont(new Font(null, 2, 20));
        this.clusterSimilarTypes = new JCheckBox("Cluster Similar Types");
        JPanel GameTypeButtons = new JPanel();
        GameTypeButtons.setLayout(new BoxLayout(GameTypeButtons, 1));
        GameTypeButtons.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Select a mission preset", 4, 2, new Font("SansSerif", 0, 11), new Color(60, 60, 60)));
        ButtonGroup GameTypeButtonGroup = new ButtonGroup();
        JRadioButton cadet = new JRadioButton("The Cadet's Game", true);
        cadet.setActionCommand("cadet");
        cadet.addActionListener(this);
        JRadioButton lieutenant = new JRadioButton("The Lieutenant's Game");
        lieutenant.setActionCommand("lieutenant");
        lieutenant.addActionListener(this);
        JRadioButton captain = new JRadioButton("The Captain's Game");
        captain.setActionCommand("captain");
        captain.addActionListener(this);
        JRadioButton admiral = new JRadioButton("The Admiral's Game");
        admiral.setActionCommand("admiral");
        admiral.addActionListener(this);
        this.custom = new JRadioButton("Custom");
        this.custom.addActionListener(this);
        GameTypeButtonGroup.add(cadet);
        GameTypeButtonGroup.add(lieutenant);
        GameTypeButtonGroup.add(captain);
        GameTypeButtonGroup.add(admiral);
        GameTypeButtonGroup.add(this.custom);
        GameTypeButtons.add(cadet);
        GameTypeButtons.add(lieutenant);
        GameTypeButtons.add(captain);
        GameTypeButtons.add(admiral);
        GameTypeButtons.add(Box.createVerticalStrut(10));
        GameTypeButtons.add(this.custom);
        this.missionRank = new JLabel("Mission Rank:", 0);
        JSeparator separator = new JSeparator();
        JButton cancelButton = new JButton(" Cancel ");
        cancelButton.setActionCommand("cancel");
        cancelButton.addActionListener(this);
        JButton okButton = new JButton("OK");
        okButton.setActionCommand("ok");
        okButton.addActionListener(this);
        this.mainPanel.setLayout(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.gbc.fill = 1;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.mainPanel.add((Component)missionSetup, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.mainPanel.add((Component)this.clusterSimilarTypes, this.gbc);
        JPanel panel1 = new JPanel(new GridBagLayout());
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        panel1.add((Component)GameTypeButtons, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        panel1.add((Component)this.missionRank, this.gbc);
        JPanel panel2 = new JPanel(new GridBagLayout());
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        panel2.add((Component)new JPanel(), this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        panel2.add((Component)cancelButton, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        panel2.add((Component)okButton, this.gbc);
        JPanel box1 = new JPanel(new BorderLayout());
        box1.add((Component)separator, "South");
        JPanel box2 = new JPanel(new BorderLayout());
        box2.add((Component)panel1, "North");
        box2.add(box1);
        box2.add((Component)panel2, "South");
        this.gbc.gridx = 1;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 3;
        this.mainPanel.add((Component)box2, this.gbc);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MissionSetup.this.closeDialog(evt);
            }
        });
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
    }

    public void loadMission(MissionLoader a) {
        this.currentMission = a;
        this.currentMission.loadImagesForSetup();
        this.clusterSimilarTypes.setSelected(this.currentMission.getCluster());
        if (this.missionName != null) {
            this.missionName.setIcon(this.currentMission.getIcon());
            this.missionName.setText(this.currentMission.getMissionName());
        }
        Vector v = this.currentMission.getMissionObjects();
        Vector<missionObjectPanel> allies = new Vector<missionObjectPanel>();
        Vector<missionObjectPanel> enemies = new Vector<missionObjectPanel>();
        Vector<missionObjectPanel> nutral = new Vector<missionObjectPanel>();
        String po = this.currentMission.getPlayerObject().getName();
        for (int i = 0; i < v.size(); ++i) {
            MissionObject cmo = (MissionObject)v.elementAt(i);
            if (cmo.getMin() == cmo.getMax()) continue;
            missionObjectPanel mop = new missionObjectPanel(cmo);
            if (cmo.isAllies(po)) {
                allies.add(mop);
                continue;
            }
            if (cmo.isEnemies(po)) {
                enemies.add(mop);
                continue;
            }
            nutral.add(mop);
        }
        Box missionSetupBox = new Box(1);
        if (allies.size() > 0) {
            this.addLabel("ALLIES", missionSetupBox);
            for (int i = 0; i < allies.size(); ++i) {
                missionSetupBox.add((JPanel)allies.elementAt(i));
            }
        }
        if (enemies.size() > 0) {
            this.addLabel("ENEMIES", missionSetupBox);
            for (int i = 0; i < enemies.size(); ++i) {
                missionSetupBox.add((JPanel)enemies.elementAt(i));
            }
        }
        if (nutral.size() > 0) {
            this.addLabel("NEUTRAL", missionSetupBox);
            for (int i = 0; i < nutral.size(); ++i) {
                missionSetupBox.add((JPanel)nutral.elementAt(i));
            }
        }
        this.custom.setSelected(true);
        if (this.thebox != null) {
            this.mainPanel.remove(this.thebox);
        }
        this.mainPanel.add((Component)missionSetupBox, this.gbc);
        this.validate();
        this.pack();
        this.repaint();
        this.thebox = missionSetupBox;
        Dimension frameSize = this.getOwner().getSize();
        Dimension aboutSize = this.getPreferredSize();
        int x = this.getOwner().getLocation().x + (frameSize.width - aboutSize.width) / 2;
        int y = this.getOwner().getLocation().y + (frameSize.height - aboutSize.height) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        this.setLocation(x, y);
        this.changlings = allies;
        this.changlings.addAll(enemies);
        this.changlings.addAll(nutral);
        this.checkMissionRank();
    }

    public void addLabel(String a, Box b) {
        FlowLayout f = new FlowLayout(3);
        f.setHgap(20);
        JPanel p = new JPanel(f);
        p.add(new JLabel("<html><u>" + a + "</u></html>"));
        b.add(p);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("load")) {
            JFileChooser fc1 = new JFileChooser("missions");
            XMLFileFilter filter1 = new XMLFileFilter();
            fc1.setFileFilter(filter1);
            int returnVal = fc1.showOpenDialog(this);
            if (returnVal == 0) {
                File file = fc1.getSelectedFile();
                try {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.loadMission(new MissionLoader(this.rescue, file.getParentFile().toURI().toURL(), file.getName()));
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
                catch (Exception a) {
                    JOptionPane.showMessageDialog(null, "Error Loading Mission File: " + file.getName() + ".\n" + a.getMessage(), "Load error!", 0);
                }
            }
        } else if (e.getActionCommand().equals("cancel")) {
            this.closeDialog(null);
        } else if (e.getActionCommand().equals("ok")) {
            if (this.rescue != null) {
                for (int c = 0; c < this.changlings.size(); ++c) {
                    ((missionObjectPanel)this.changlings.elementAt(c)).ok();
                }
                this.currentMission.setCluster(this.clusterSimilarTypes.isSelected());
                this.rescue.setMission(this.currentMission);
            } else {
                StringBuffer buffer = new StringBuffer();
                buffer.append(this.currentMission.getXMLFileName());
                buffer.append("\n");
                for (int c = 0; c < this.changlings.size(); ++c) {
                    buffer.append(((missionObjectPanel)this.changlings.elementAt(c)).getValue());
                    buffer.append(c == this.changlings.size() - 1 ? "\n" : ",");
                }
                buffer.append(this.clusterSimilarTypes.isSelected());
                this.newGameOptions = buffer.toString();
            }
            this.closeDialog(null);
        } else if (e.getActionCommand().equals("cadet")) {
            for (int c = 0; c < this.changlings.size(); ++c) {
                ((missionObjectPanel)this.changlings.elementAt(c)).setCurrentPreset(1);
            }
            this.repaint();
        } else if (e.getActionCommand().equals("lieutenant")) {
            for (int c = 0; c < this.changlings.size(); ++c) {
                ((missionObjectPanel)this.changlings.elementAt(c)).setCurrentPreset(2);
            }
            this.repaint();
        } else if (e.getActionCommand().equals("captain")) {
            for (int c = 0; c < this.changlings.size(); ++c) {
                ((missionObjectPanel)this.changlings.elementAt(c)).setCurrentPreset(3);
            }
            this.repaint();
        } else if (e.getActionCommand().equals("admiral")) {
            for (int c = 0; c < this.changlings.size(); ++c) {
                ((missionObjectPanel)this.changlings.elementAt(c)).setCurrentPreset(4);
            }
            this.repaint();
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public String getNewGameOptions() {
        return this.newGameOptions;
    }

    public void setVisible(boolean a) {
        if (a) {
            this.newGameOptions = null;
        }
        super.setVisible(a);
    }

    public void checkMissionRank() {
        String po = this.currentMission.getPlayerObject().getName();
        int rank1 = 0;
        int tot1 = 0;
        int cnt1 = 0;
        for (int c = 0; c < this.changlings.size(); ++c) {
            int r = ((missionObjectPanel)this.changlings.elementAt(c)).getCurrentRank(po);
            if (r == -1) continue;
            if (r == 8) {
                cnt1 += r;
                continue;
            }
            cnt1 += r;
            ++tot1;
        }
        rank1 = cnt1 / tot1;
        if (rank1 <= 1) {
            this.missionRank.setText("Mission Rank: Cadet");
        } else if (rank1 <= 2) {
            this.missionRank.setText("Mission Rank: Lieutenant");
        } else if (rank1 <= 3) {
            this.missionRank.setText("Mission Rank: Captain");
        } else {
            this.missionRank.setText("Mission Rank: Admiral");
        }
    }

    class missionObjectPanel
    extends JPanel {
        private MissionObject myMO;
        private JSlider slider;
        private BufferedImage icon;
        private int value;

        public missionObjectPanel(MissionObject cmo) {
            this.myMO = cmo;
            Dimension d = new Dimension(200, 30);
            this.setMaximumSize(d);
            this.setMinimumSize(d);
            this.setPreferredSize(d);
            this.setLayout(null);
            this.value = cmo.getNumber();
            this.slider = new JSlider(cmo.getMin(), cmo.getMax(), this.value);
            this.slider.setBounds(80, 0, 100, 30);
            this.slider.setMajorTickSpacing(1);
            this.slider.setSnapToTicks(true);
            this.slider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (missionObjectPanel.this.value != missionObjectPanel.this.slider.getValue()) {
                        MissionSetup.this.custom.setSelected(true);
                    }
                    missionObjectPanel.this.value = missionObjectPanel.this.slider.getValue();
                    MissionSetup.this.checkMissionRank();
                    missionObjectPanel.this.repaint();
                }
            });
            this.add(this.slider);
            this.icon = this.myMO.getIcon();
            String name = this.myMO.getName();
            JTextArea note = new JTextArea(name);
            note.setLineWrap(true);
            note.setWrapStyleWord(true);
            note.setOpaque(false);
            note.setFont(new JLabel().getFont().deriveFont(10.0f));
            note.setEditable(false);
            if (name.length() > 10) {
                note.setBounds(25, 2, 55, 30);
            } else {
                note.setBounds(25, 11, 55, 30);
            }
            Dimension noteSize = new Dimension(55, 30);
            note.setPreferredSize(noteSize);
            note.setMinimumSize(noteSize);
            note.setMaximumSize(noteSize);
            note.setFocusable(false);
            this.add(note);
        }

        public void paintComponent(Graphics g) {
            if (this.value != this.slider.getValue()) {
                this.slider.setValue(this.value);
            }
            super.paintComponent(g);
            g.setColor(Color.BLACK);
            g.drawString(this.value + "", 185, 20);
            g.drawImage(this.icon, 0, 5, this);
        }

        public void ok() {
            this.myMO.setNumber(this.value);
        }

        public int getValue() {
            return this.value;
        }

        public void setCurrentPreset(int a) {
            this.value = this.myMO.getCurrentPreset(a);
        }

        public int getCurrentRank(String p) {
            return this.myMO.getCurrentRank(p, this.value);
        }
    }
}

