/*
 * Decompiled with CFR 0.152.
 */
package rescue.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import rescue.RunRescue;
import rescue.spaceobjects.Base;
import rescue.spaceobjects.ImageObject;
import rescue.spaceobjects.MannedObject;
import rescue.spaceobjects.Planet;
import rescue.spaceobjects.Ship;
import rescue.spaceobjects.Wormhole;

public class ShipsPanel
extends JScrollPane
implements MouseWheelListener {
    private RunRescue rescue;
    private JList ShipsBox;
    private Vector SpaceObjectPanels;
    private Vector theOthers;
    private int type;
    private int height = 30;
    private int show;
    private int sort;

    public ShipsPanel(RunRescue rr, int w, int h, int t) {
        super(21, 31);
        this.setWheelScrollingEnabled(false);
        this.type = t;
        this.rescue = rr;
        Dimension size1 = new Dimension(w, h);
        this.setPreferredSize(size1);
        this.ShipsBox = new JList();
        this.ShipsBox.setCellRenderer(new CustomCellRenderer());
        this.ShipsBox.setFixedCellHeight(this.height);
        this.ShipsBox.setVisibleRowCount(4);
        this.ShipsBox.addMouseWheelListener(this);
        this.ShipsBox.setBackground(Color.BLACK);
        this.getViewport().setView(this.ShipsBox);
        this.setBorder(null);
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() < 0) {
            this.rescue.scrollShips(this.type == 1, true);
        } else {
            this.rescue.scrollShips(this.type == 1, false);
        }
    }

    public void newGame() {
        this.SpaceObjectPanels = new Vector();
        this.theOthers = new Vector();
        ImageObject[] so = this.rescue.getSpaceObjects();
        Ship player = this.rescue.getShip();
        if (this.type == 1) {
            this.theOthers.add(new ShipPanel(player));
        }
        for (int i = 0; i < so.length; ++i) {
            ImageObject soAtI = so[i];
            if (this.type == 1 && soAtI instanceof Ship && soAtI != player) {
                this.SpaceObjectPanels.add(new ShipPanel(soAtI));
                continue;
            }
            if (this.type != 2 || !(soAtI instanceof Planet) && !(soAtI instanceof Base) && !(soAtI instanceof Wormhole)) continue;
            this.SpaceObjectPanels.add(new ShipPanel(soAtI));
        }
        this.ShipsBox.setListData(this.SpaceObjectPanels);
        this.sort = 0;
        this.show = 3;
    }

    public void list() {
        Object a = this.ShipsBox.getSelectedValue();
        Collections.sort(this.SpaceObjectPanels);
        this.ShipsBox.setSelectedValue(a, false);
        this.ShipsBox.repaint();
        this.setShow(this.show);
    }

    public void scroll(boolean up) {
        JScrollBar a = this.getVerticalScrollBar();
        int b = a.getValue();
        if (up) {
            a.setValue(b - this.height);
        } else {
            a.setValue(b + this.height);
        }
    }

    public boolean canScroll(boolean up) {
        int b = this.getVerticalScrollBar().getValue();
        if (up) {
            return b != 0;
        }
        return b != this.height * (this.SpaceObjectPanels.size() - this.ShipsBox.getVisibleRowCount()) && this.SpaceObjectPanels.size() >= this.ShipsBox.getVisibleRowCount();
    }

    public void setSort(int a) {
        this.sort = a;
    }

    public void setShow(int a) {
        ImageObject soAtI;
        int i;
        this.show = a;
        Vector tmp = new Vector();
        Ship player = this.rescue.getShip();
        boolean redo = false;
        int scan = this.rescue.getScan();
        for (i = 0; i < this.theOthers.size(); ++i) {
            soAtI = ((ShipPanel)this.theOthers.elementAt(i)).getSO();
            if (!(soAtI instanceof Planet || soAtI instanceof Wormhole || ((MannedObject)soAtI).isAlive())) {
                this.theOthers.remove(i);
                --i;
                continue;
            }
            if (this.type == 1 && soAtI != player && scan >= ((MannedObject)soAtI).getCloakPower() && player.getSystem(5) == 0 && (this.show == 0 && ((MannedObject)soAtI).enemyOf(player.getNumber()) || this.show == 1 && ((MannedObject)soAtI).friendOf(player.getNumber()) || this.show == 2 && !((MannedObject)soAtI).enemyOf(player.getNumber()) && !((MannedObject)soAtI).friendOf(player.getNumber()) || this.show == 3)) {
                tmp.add(this.theOthers.remove(i));
                --i;
                redo = true;
                continue;
            }
            if (this.type != 2 || !(soAtI instanceof Wormhole) && scan < ((MannedObject)soAtI).getCloakPower() || player.getSystem(5) != 0 || !(this.show == 0 && soAtI instanceof Planet || this.show == 1 && soAtI instanceof Base || this.show == 2 && soAtI instanceof Wormhole) && this.show != 3) continue;
            tmp.add(this.theOthers.remove(i));
            --i;
            redo = true;
        }
        for (i = 0; i < this.SpaceObjectPanels.size(); ++i) {
            soAtI = ((ShipPanel)this.SpaceObjectPanels.elementAt(i)).getSO();
            if (!(soAtI instanceof Planet || soAtI instanceof Wormhole || ((MannedObject)soAtI).isAlive())) {
                this.SpaceObjectPanels.remove(i);
                --i;
                redo = true;
                continue;
            }
            if (this.type == 1 && (player.getSystem(5) != 0 || scan < ((MannedObject)soAtI).getCloakPower() || soAtI == player || this.show == 0 && !((MannedObject)soAtI).enemyOf(player.getNumber()) || this.show == 1 && !((MannedObject)soAtI).friendOf(player.getNumber()) || this.show == 2 && (((MannedObject)soAtI).enemyOf(player.getNumber()) || ((MannedObject)soAtI).friendOf(player.getNumber())))) {
                this.theOthers.add(this.SpaceObjectPanels.remove(i));
                --i;
                redo = true;
                continue;
            }
            if (this.type != 2 || !(player.getSystem(5) != 0 || !(soAtI instanceof Wormhole) && scan < ((MannedObject)soAtI).getCloakPower() || this.show == 0 && !(soAtI instanceof Planet) || this.show == 1 && !(soAtI instanceof Base)) && (this.show != 2 || soAtI instanceof Wormhole)) continue;
            this.theOthers.add(this.SpaceObjectPanels.remove(i));
            --i;
            redo = true;
        }
        if (redo) {
            this.ShipsBox.clearSelection();
            this.getVerticalScrollBar().setValue(0);
            this.SpaceObjectPanels.addAll(tmp);
            this.ShipsBox.revalidate();
        }
    }

    public int getSort() {
        return this.sort;
    }

    public int getShow() {
        return this.show;
    }

    public void clearSelection() {
        this.ShipsBox.clearSelection();
    }

    class ShipPanel
    extends JPanel
    implements Comparable {
        private BufferedImage pic;
        private ImageObject mySO;
        private boolean selected;

        public ShipPanel(ImageObject so) {
            this.setBackground(Color.BLACK);
            this.mySO = so;
            this.pic = new BufferedImage(172, 24, 5);
            Graphics g = this.pic.getGraphics();
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, 200, 24);
            g.setColor(Color.WHITE);
            g.drawString(so.getName(), 24, 10);
            g.drawImage(so.getIcon(), 2, 2, this);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.drawImage(this.pic, 3, 3, this);
            g.setColor(Color.WHITE);
            g.drawString(this.mySO.getDistanceToPlayer() + "", 27, 26);
            if (!(this.mySO instanceof Wormhole) && ShipsPanel.this.rescue.getScan() > 0) {
                g.drawRect(92, 17, 81, 8);
                g.setColor(Color.GREEN.darker());
                g.fillRect(93, 18, (int)(80.0 * ((double)((MannedObject)this.mySO).getTotalEnergy() / (double)((MannedObject)this.mySO).getMaxtotalenergy())), 7);
            }
        }

        public ImageObject getSO() {
            return this.mySO;
        }

        public boolean setSelected(boolean a) {
            if (this.selected == a) {
                return false;
            }
            this.selected = a;
            return true;
        }

        public int compareTo(Object o) {
            if (ShipsPanel.this.sort == 0) {
                int a = (int)this.mySO.distance(ShipsPanel.this.rescue.getShip());
                int b = (int)((ShipPanel)o).getSO().distance(ShipsPanel.this.rescue.getShip());
                return a - b;
            }
            int a = 0;
            int b = 0;
            if (this.mySO instanceof MannedObject) {
                a = ((MannedObject)this.mySO).getTotalEnergy();
            }
            if (((ShipPanel)o).getSO() instanceof MannedObject) {
                b = ((MannedObject)((ShipPanel)o).getSO()).getTotalEnergy();
            }
            return a - b;
        }
    }

    class CustomCellRenderer
    implements ListCellRenderer {
        CustomCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ShipPanel component = (ShipPanel)value;
            if (component.setSelected(isSelected)) {
                component.setBackground(isSelected ? Color.RED : Color.BLACK);
                if (isSelected) {
                    ShipsPanel.this.rescue.newSelection(ShipsPanel.this.type, component.getSO());
                }
            }
            return component;
        }
    }
}

