/*
 * Decompiled with CFR 0.152.
 */
package net.yura.grasshopper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.yura.grasshopper.ApplicationInfoProvider;
import net.yura.grasshopper.BugSubmitterMultipart;
import net.yura.grasshopper.BugSystemInfo;
import net.yura.grasshopper.LogText;

public class BugSubmitter {
    public static final String TF_MAIL_URL;
    public static final String FORM_MAIL_URL;
    public static final String RECIPIENT;
    static ApplicationInfoProvider extraInfoProvider;

    private static String getSetting(Properties prop, String name) throws Exception {
        String result = prop.getProperty(name);
        if (result == null) {
            throw new Exception("can not get setting for: " + name);
        }
        return result;
    }

    public static void setApplicationInfoProvider(ApplicationInfoProvider aip) {
        extraInfoProvider = aip;
    }

    static void submitBug(Object log, String cause) {
        BugSubmitter.submitBug(log, "no-email", cause);
    }

    static void submitBug(Object log, String email, String cause) {
        BugSubmitter.submitBug(log, email, BugSystemInfo.appName + " " + BugSystemInfo.version + " " + BugSystemInfo.locale + " Bug", cause, BugSystemInfo.appName, BugSystemInfo.version, BugSystemInfo.locale);
    }

    public static void submitBug(Object log, String email, String subject, String cause, String appName, String version, String locale) {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        if (extraInfoProvider != null) {
            extraInfoProvider.addInfoForSubmit(map);
        }
        map.put("log", log);
        map.put("appName", appName);
        map.put("appVersion", version);
        map.put("appLocale", locale);
        map.put("grasshopperVersion", "2.3");
        map.putAll(BugSystemInfo.addSystemInfo());
        map.put("recipient", RECIPIENT);
        map.put("subject", "GRASSHOPPER " + subject);
        map.put("email", email);
        map.put("env_report", "REMOTE_HOST,HTTP_USER_AGENT");
        if (cause != null) {
            map.put("cause", cause);
        }
        try {
            BugSubmitterMultipart.send(TF_MAIL_URL, map);
            System.out.println("[grasshopper] send ok");
        }
        catch (Throwable th) {
            try {
                map.put("grasshopperError", BugSubmitter.getStackTrace(th));
                BugSubmitter.doPost(FORM_MAIL_URL, map);
                System.out.println("[grasshopper] send ok ish " + th);
            }
            catch (Throwable th2) {
                System.out.println("[grasshopper] error sending: " + th + " " + th2);
            }
        }
    }

    public static String getStackTrace(Throwable th) {
        StringWriter error = new StringWriter();
        th.printStackTrace(new PrintWriter(error));
        return error.toString();
    }

    public static void doPost(OutputStreamWriter getpostb, Map map) throws IOException {
        boolean firstDone = false;
        Iterator enu = map.keySet().iterator();
        while (enu.hasNext()) {
            if (firstDone) {
                getpostb.append("&");
            } else {
                firstDone = true;
            }
            Object key = enu.next();
            getpostb.append(URLEncoder.encode(String.valueOf(key), "UTF-8"));
            getpostb.append("=");
            Object object = map.get(key);
            if (object instanceof LogText) {
                String line;
                while ((line = ((LogText)object).readLine()) != null) {
                    getpostb.append(URLEncoder.encode(line + "<br>\n", "UTF-8"));
                }
                continue;
            }
            String value = String.valueOf(object);
            value = value.replaceAll("\\n|\\r\\n", "<br>$0");
            getpostb.append(URLEncoder.encode(value, "UTF-8"));
        }
    }

    public static void doPost(String url, Map map) throws IOException {
        String line;
        URLConnection conn = new URL(url).openConnection();
        conn.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
        BugSubmitter.doPost(wr, map);
        wr.close();
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = rd.readLine()) != null) {
        }
        rd.close();
    }

    static {
        Properties settings = new Properties();
        String fileName = "/grasshopper.properties";
        try {
            settings.load(BugSubmitter.class.getResourceAsStream(fileName));
            TF_MAIL_URL = BugSubmitter.getSetting(settings, "url.tfMail");
            FORM_MAIL_URL = BugSubmitter.getSetting(settings, "url.formMail");
            RECIPIENT = BugSubmitter.getSetting(settings, "recipient");
        }
        catch (Exception ex) {
            ExceptionInInitializerError err = new ExceptionInInitializerError("can not load grasshopper settings from: " + fileName);
            err.initCause(ex);
            throw err;
        }
    }
}

