/*
 * Decompiled with CFR 0.152.
 */
package solarex.ui;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.ImageIcon;
import solarex.system.Solar;

public class ImageCache {
    public final ImageIcon[] planets = new ImageIcon[Solar.PlanetType.values().length];
    public final ImageIcon[] suns = new ImageIcon[Solar.SunType.values().length];
    public final ImageIcon station;
    public final ImageIcon spaceport;
    public final ImageIcon spiral;
    public final ImageIcon hyperspace;
    public final ImageIcon metalBand;
    public final ImageIcon newspaper;
    public final ImageIcon[] rockeaters = new ImageIcon[9];
    public final ImageIcon[] poisonbreathers = new ImageIcon[9];
    public final ImageIcon[] clonkniks = new ImageIcon[9];
    public final ImageIcon[] floatees = new ImageIcon[9];
    public final ImageIcon[] male = new ImageIcon[9];
    public final ImageIcon[] female = new ImageIcon[9];
    public final ImageIcon transmissionError;
    public final ImageIcon[] portraitBackgrounds = new ImageIcon[5];
    public final ImageIcon[] floateePortraitBackgrounds = new ImageIcon[4];
    public final ImageIcon[] clonknikPortraitBackgrounds = new ImageIcon[4];
    public final ImageIcon[] rockeaterPortraitBackgrounds = new ImageIcon[4];
    public final ImageIcon[] backdrops = new ImageIcon[5];
    private static final String PATH = "/solarex/resources/";

    public static ImageIcon createImageIcon(String path, String description) {
        ImageIcon result = null;
        URL imgURL = Class.class.getResource(path);
        if (imgURL != null) {
            result = new ImageIcon(imgURL, description);
        } else {
            System.err.println("Couldn't find file: " + path);
        }
        return result;
    }

    public ImageCache() {
        int i;
        this.station = ImageCache.createImageIcon("/solarex/resources/station.png", "Station");
        this.spaceport = ImageCache.createImageIcon("/solarex/resources/city.png", "City");
        this.spiral = ImageCache.createImageIcon("/solarex/resources/spiral.jpg", "Spiral");
        this.hyperspace = ImageCache.createImageIcon("/solarex/resources/backdrop/hyperspace.jpg", "Hyperspace");
        this.metalBand = ImageCache.createImageIcon("/solarex/resources/backdrop/metal_band.png", "Metal band");
        this.newspaper = ImageCache.createImageIcon("/solarex/resources/backdrop/newspaper_foil.jpg", "Newspaper");
        this.planets[Solar.PlanetType.BARE_ROCK.ordinal()] = ImageCache.createImageIcon("/solarex/resources/rock_planet.png", "Rocky planet");
        this.planets[Solar.PlanetType.ATM_ROCK.ordinal()] = ImageCache.createImageIcon("/solarex/resources/sand_atmos_planet.png", "Rocky planet");
        this.planets[Solar.PlanetType.ICE.ordinal()] = ImageCache.createImageIcon("/solarex/resources/ice_planet.png", "Rocky planet");
        this.planets[Solar.PlanetType.BIG_GAS.ordinal()] = ImageCache.createImageIcon("/solarex/resources/gas_planet.png", "Rocky planet");
        this.planets[Solar.PlanetType.SMALL_GAS.ordinal()] = ImageCache.createImageIcon("/solarex/resources/small_gas_planet.png", "Rocky planet");
        this.planets[Solar.PlanetType.RINGS.ordinal()] = ImageCache.createImageIcon("/solarex/resources/ring_planet.png", "Rocky planet");
        this.planets[Solar.PlanetType.CLOUD.ordinal()] = ImageCache.createImageIcon("/solarex/resources/cloud_planet.png", "Rocky planet");
        this.planets[Solar.PlanetType.EARTH.ordinal()] = ImageCache.createImageIcon("/solarex/resources/earth_planet.png", "Rocky planet");
        this.planets[Solar.PlanetType.GRAPHITE_ROCK.ordinal()] = ImageCache.createImageIcon("/solarex/resources/graphite_planet.png", "Rock carbon planet");
        this.planets[Solar.PlanetType.STATION_1.ordinal()] = this.station;
        this.suns[Solar.SunType.S_YELLOW.ordinal()] = ImageCache.createImageIcon("/solarex/resources/yellow_sun.png", "Rocky planet");
        this.suns[Solar.SunType.S_ORANGE.ordinal()] = ImageCache.createImageIcon("/solarex/resources/orange_sun.png", "Rocky planet");
        this.suns[Solar.SunType.S_RED_GIANT.ordinal()] = ImageCache.createImageIcon("/solarex/resources/red_giant.png", "Rocky planet");
        this.suns[Solar.SunType.S_WHITE_DWARF.ordinal()] = ImageCache.createImageIcon("/solarex/resources/white_dwarf.png", "Rocky planet");
        this.suns[Solar.SunType.S_BLUE_GIANT.ordinal()] = ImageCache.createImageIcon("/solarex/resources/blue_giant.png", "Rocky planet");
        this.suns[Solar.SunType.S_NEUTRON.ordinal()] = ImageCache.createImageIcon("/solarex/resources/neutron_star.png", "Neutron star");
        this.suns[Solar.SunType.S_BLACK_HOLE.ordinal()] = ImageCache.createImageIcon("/solarex/resources/black_hole.png", "Black hole");
        this.suns[Solar.SunType.S_BROWN_DWARF.ordinal()] = ImageCache.createImageIcon("/solarex/resources/brown_dwarf.png", "Brown dwarf");
        this.loadPortraits(this.rockeaters, "rockeater");
        this.loadPortraits(this.poisonbreathers, "poisonbreather");
        this.loadPortraits(this.clonkniks, "clonknik");
        this.loadPortraits(this.floatees, "floatee");
        this.loadPortraits(this.male, "terranean/male");
        this.loadPortraits(this.female, "terranean/female");
        this.transmissionError = ImageCache.createImageIcon("/solarex/resources/portrait_generic.png", "Transmission error");
        this.backdrops[0] = ImageCache.createImageIcon("/solarex/resources/backdrop/space_bg_1.jpg", "Backdrop 1");
        this.backdrops[1] = ImageCache.createImageIcon("/solarex/resources/backdrop/space_bg_2.jpg", "Backdrop 2");
        this.backdrops[4] = ImageCache.createImageIcon("/solarex/resources/backdrop/space_bg_5.jpg", "Backdrop 5");
        for (i = 0; i < this.portraitBackgrounds.length; ++i) {
            this.portraitBackgrounds[i] = ImageCache.createImageIcon("/solarex/resources/backdrop/portrait_bg_" + i + ".png", "");
        }
        for (i = 0; i < this.floateePortraitBackgrounds.length; ++i) {
            this.floateePortraitBackgrounds[i] = ImageCache.createImageIcon("/solarex/resources/backdrop/floatee_portraits/" + i + ".png", "");
        }
        for (i = 0; i < this.clonknikPortraitBackgrounds.length; ++i) {
            this.clonknikPortraitBackgrounds[i] = ImageCache.createImageIcon("/solarex/resources/backdrop/clonknik_portraits/" + i + ".png", "");
        }
        for (i = 0; i < this.rockeaterPortraitBackgrounds.length; ++i) {
            this.rockeaterPortraitBackgrounds[i] = ImageCache.createImageIcon("/solarex/resources/backdrop/rock_portraits/" + i + ".png", "");
        }
    }

    private void loadPortraits(ImageIcon[] ports, String name) {
        int stride = ports.length / 3;
        for (int n = 0; n < stride; ++n) {
            ports[0 + n] = this.loadPortraitPart(PATH + name + "/up_" + n + ".png", name);
            ports[stride + n] = this.loadPortraitPart(PATH + name + "/mid_" + n + ".png", name);
            ports[stride * 2 + n] = this.loadPortraitPart(PATH + name + "/low_" + n + ".png", name);
        }
    }

    private ImageIcon loadPortraitPart(String path, String name) {
        ImageIcon orig = ImageCache.createImageIcon(path, name);
        Image img = orig.getImage();
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        BufferedImage result = new BufferedImage(w, h, 2);
        Graphics gr = result.getGraphics();
        gr.drawImage(img, 0, 0, null);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int argb = result.getRGB(x, y);
                if ((argb & 0xFFFFFF) != 5725791) continue;
                result.setRGB(x, y, 0);
            }
        }
        return new ImageIcon(result);
    }
}

