/*
 * Decompiled with CFR 0.152.
 */
package solarex.ui.components;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Observer;
import java.util.Random;
import javax.swing.JPanel;
import solarex.ship.Ship;
import solarex.ship.components.ShipComponent;
import solarex.system.PlanetMiningData;
import solarex.system.PlanetResources;
import solarex.system.Solar;
import solarex.ui.ImageCache;
import solarex.ui.panels.PlanetViewPanel;
import solarex.util.FontFactory;

public class PlanetMiningGridPanel
extends JPanel {
    private ImageCache imageCache;
    private Color highlight = new Color(200, 255, 200, 128);
    private Color gridColor = new Color(0, 255, 0, 128);
    private int activeGridX = 5;
    private int activeGridY = 4;
    private int droneGridX = -1;
    private int droneGridY = -1;
    private final int grid = 8;
    private final int yoff = 8;
    private ShipComponent drone;
    private Solar planet;
    private Ship ship;
    private PlanetMiningData planetMiningData;
    private Observer observer;
    final int[] deposits;
    final long[] depositPositions;
    private final boolean[] harvested;
    final int[] gases;
    private final int[] pools;
    private final long[] poolPositions;

    public PlanetMiningGridPanel(Solar planet, Ship ship, ImageCache imageCache, ShipComponent drone, Observer observer) {
        this.ship = ship;
        this.observer = observer;
        this.planet = planet;
        this.imageCache = imageCache;
        this.drone = drone;
        this.planetMiningData = new PlanetMiningData();
        this.setBackground(new Color(0, 9, 17));
        Random rng = PlanetResources.getPlanetRng(planet);
        this.gases = PlanetResources.calculateAtmosphere(planet, rng);
        int fluidsCount = PlanetResources.Fluids.values().length;
        this.pools = new int[fluidsCount];
        this.poolPositions = new long[fluidsCount];
        PlanetResources.calculateFluids(planet, this.gases, rng, this.pools, this.poolPositions);
        int metalsCount = PlanetResources.Metals.values().length;
        this.deposits = new int[metalsCount];
        this.depositPositions = new long[metalsCount];
        PlanetResources.calculateMetals(planet, rng, this.deposits, this.depositPositions);
        this.harvested = new boolean[64];
        MiningMouseHandler handler = new MiningMouseHandler();
        this.addMouseListener(handler);
        this.addMouseMotionListener(handler);
        this.updateSurfaceObserver();
        this.updateDroneObserver();
    }

    @Override
    public void paint(Graphics gr) {
        super.paint(gr);
        ((Graphics2D)gr).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        Image img = this.planet != null ? this.imageCache.planets[this.planet.ptype.ordinal()].getImage() : this.imageCache.planets[Solar.PlanetType.ATM_ROCK.ordinal()].getImage();
        int w = this.getWidth();
        int h = this.getHeight();
        gr.drawImage(img, 8, 8, w - 48, h - 16, null);
        gr.setColor(this.gridColor);
        int xstep = w / 8;
        int ystep = h / 8;
        int ww = (w - 2 * xstep) / xstep * xstep;
        int hh = (h - 2 * ystep) / ystep * ystep;
        for (int x = 0; x <= ww; x += xstep) {
            gr.fillRect(x + xstep, ystep + 1 + 8, 1, hh - 1);
        }
        for (int y = 0; y <= hh; y += ystep) {
            gr.fillRect(xstep + 1, y + ystep + 8, ww - 1, 1);
        }
        Font font = FontFactory.getSmallest();
        gr.setFont(font);
        gr.setColor(Color.WHITE);
        gr.drawString(this.drone.getName(), this.droneGridX * xstep + xstep / 2 - 5, this.droneGridY * ystep + ystep / 2 - 5);
        gr.drawOval(this.droneGridX * xstep + xstep / 2 - 5, this.droneGridY * ystep + ystep / 2 - 5 + 8, 10, 10);
        gr.setColor(Color.BLACK);
        gr.drawOval(this.droneGridX * xstep + xstep / 2 - 10, this.droneGridY * ystep + ystep / 2 - 10 + 8, 20, 20);
        gr.setColor(this.highlight);
        gr.fillRect(this.activeGridX * xstep + 1, this.activeGridY * ystep + 1 + 8, xstep - 1, ystep - 1);
        font = FontFactory.getNormal();
        gr.setFont(font);
        gr.setColor(Color.CYAN);
        gr.drawString("Click quadrant to explore", 7, 30);
    }

    private void updateSurfaceObserver() {
        PlanetMiningData.Surface surface = this.planetMiningData.getSurfaceData(this.planet, this.activeGridX - 1, this.activeGridY - 1);
        if (this.observer != null) {
            this.observer.update(null, (Object)surface);
        }
    }

    private void updateDroneObserver() {
        int gridIndex = this.droneGridY * 6 + this.droneGridX;
        if (this.ship != null && this.ship.player != null && this.droneGridX >= 1 && this.droneGridY >= 1 && this.droneGridX < 7 && this.droneGridY < 7) {
            this.ship.player.setExplored(this.planet, gridIndex);
        }
        if (this.observer != null) {
            if (this.drone.getName().contains("Gas Filtration Drone")) {
                String s = "Normal atmosphere.";
                this.observer.update(null, s);
            } else if (this.drone.getName().contains("Fluid Distillation Drone")) {
                String s = this.buildFluidsReport(gridIndex);
                this.observer.update(null, s);
            } else {
                String s = this.buildMininghReport(gridIndex);
                this.observer.update(null, s);
            }
        }
    }

    public void doMining() {
        int gridIndex = this.droneGridY * 6 + this.droneGridX;
        if (this.drone.getName().contains("Gas Filtration Drone")) {
            int[] amounts = new int[this.gases.length];
            for (int i = 0; i < this.gases.length; ++i) {
                if (this.gases[i] == 0) continue;
                int n = i;
                amounts[n] = amounts[n] + (this.gases[i] + (int)(Math.random() * (double)this.gases[i]));
            }
            this.observer.update(null, amounts);
        } else if (this.drone.getName().contains("Fluid Distillation Drone")) {
            int[] amounts = new int[this.pools.length];
            if (!this.harvested[gridIndex]) {
                for (int i = 0; i < this.pools.length; ++i) {
                    if (this.pools[i] == 0) continue;
                    int n = i;
                    amounts[n] = amounts[n] + (this.pools[i] + (int)(Math.random() * (double)this.pools[i]));
                }
                this.harvested[gridIndex] = true;
            }
            this.observer.update(null, amounts);
        } else {
            int[] amounts = new int[this.deposits.length];
            if (!this.harvested[gridIndex]) {
                for (int i = 0; i < this.deposits.length; ++i) {
                    int bit;
                    if (this.deposits[i] == 0 || (this.depositPositions[i] & (long)(bit = 1 << gridIndex)) == 0L) continue;
                    int n = i;
                    amounts[n] = amounts[n] + (this.deposits[i] + (int)(Math.random() * (double)this.deposits[i]));
                }
                this.harvested[gridIndex] = true;
            }
            this.observer.update(null, amounts);
        }
    }

    private String buildFluidsReport(int gridIndex) {
        StringBuilder builder = new StringBuilder();
        if (this.droneGridX == -1 || this.droneGridY == -1) {
            builder.append("<html>Drone Report:<br><br>Not landed yet.</html>");
        } else if (this.harvested[gridIndex]) {
            builder.append("<html>Drone Report:<br><br>Quadrant was harvested already.</html>");
        } else {
            PlanetResources.Fluids[] values = PlanetResources.Fluids.values();
            ArrayList<String> alist = new ArrayList<String>();
            for (int i = 0; i < this.pools.length; ++i) {
                int bit;
                if (this.pools[i] == 0 || (this.poolPositions[i] & (long)(bit = 1 << this.droneGridY * 6 + this.droneGridX)) == 0L) continue;
                String s = PlanetViewPanel.richness[Math.min(this.pools[i], PlanetViewPanel.richness.length - 1)];
                s = s.replaceFirst("%1", values[i].toString().toLowerCase());
                s = s.replaceFirst("%2", values[i].color);
                s = s.replace("depsits", "pools");
                char order = (char)(122 - this.deposits[i]);
                alist.add("" + order + s);
            }
            Collections.sort(alist);
            builder.append("<html>Drone Report:<br><br>");
            if (alist.isEmpty()) {
                builder.append("No suitable fluid pools found in this quadrant.<br>");
            } else {
                for (String s : alist) {
                    builder.append(s.substring(1));
                    builder.append("<br>");
                }
            }
            builder.append("</html>");
        }
        return builder.toString();
    }

    private String buildMininghReport(int gridIndex) {
        StringBuilder builder = new StringBuilder();
        if (this.droneGridX == -1 || this.droneGridY == -1) {
            builder.append("<html>Drone Report:<br><br>Not landed yet.</html>");
        } else if (this.harvested[gridIndex]) {
            builder.append("<html>Drone Report:<br><br>Quadrant was mined already.</html>");
        } else {
            PlanetResources.Metals[] values = PlanetResources.Metals.values();
            ArrayList<String> alist = new ArrayList<String>();
            for (int i = 0; i < this.deposits.length; ++i) {
                int bit;
                if (this.deposits[i] == 0 || (this.depositPositions[i] & (long)(bit = 1 << this.droneGridY * 6 + this.droneGridX)) == 0L) continue;
                String s = PlanetViewPanel.richness[Math.min(this.deposits[i], PlanetViewPanel.richness.length - 1)];
                s = s.replaceFirst("%1", values[i].toString().toLowerCase());
                s = s.replaceFirst("%2", values[i].color);
                char order = (char)(122 - this.deposits[i]);
                alist.add("" + order + s);
            }
            Collections.sort(alist);
            builder.append("<html>Drone Report:<br><br>");
            if (alist.isEmpty()) {
                builder.append("No minable resources found in this quadrant.<br>");
            } else {
                for (String s : alist) {
                    builder.append(s.substring(1));
                    builder.append("<br>");
                }
            }
            builder.append("</html>");
        }
        return builder.toString();
    }

    private class MiningMouseHandler
    implements MouseListener,
    MouseMotionListener {
        private final int[] xy = new int[2];

        private MiningMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mouseToGrid(e.getX(), e.getY(), this.xy);
            if (this.xy[0] >= 1 && this.xy[0] < 7 && this.xy[1] >= 1 && this.xy[1] < 7 && (this.xy[0] != PlanetMiningGridPanel.this.droneGridX || this.xy[1] != PlanetMiningGridPanel.this.droneGridY)) {
                PlanetMiningGridPanel.this.droneGridX = this.xy[0];
                PlanetMiningGridPanel.this.droneGridY = this.xy[1];
                PlanetMiningGridPanel.this.updateDroneObserver();
                PlanetMiningGridPanel.this.repaint();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.mouseToGrid(e.getX(), e.getY(), this.xy);
            if (PlanetMiningGridPanel.this.planet != null && this.xy[0] >= 0 && this.xy[0] < 7 && this.xy[1] >= 0 && this.xy[1] < 7 && (this.xy[0] != PlanetMiningGridPanel.this.activeGridX || this.xy[1] != PlanetMiningGridPanel.this.activeGridY)) {
                PlanetMiningGridPanel.this.activeGridX = this.xy[0];
                PlanetMiningGridPanel.this.activeGridY = this.xy[1];
                PlanetMiningGridPanel.this.updateSurfaceObserver();
                PlanetMiningGridPanel.this.repaint();
            }
        }

        private void mouseToGrid(int mx, int my, int[] result) {
            int w = PlanetMiningGridPanel.this.getWidth();
            int h = PlanetMiningGridPanel.this.getHeight();
            int xstep = w / 8;
            int ystep = h / 8;
            result[0] = mx / xstep;
            result[1] = (my -= 8) / ystep;
        }
    }
}

