/*
 * Decompiled with CFR 0.152.
 */
package solarex.ui.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import solarex.evolution.World;
import solarex.galaxy.Galaxy;
import solarex.ship.Ship;
import solarex.system.Society;
import solarex.system.Solar;
import solarex.ui.ImageCache;
import solarex.ui.components.PortraitPanel;
import solarex.ui.panels.BulletinBoardPanel;
import solarex.ui.panels.ProspectorsAgencyPanel;
import solarex.ui.panels.ShipComponentTrade;
import solarex.ui.panels.ShipyardPanel;
import solarex.ui.panels.TradePanel;
import solarex.util.ComponentFactory;
import solarex.util.FontFactory;
import solarex.util.RandomHelper;

public class SpaceStationPanel
extends JPanel {
    private Random rng;
    private Solar station;
    private final Galaxy galaxy;
    private final World world;
    private final Ship ship;
    private final ImageCache imageCache;
    private static final String[] welcomeTexts = new String[]{"<html>Welcome to your last stop before nowhere. We have second hand and repaired goods for excellent prices.</html>", "<html>Thank you for visiting. We have the best goods and services within five lightyears, but quality has a price.</html>", "<html>You chose the right place to rest from your journey, traveller. We have quality services for fair prices.</html>", "<html>Your eyes long for nature and something green after months in a space ship? Visit our unique herbarium and feel well!</html>", "<html>Yawn ... oh, a visitor! At your service, just a minute, you know it's rush hour, er week.</html>", "<html>Smuggler? Outlaw? Be warned, we do not tolerate lawbreakers over here. Behave and you'll be welcome.</html>", "<html>This is the church of technogology! We have the newest, greatest gadgets and everything else you want.</html>", "<html>Welcome to our abode in the sky. From low orbit you'll have a great view over the planet.</html>", "<html>Damn technology ... where is this spare fuse? Hey! Oh, hello traveller. Just feel home in our trusty metal jewel!</html>", "<html>Did you ever dream of walking on the ceiling? Then you are just right here! At least until we have fixed the gravity generator.</html>", "<html>Hello stranger! Check our market deck for commodities to trade  and don't forget to visit our wideley known entertainment establishments.</html>"};
    private static final String[] stationTexts = new String[]{"<html><p>This station is more of a wreck than a place to stay. Several decks have been left up, and even in the remaining space electricity and artifial gravity suffer from freqent dropouts. The air is thin and smells bad. Chewing gum, band-aid and plugs seem to be common methods to repair small breaches in the hull, larger plates of scrap metal welded over bigger holes and cracks almost look professional in comparison.</p></html>", "<html><p>While the staff appears friendly and helpful, this space station has definitely seen better days. Corroded metal, puddles of oil in places, and opened wall covers showing the dated electric wiring make you wonder how long this tin can will stay air tight.</p><br><p>Maybe it is better to keep the pressure suit on all the time when leaving the ship, just in case.</p></html>", "<html><p>An old but well maintained space station. Nothing special to mention about this one, everything seems to be in place and working as it should. Maybe a lack of comfort can be complained about, but most space travelers have seen much worse.</p></html>", "<html><p>Not the most modern station, but a well maintained one. This should be a good place to stay for a while and rest from a longer journey. They offer a nice lounge, a herbarium and even a sauna for visitors. Not to mention two dark bars and a restaurant which serves actually edible food.</p></html>", "<html><p>A very modern space station. Polished metal, fresh paint and the well known smell of new electronics mark this place.The staff is high nosed, well knowing how special their station is, compared to the average station of the outer regions.</p></html>", "<html><p>Run by a robotic civilization, this station is all open to space. No atmosphere or shielding provided, but the usual commodities for biological lifeforms like water and food are sold.</p><br><p>Service here is prompt and reliable, but you must obey their laws absolutely, or you'll be recycled.</p></html>"};
    private static final String[] spaceportTexts = new String[]{"<html><p>Just an ordinary spaceport. A tower with somewhat up to date equipment, a landing field without too many potholes, some hangars to the side of the landing area along with a few smaller buildings for registration, import/export licenses and other legal neccessities.Things look mostly clean and well maintained here. Security staff can be seen now and then, and it seems to be a fairly safe place.</p></html>", "<html><p>Dug into the ground under the landing field, the facilities of this space port are safe from radiation and occasional meteor hits. But having just artificial light and metal plated walls makes the stay here not much better than on board of a space ship.</p></html>", "<html><p>This space port sprawls widely over a large open plain. Ground prices don't seem to be an issue here, underground construction has been avoided and most buildings are just one story tall. Which makes you wonder if this secretly is a base of a yet unseen gastropod race, who like things all in one flat space.</p></html>", "<html><p>Twin towers? No, a full tower family! This spaceport must have been designed by a tower fanatic. Well, also a basement fanatic,since most building seems to stretch as deep into the planets crustas they tower above. And, antennas! Lots of antennas. Did I mention antennans yet? Each and every place here is plastered with antennas of all shapes and sizes. A civilzation of spies? A deep space phone company? SETI 2061? Well, at least you can send hypergrams to almost all known places from here in no time!</p></html>", "<html><p>This space port is the public part of a military fortification. In a distance giant cannons and force field projectors are looming in the sky, some suspicios hills farther in the fields might well be disguisedhangars or bunkers. Vibrations of the ground tell of huge underground power stations to feed the war machines.At least one can feel safe here, even a mid size alien invasion will be stopped, at least until you ran up your ship and rocketed off into space.</p></html>", "<html><p>The crater marked landing field already gave a first impression, but the buildings just confirm: This spaceport has seen much better times. At least the age of the complex tells that it won't crumble in the next few hours, some of the buildings and machines look rather ancient and still do their jobs.</p></html>", "<html><p>The inhabitants here are of noticeable smaller size than the average human. Door frames have become dangerous passages, and in some rooms it's even difficult to stand upright. But at least it's on a planet, with safe ground. And the bar nearby is just terrific.</p></html>", "<html><p>Clonknik space ports are always an experience. Machine covers, shieldings, walls and such are completely unknown to this robotic civilization. Open high power conductors, microwave tunnels, plasma fields and all kind of dangerous looking machinery are placed where they seemed to fit, connected by metal girders, cables and wires, towering into the sky. Energy flares blind the eyes, radiation bursts flash the scenery. The Clonknik might know where it's safe to be, but for a human this is a labyrinth of death traps. Luckily the Clonknik offer guide bots to lead visitors through the machine and energy jungle.</p></html>"};
    private static final String[] spaceportFloatingTexts = new String[]{"<html><p>Build on a giant ice floe, floating on the surface of denser layers of the atmosphere, this space port definitely is a sight when arriving from space. Once landed, it is much like any other spaceport, though, a big, fiberconcrete covered landing field, a control tower and some additional buildings. A settlement of traders, miners and scientists was founded nearby. There are rumors that in the deeper layers of the planets atmosphere, big riches can be found.</p></html>"};
    private JLabel advertisementLabel;
    private JButton agencyButton;
    private JPanel borderPanel;
    private JButton bulletinBoardButton;
    private JButton commodityButton;
    private JButton equipmentShopButton;
    private JLabel governmentField;
    private JLabel governmentLabel;
    private JLabel governmentLabel1;
    private JLabel governmentLabel2;
    private JLabel impressionLabel;
    private JLabel inhabitantsField;
    private JLabel inhabitantsLabel2;
    private JLabel inhabitantsLabel4;
    private JLabel majorityField;
    private JPanel portraitContainer;
    private JLabel portraitLabel;
    private JButton shipyardButton;
    private JLabel techLabel;
    private JLabel welcomeLabel;

    public SpaceStationPanel(World world, Galaxy galaxy, Ship ship, ImageCache imageCache) {
        this.world = world;
        this.galaxy = galaxy;
        this.imageCache = imageCache;
        this.ship = ship;
        this.initComponents();
        this.welcomeLabel.setFont(FontFactory.getPanelHeading());
        this.advertisementLabel.setFont(FontFactory.getNormal());
        this.impressionLabel.setFont(FontFactory.getNormal());
        ComponentFactory.customizeButton(this.agencyButton);
        ComponentFactory.customizeButton(this.bulletinBoardButton);
        ComponentFactory.customizeButton(this.commodityButton);
        ComponentFactory.customizeButton(this.equipmentShopButton);
        ComponentFactory.customizeButton(this.shipyardButton);
    }

    private void initComponents() {
        this.borderPanel = new JPanel();
        this.welcomeLabel = new JLabel();
        this.portraitContainer = new JPanel();
        this.portraitLabel = new JLabel();
        this.agencyButton = new JButton();
        this.shipyardButton = new JButton();
        this.bulletinBoardButton = new JButton();
        this.commodityButton = new JButton();
        this.majorityField = new JLabel();
        this.governmentLabel = new JLabel();
        this.inhabitantsLabel2 = new JLabel();
        this.techLabel = new JLabel();
        this.inhabitantsLabel4 = new JLabel();
        this.inhabitantsField = new JLabel();
        this.impressionLabel = new JLabel();
        this.advertisementLabel = new JLabel();
        this.governmentLabel1 = new JLabel();
        this.governmentField = new JLabel();
        this.governmentLabel2 = new JLabel();
        this.equipmentShopButton = new JButton();
        this.setBackground(Color.black);
        this.setForeground(Color.green);
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.borderPanel.setBackground(new Color(0, 51, 51));
        this.borderPanel.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.borderPanel.setForeground(Color.green);
        this.borderPanel.setMinimumSize(new Dimension(600, 540));
        this.borderPanel.setPreferredSize(new Dimension(800, 540));
        this.borderPanel.setLayout(null);
        this.welcomeLabel.setFont(new Font("SansSerif", 1, 18));
        this.welcomeLabel.setForeground(Color.white);
        this.welcomeLabel.setText("Welcome to xyz station!");
        this.borderPanel.add(this.welcomeLabel);
        this.welcomeLabel.setBounds(20, 20, 660, 24);
        this.portraitContainer.setBackground(Color.darkGray);
        this.portraitContainer.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.portraitContainer.setPreferredSize(new Dimension(127, 130));
        this.portraitContainer.setLayout(new BorderLayout());
        this.portraitLabel.setFont(new Font("SansSerif", 1, 14));
        this.portraitLabel.setHorizontalAlignment(0);
        this.portraitLabel.setText("<html><center>Here<br>be<br>portrait.</center></html>");
        this.portraitContainer.add((Component)this.portraitLabel, "Center");
        this.borderPanel.add(this.portraitContainer);
        this.portraitContainer.setBounds(620, 60, 127, 130);
        this.agencyButton.setText("Prospectors Agency");
        this.agencyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpaceStationPanel.this.agencyButtonActionPerformed(evt);
            }
        });
        this.borderPanel.add(this.agencyButton);
        this.agencyButton.setBounds(120, 250, 170, 30);
        this.shipyardButton.setText("Shipyard");
        this.shipyardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpaceStationPanel.this.shipyardButtonActionPerformed(evt);
            }
        });
        this.borderPanel.add(this.shipyardButton);
        this.shipyardButton.setBounds(120, 410, 170, 30);
        this.bulletinBoardButton.setText("Bulletin Board");
        this.bulletinBoardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpaceStationPanel.this.bulletinBoardButtonActionPerformed(evt);
            }
        });
        this.borderPanel.add(this.bulletinBoardButton);
        this.bulletinBoardButton.setBounds(120, 330, 170, 30);
        this.commodityButton.setText("Commodity Exchange");
        this.commodityButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpaceStationPanel.this.commodityButtonActionPerformed(evt);
            }
        });
        this.borderPanel.add(this.commodityButton);
        this.commodityButton.setBounds(120, 290, 170, 30);
        this.majorityField.setFont(new Font("SansSerif", 0, 13));
        this.majorityField.setForeground(Color.white);
        this.majorityField.setText("Democratic");
        this.borderPanel.add(this.majorityField);
        this.majorityField.setBounds(280, 70, 110, 16);
        this.governmentLabel.setFont(new Font("SansSerif", 1, 13));
        this.governmentLabel.setForeground(Color.green);
        this.governmentLabel.setText("Majority:");
        this.borderPanel.add(this.governmentLabel);
        this.governmentLabel.setBounds(210, 70, 70, 18);
        this.inhabitantsLabel2.setFont(new Font("SansSerif", 1, 13));
        this.inhabitantsLabel2.setForeground(Color.green);
        this.inhabitantsLabel2.setText("Tech. level:");
        this.borderPanel.add(this.inhabitantsLabel2);
        this.inhabitantsLabel2.setBounds(20, 130, 90, 18);
        this.techLabel.setFont(new Font("SansSerif", 0, 13));
        this.techLabel.setForeground(Color.white);
        this.techLabel.setText("3");
        this.borderPanel.add(this.techLabel);
        this.techLabel.setBounds(110, 130, 80, 16);
        this.inhabitantsLabel4.setFont(new Font("SansSerif", 1, 13));
        this.inhabitantsLabel4.setForeground(Color.green);
        this.inhabitantsLabel4.setText("Population:");
        this.borderPanel.add(this.inhabitantsLabel4);
        this.inhabitantsLabel4.setBounds(20, 100, 100, 18);
        this.inhabitantsField.setFont(new Font("SansSerif", 0, 13));
        this.inhabitantsField.setForeground(Color.white);
        this.inhabitantsField.setText("1712");
        this.borderPanel.add(this.inhabitantsField);
        this.inhabitantsField.setBounds(110, 100, 80, 16);
        this.impressionLabel.setFont(new Font("SansSerif", 0, 12));
        this.impressionLabel.setForeground(Color.lightGray);
        this.impressionLabel.setText("jLabel2");
        this.impressionLabel.setVerticalAlignment(1);
        this.borderPanel.add(this.impressionLabel);
        this.impressionLabel.setBounds(400, 240, 350, 230);
        this.advertisementLabel.setFont(new Font("SansSerif", 0, 12));
        this.advertisementLabel.setForeground(Color.lightGray);
        this.advertisementLabel.setText("jLabel2");
        this.advertisementLabel.setVerticalAlignment(1);
        this.borderPanel.add(this.advertisementLabel);
        this.advertisementLabel.setBounds(400, 70, 200, 140);
        this.governmentLabel1.setFont(new Font("SansSerif", 1, 13));
        this.governmentLabel1.setForeground(Color.green);
        this.governmentLabel1.setText("Our Services:");
        this.borderPanel.add(this.governmentLabel1);
        this.governmentLabel1.setBounds(20, 200, 180, 18);
        this.governmentField.setFont(new Font("SansSerif", 0, 13));
        this.governmentField.setForeground(Color.white);
        this.governmentField.setText("Democratic");
        this.borderPanel.add(this.governmentField);
        this.governmentField.setBounds(110, 70, 80, 16);
        this.governmentLabel2.setFont(new Font("SansSerif", 1, 13));
        this.governmentLabel2.setForeground(Color.green);
        this.governmentLabel2.setText("Government:");
        this.borderPanel.add(this.governmentLabel2);
        this.governmentLabel2.setBounds(20, 70, 100, 18);
        this.equipmentShopButton.setText("Equipment Shop");
        this.equipmentShopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpaceStationPanel.this.equipmentShopButtonActionPerformed(evt);
            }
        });
        this.borderPanel.add(this.equipmentShopButton);
        this.equipmentShopButton.setBounds(120, 370, 170, 30);
        this.add((Component)this.borderPanel, new GridBagConstraints());
    }

    private void agencyButtonActionPerformed(ActionEvent evt) {
        this.switchTo(new ProspectorsAgencyPanel(this.station, this));
    }

    private void shipyardButtonActionPerformed(ActionEvent evt) {
        this.switchTo(new ShipyardPanel(this.station, this));
    }

    private void bulletinBoardButtonActionPerformed(ActionEvent evt) {
        this.switchTo(new BulletinBoardPanel(this.imageCache, this.world, this.galaxy, this.station, this, this.ship));
    }

    private void commodityButtonActionPerformed(ActionEvent evt) {
        this.switchTo(new TradePanel(this.station, this.ship, this));
    }

    private void equipmentShopButtonActionPerformed(ActionEvent evt) {
        this.switchTo(new ShipComponentTrade(this.station, this.ship, this));
    }

    private void switchTo(JComponent panel) {
        Container c = this.getParent();
        c.remove(this);
        c.add(panel);
        c.validate();
    }

    public void update(Solar station) {
        this.station = station;
        this.rng = RandomHelper.createRNG(station.seed + (long)(station.radius * 1000) + (long)station.orbit + (long)station.eet + (long)(station.name.hashCode() << 16));
        if (this.ship.getState() == Ship.State.DOCKED && this.ship.spaceBodySeed == station.seed) {
            this.welcomeLabel.setText("Welcome to " + station.name + "!");
        } else {
            this.welcomeLabel.setText("Radio link to " + station.name + " was established ...");
        }
        this.inhabitantsField.setText("" + station.society.population);
        this.techLabel.setText("" + station.society.techLevel);
        this.advertisementLabel.setText(welcomeTexts[(int)(this.rng.nextDouble() * (double)welcomeTexts.length)]);
        if (station.btype == Solar.BodyType.SPACEPORT) {
            if (station.society.race == Society.Race.Clonkniks) {
                this.impressionLabel.setText(spaceportTexts[spaceportTexts.length - 1]);
            } else if (station.getParent() != null && (station.getParent().ptype == Solar.PlanetType.BIG_GAS || station.getParent().ptype == Solar.PlanetType.RINGS)) {
                this.impressionLabel.setText(spaceportFloatingTexts[(int)(this.rng.nextDouble() * (double)spaceportFloatingTexts.length)]);
            } else {
                this.impressionLabel.setText(spaceportTexts[(int)(this.rng.nextDouble() * (double)spaceportTexts.length - 1.0)]);
            }
        } else if (station.society.race == Society.Race.Clonkniks) {
            this.impressionLabel.setText(stationTexts[stationTexts.length - 1]);
        } else {
            this.impressionLabel.setText(stationTexts[(int)(this.rng.nextDouble() * (double)stationTexts.length - 1.0)]);
        }
        this.governmentField.setText(station.society.governmentType.toString());
        this.majorityField.setText(station.society.race.toString());
        this.calcPortrait(station);
    }

    private void calcPortrait(Solar station) {
        this.portraitContainer.removeAll();
        PortraitPanel portrait = new PortraitPanel(station, this.rng, this.imageCache);
        this.portraitContainer.add(portrait);
        this.portraitContainer.validate();
    }
}

