/*
 * Decompiled with CFR 0.152.
 */
package solarex.ui.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import solarex.ship.Cargo;
import solarex.ship.Good;
import solarex.ship.Ship;
import solarex.system.PlanetResources;
import solarex.system.Solar;
import solarex.ui.panels.SpaceStationPanel;
import solarex.util.ClockThread;
import solarex.util.ComponentFactory;
import solarex.util.FontFactory;
import solarex.util.RandomHelper;

public class TradePanel
extends JPanel {
    private Cargo storage;
    private SpaceStationPanel spaceStationPanel;
    private JPanel borderPanel;
    private JLabel cargoSpaceField;
    private JLabel cargoSpaceLabel;
    private JLabel cashField;
    private JLabel cashLabel;
    private JLabel descriptionField;
    private JLabel descriptionLabel;
    private JScrollPane goodsScrollPane;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JButton loungeButton;
    private JLabel titleLabel;
    private JPanel tradePanel;

    public static Cargo createCargo(Solar station) {
        int i;
        Cargo cargo = new Cargo();
        Random grng = RandomHelper.createRNG(station.seed + (long)ClockThread.getDayOfGame());
        Random rng = PlanetResources.getPlanetRng(station.getParent());
        int[] gases = PlanetResources.calculateAtmosphere(station.getParent(), rng);
        int[] fluidDeposits = new int[PlanetResources.Fluids.values().length];
        long[] fluidPositions = new long[PlanetResources.Fluids.values().length];
        PlanetResources.calculateFluids(station.getParent(), gases, rng, fluidDeposits, fluidPositions);
        int[] metalDeposits = new int[PlanetResources.Metals.values().length];
        long[] metalPositions = new long[PlanetResources.Metals.values().length];
        PlanetResources.calculateMetals(station.getParent(), rng, metalDeposits, metalPositions);
        int[] minerals = PlanetResources.calculateMinerals(station.getParent(), rng);
        int[] otherResources = PlanetResources.calculateOtherResources(station.getParent(), rng);
        for (i = 0; i < Good.Type.values().length; ++i) {
            cargo.goods[i].units = (int)(10.0 + grng.nextDouble() * 20.0);
            cargo.goods[i].salesPrice = TradePanel.calculatePrice(station, metalDeposits, minerals, cargo.goods[i]);
        }
        switch (station.society.governmentType) {
            case Communism: {
                cargo.illegalGoods[Good.Type.ArtificialIntelligence.ordinal()] = true;
                cargo.illegalGoods[Good.Type.Robots.ordinal()] = true;
                cargo.illegalGoods[Good.Type.Slaves.ordinal()] = true;
                cargo.illegalGoods[Good.Type.Androids.ordinal()] = true;
                break;
            }
            case Socialism: {
                cargo.illegalGoods[Good.Type.Slaves.ordinal()] = true;
                break;
            }
            case Theocracy: {
                cargo.illegalGoods[Good.Type.ArtificialIntelligence.ordinal()] = true;
                cargo.illegalGoods[Good.Type.Biotech.ordinal()] = true;
                cargo.illegalGoods[Good.Type.Medicine.ordinal()] = true;
                cargo.illegalGoods[Good.Type.Androids.ordinal()] = true;
                break;
            }
            case Utopia: {
                cargo.illegalGoods[Good.Type.Slaves.ordinal()] = true;
                cargo.illegalGoods[Good.Type.ArtificialIntelligence.ordinal()] = true;
            }
        }
        switch (station.society.race) {
            case Clonkniks: {
                cargo.illegalGoods[Good.Type.ArtificialIntelligence.ordinal()] = true;
                cargo.illegalGoods[Good.Type.Androids.ordinal()] = true;
                break;
            }
            case Floatees: {
                cargo.illegalGoods[Good.Type.Biotech.ordinal()] = true;
                cargo.illegalGoods[Good.Type.Slaves.ordinal()] = true;
                break;
            }
            case Poisonbreathers: {
                cargo.illegalGoods[Good.Type.Narcotics.ordinal()] = true;
                break;
            }
            case Rockeaters: {
                cargo.illegalGoods[Good.Type.Nanoparticles.ordinal()] = true;
                cargo.illegalGoods[Good.Type.Androids.ordinal()] = true;
                break;
            }
            case Terraneans: {
                cargo.illegalGoods[Good.Type.Slaves.ordinal()] = true;
                cargo.illegalGoods[Good.Type.Narcotics.ordinal()] = true;
            }
        }
        switch (station.society.governmentType) {
            case Anarchy: {
                for (i = 0; i < cargo.illegalGoods.length; ++i) {
                    cargo.illegalGoods[i] = false;
                }
                break;
            }
        }
        for (i = 0; i < cargo.illegalGoods.length; ++i) {
            if (!cargo.illegalGoods[i]) continue;
            cargo.goods[i].units = 0;
        }
        return cargo;
    }

    private static double calculatePrice(Solar station, int[] metals, int[] minerals, Good good) {
        int i;
        int metalWealth;
        double price = good.type.price;
        switch (station.society.governmentType) {
            case Anarchy: {
                price *= 2.0;
                break;
            }
            case Dictatorship: {
                price *= 1.5;
            }
        }
        if (Good.Type.IronMetals == good.type || Good.Type.LightMetals == good.type || Good.Type.HeavyMetals == good.type || Good.Type.MetalCompounds == good.type || Good.Type.NobleMetals == good.type || Good.Type.NonIronMetals == good.type) {
            metalWealth = 0;
            for (i = 0; i < metals.length; ++i) {
                metalWealth += metals[i];
            }
            price = price * 0.5 + price * 2.0 / (double)(metalWealth + 1);
            good.units = (int)((double)good.units * 0.2 + (double)(good.units * metalWealth));
        }
        if (good.type == Good.Type.NobleMetals) {
            metalWealth = 0;
            for (i = 0; i < metals.length; ++i) {
                if (!PlanetResources.isNobleMetal(i)) continue;
                metalWealth += metals[i];
            }
            price = price * 0.5 + price * 1.0 / (double)(metalWealth + 1);
            good.units = (int)((double)good.units * 0.3 + (double)(good.units * metalWealth));
        }
        if (good.type == Good.Type.NonIronMetals) {
            metalWealth = 0;
            for (i = 0; i < metals.length; ++i) {
                if (!PlanetResources.isNonIronMetal(i)) continue;
                metalWealth += metals[i];
            }
            price = price * 0.5 + price * 1.0 / (double)(metalWealth + 1);
            good.units = (int)((double)good.units * 0.3 + (double)(good.units * metalWealth));
        }
        if (good.type == Good.Type.HeavyMetals) {
            metalWealth = 0;
            for (i = 0; i < metals.length; ++i) {
                if (!PlanetResources.isHeavyMetal(i)) continue;
                metalWealth += metals[i];
            }
            price = price * 0.5 + price * 2.0 / (double)(metalWealth + 1);
            good.units = (int)((double)good.units * 0.2 + (double)(good.units * metalWealth));
        }
        if (good.type == Good.Type.RareEarths || good.type == Good.Type.Crystalics || good.type == Good.Type.Electronics || good.type == Good.Type.CeramicMinerals) {
            int wealth = 0;
            for (i = 0; i < metals.length; ++i) {
                if (!PlanetResources.isRareEarth(i)) continue;
                wealth += minerals[i];
            }
            price = price * 0.5 + price * 1.0 / (double)(wealth + 1);
            good.units = (int)((double)good.units * 0.2 + (double)(good.units * wealth * 2));
        }
        price = 0.5 * price + 0.5 * price * (double)(17 / (12 + station.society.techLevel));
        good.units = (int)(0.5 * (double)good.units + 0.5 * (double)good.units * (double)station.society.techLevel);
        if (good.type == Good.Type.Hypertech && station.society.techLevel < 21) {
            good.units /= 110;
        }
        if (good.type == Good.Type.ArtificialIntelligence && station.society.techLevel < 20) {
            good.units /= 90;
        }
        if (good.type == Good.Type.Transurans) {
            good.units = station.society.techLevel < 16 ? (good.units /= 200) : (good.units /= 100);
        }
        if (good.type == Good.Type.Robots) {
            good.units = station.society.techLevel < 15 ? (good.units /= 15) : (good.units *= 2);
        }
        if (good.type == Good.Type.Biotech && station.society.techLevel < 14) {
            good.units /= 25;
        }
        if (good.type == Good.Type.Crystalics) {
            good.units = station.society.techLevel < 13 ? (good.units /= 15) : (good.units *= 2);
        }
        if (good.type == Good.Type.Nanoparticles) {
            good.units = station.society.techLevel < 12 ? (good.units /= 12) : (good.units *= 2);
        }
        if (good.type == Good.Type.Electronics) {
            good.units = station.society.techLevel < 11 ? (good.units /= 10) : (good.units *= 2);
        }
        if (good.type == Good.Type.MetalCompounds) {
            good.units = station.society.techLevel < 10 ? (good.units /= 8) : (good.units *= 3);
        }
        if (good.type == Good.Type.Medicine) {
            good.units = station.society.techLevel < 9 ? (good.units /= 4) : (good.units *= 2);
        }
        price += price * (10.0 / (double)(10 + good.units));
        int day = ClockThread.getDayOfMonth() + ClockThread.getMonthOfYear() * 30;
        Random arng = RandomHelper.createRNG(station.seed);
        for (int i2 = 0; i2 < day; ++i2) {
            arng.nextDouble();
        }
        double luckyDay = arng.nextDouble();
        price += 0.1 * (price * (luckyDay - 0.5));
        return price;
    }

    public TradePanel(Solar station, Ship ship, SpaceStationPanel spaceStationPanel) {
        this.spaceStationPanel = spaceStationPanel;
        this.initComponents();
        ComponentFactory.customizeScrollpane(this.goodsScrollPane);
        this.storage = TradePanel.createCargo(station);
        this.titleLabel.setFont(FontFactory.getPanelHeading());
        this.titleLabel.setText(station.name + " Commodity Exchange");
        this.cargoSpaceLabel.setFont(FontFactory.getLabelHeading());
        this.cashLabel.setFont(FontFactory.getLabelHeading());
        this.cargoSpaceField.setFont(FontFactory.getLarger());
        this.cashField.setFont(FontFactory.getLarger());
        this.descriptionLabel.setFont(FontFactory.getLabelHeading());
        this.descriptionField.setFont(FontFactory.getNormal());
        for (int i = 0; i < Good.Type.values().length; ++i) {
            GoodLine line = new GoodLine(station, ship, this.storage.goods[i]);
            this.tradePanel.add(line);
        }
        this.updateGoodDesc(0);
        ComponentFactory.customizeButton(this.loungeButton);
    }

    private void initComponents() {
        this.borderPanel = new JPanel();
        this.goodsScrollPane = new JScrollPane();
        this.tradePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.cargoSpaceLabel = new JLabel();
        this.cargoSpaceField = new JLabel();
        this.cashLabel = new JLabel();
        this.cashField = new JLabel();
        this.loungeButton = new JButton();
        this.descriptionLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.descriptionField = new JLabel();
        this.setBackground(Color.black);
        this.setForeground(Color.green);
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.borderPanel.setBackground(new Color(0, 51, 51));
        this.borderPanel.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.borderPanel.setForeground(Color.green);
        this.borderPanel.setMinimumSize(new Dimension(800, 540));
        this.borderPanel.setPreferredSize(new Dimension(800, 540));
        this.borderPanel.setLayout(null);
        this.goodsScrollPane.setBackground(Color.darkGray);
        this.goodsScrollPane.setBorder(BorderFactory.createBevelBorder(1));
        this.tradePanel.setBackground(Color.darkGray);
        this.tradePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TradePanel.this.tradePanelMouseClicked(evt);
            }
        });
        this.tradePanel.setLayout(new BoxLayout(this.tradePanel, 1));
        this.goodsScrollPane.setViewportView(this.tradePanel);
        this.borderPanel.add(this.goodsScrollPane);
        this.goodsScrollPane.setBounds(20, 80, 510, 400);
        this.titleLabel.setFont(new Font("SansSerif", 1, 18));
        this.titleLabel.setForeground(Color.white);
        this.titleLabel.setText("XYZ Commodity Exchange");
        this.borderPanel.add(this.titleLabel);
        this.titleLabel.setBounds(20, 10, 420, 40);
        this.jLabel1.setFont(new Font("SansSerif", 1, 13));
        this.jLabel1.setForeground(Color.green);
        this.jLabel1.setText("Commodity");
        this.borderPanel.add(this.jLabel1);
        this.jLabel1.setBounds(20, 60, 170, 18);
        this.jLabel2.setFont(new Font("SansSerif", 1, 13));
        this.jLabel2.setForeground(Color.green);
        this.jLabel2.setText(" Price");
        this.borderPanel.add(this.jLabel2);
        this.jLabel2.setBounds(220, 60, 50, 18);
        this.jLabel3.setFont(new Font("SansSerif", 1, 13));
        this.jLabel3.setForeground(Color.green);
        this.jLabel3.setText(" Cargo   Avg. Price");
        this.borderPanel.add(this.jLabel3);
        this.jLabel3.setBounds(390, 60, 140, 18);
        this.jLabel4.setFont(new Font("SansSerif", 1, 13));
        this.jLabel4.setForeground(Color.green);
        this.jLabel4.setText(" Stock");
        this.borderPanel.add(this.jLabel4);
        this.jLabel4.setBounds(270, 60, 50, 18);
        this.jLabel5.setFont(new Font("SansSerif", 1, 13));
        this.jLabel5.setForeground(Color.green);
        this.jLabel5.setText("  Sell  Buy");
        this.borderPanel.add(this.jLabel5);
        this.jLabel5.setBounds(320, 60, 70, 18);
        this.cargoSpaceLabel.setForeground(Color.green);
        this.cargoSpaceLabel.setText("Cargo hold left:");
        this.borderPanel.add(this.cargoSpaceLabel);
        this.cargoSpaceLabel.setBounds(190, 500, 130, 30);
        this.cargoSpaceField.setForeground(Color.white);
        this.cargoSpaceField.setHorizontalAlignment(4);
        this.cargoSpaceField.setText("0");
        this.borderPanel.add(this.cargoSpaceField);
        this.cargoSpaceField.setBounds(300, 500, 60, 30);
        this.cashLabel.setForeground(Color.green);
        this.cashLabel.setText("Cash:");
        this.borderPanel.add(this.cashLabel);
        this.cashLabel.setBounds(430, 500, 70, 30);
        this.cashField.setForeground(Color.white);
        this.cashField.setHorizontalAlignment(4);
        this.cashField.setText("0");
        this.borderPanel.add(this.cashField);
        this.cashField.setBounds(470, 500, 100, 30);
        this.loungeButton.setText("Return To Lounge");
        this.loungeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TradePanel.this.loungeButtonActionPerformed(evt);
            }
        });
        this.borderPanel.add(this.loungeButton);
        this.loungeButton.setBounds(20, 500, 140, 25);
        this.descriptionLabel.setForeground(Color.green);
        this.descriptionLabel.setText("Description");
        this.borderPanel.add(this.descriptionLabel);
        this.descriptionLabel.setBounds(550, 60, 130, 20);
        this.jPanel1.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.jPanel1.setLayout(new BorderLayout());
        this.descriptionField.setBackground(Color.darkGray);
        this.descriptionField.setForeground(Color.white);
        this.descriptionField.setText("jLabel6");
        this.descriptionField.setVerticalAlignment(1);
        this.descriptionField.setBorder(BorderFactory.createEmptyBorder(4, 4, 1, 1));
        this.descriptionField.setOpaque(true);
        this.jPanel1.add((Component)this.descriptionField, "Center");
        this.borderPanel.add(this.jPanel1);
        this.jPanel1.setBounds(550, 80, 210, 400);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        this.add((Component)this.borderPanel, gridBagConstraints);
    }

    private void loungeButtonActionPerformed(ActionEvent evt) {
        Container c = this.getParent();
        c.remove(this);
        c.add(this.spaceStationPanel);
        c.validate();
        c.repaint();
    }

    private void tradePanelMouseClicked(MouseEvent evt) {
        int y = evt.getY();
        this.updateGoodDesc(y /= 24);
    }

    private void updateGoodDesc(int goodIndex) {
        Good.Type type = Good.Type.values()[goodIndex];
        String text = "<html><font color=" + type.color + "><b>" + type.toString() + "</b></font>" + "<br><br>Unit mass: " + type.massPerUnit + " kg" + "<br><br>Acceptance: " + (this.storage.illegalGoods[goodIndex] ? "<font color=#FF4411>Prohibited</font>" : "<font color=#33CC00>Good</font>") + "<br><br><p>" + type.description + "</p" + "</html>";
        this.descriptionField.setText(text);
    }

    private class GoodLine
    extends JPanel {
        public JLabel nameLabel;
        public JLabel priceLabel;
        public JLabel cargoLabel;
        public JLabel stockLabel;
        public JLabel buyLabel;
        public final double price;
        public int cargo;
        private final NumberFormat nf = NumberFormat.getInstance();

        public GoodLine(Solar station, final Ship ship, final Good good) {
            this.setLayout(null);
            this.setOpaque(false);
            this.price = good.salesPrice;
            String name = good.type.toString();
            this.nameLabel = new JLabel("<html><font color=" + good.type.color + "><b>" + name + "</b></font></html>");
            this.nameLabel.setSize(180, 24);
            this.nameLabel.setLocation(8, 0);
            this.nameLabel.setFont(FontFactory.getNormal());
            this.add(this.nameLabel);
            this.nf.setMinimumFractionDigits(2);
            this.nf.setMaximumFractionDigits(2);
            this.priceLabel = new JLabel(this.nf.format(this.price));
            this.priceLabel.setSize(48, 24);
            this.priceLabel.setLocation(188, 0);
            this.priceLabel.setForeground(Color.WHITE);
            this.priceLabel.setHorizontalAlignment(4);
            this.priceLabel.setFont(FontFactory.getNormal());
            this.add(this.priceLabel);
            this.stockLabel = new JLabel("" + good.units);
            this.stockLabel.setSize(42, 24);
            this.stockLabel.setLocation(244, 0);
            this.stockLabel.setForeground(Color.WHITE);
            this.stockLabel.setHorizontalAlignment(4);
            this.stockLabel.setFont(FontFactory.getNormal());
            this.add(this.stockLabel);
            JButton minus = new JButton("<");
            minus.setBackground(Color.GRAY);
            minus.setSize(22, 22);
            minus.setLocation(310, 1);
            minus.setMargin(new Insets(0, 0, 0, 0));
            this.add(minus);
            JButton plus = new JButton(">");
            plus.setBackground(Color.GRAY);
            plus.setSize(22, 22);
            plus.setLocation(338, 1);
            plus.setMargin(new Insets(0, 0, 0, 0));
            this.add(plus);
            if (ship.getState() != Ship.State.DOCKED || ship.spaceBodySeed != station.seed) {
                plus.setEnabled(false);
                minus.setEnabled(false);
            }
            this.cargoLabel = new JLabel("" + ship.cargo.goods[good.type.ordinal()].units);
            this.cargoLabel.setSize(42, 24);
            this.cargoLabel.setLocation(366, 0);
            this.cargoLabel.setForeground(Color.WHITE);
            this.cargoLabel.setHorizontalAlignment(4);
            this.cargoLabel.setFont(FontFactory.getNormal());
            this.add(this.cargoLabel);
            this.buyLabel = new JLabel();
            this.buyLabel.setSize(48, 24);
            this.buyLabel.setLocation(420, 0);
            this.buyLabel.setForeground(Color.LIGHT_GRAY);
            this.buyLabel.setHorizontalAlignment(4);
            this.buyLabel.setFont(FontFactory.getNormal());
            this.add(this.buyLabel);
            this.setSize(460, 24);
            this.setPreferredSize(this.getSize());
            this.transfer(ship, good.type.ordinal(), 0);
            plus.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (good.units > 0 && ship.cargo.availableSpace() > 0 && ship.cargo.money >= GoodLine.this.price) {
                        GoodLine.this.transfer(ship, good.type.ordinal(), 1);
                    }
                }
            });
            minus.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ship.cargo.goods[good.type.ordinal()].units > 0) {
                        GoodLine.this.transfer(ship, good.type.ordinal(), -1);
                    }
                }
            });
        }

        private String getUnitColor(int units) {
            String color = "<html><font color=#ffffff>";
            if (units == 0) {
                color = "<html><font color=#ff5555>";
            } else if (units <= 1) {
                color = "<html><font color=#ff9933>";
            } else if (units <= 3) {
                color = "<html><font color=#ffff00>";
            }
            return color;
        }

        private void transfer(Ship ship, int index, int amount) {
            if (amount + ship.cargo.goods[index].units == 0) {
                this.buyLabel.setText("");
            } else if (amount > 0) {
                double avg = ship.cargo.goods[index].averagePrice;
                avg = (avg * (double)ship.cargo.goods[index].units + this.price * (double)amount) / (double)(ship.cargo.goods[index].units + amount);
                this.buyLabel.setText(this.nf.format(avg));
                ship.cargo.goods[index].averagePrice = avg;
            }
            ship.cargo.goods[index].units += amount;
            String color = this.getUnitColor(ship.cargo.goods[index].units);
            this.cargoLabel.setText(color + ship.cargo.goods[index].units + "</font></html>");
            ((TradePanel)TradePanel.this).storage.goods[index].units -= amount;
            color = this.getUnitColor(((TradePanel)TradePanel.this).storage.goods[index].units);
            this.stockLabel.setText(color + ((TradePanel)TradePanel.this).storage.goods[index].units + "</font></html>");
            this.nf.setMinimumFractionDigits(2);
            this.nf.setMaximumFractionDigits(2);
            ship.cargo.money -= this.price * (double)amount;
            TradePanel.this.cashField.setText(this.nf.format(ship.cargo.money) + " Cr");
            int space = ship.cargo.availableSpace();
            TradePanel.this.cargoSpaceField.setText("" + space + " kg");
        }
    }
}

