/*
 * Decompiled with CFR 0.152.
 */
package org.spicetrade;

import java.util.Hashtable;
import java.util.Vector;
import org.spicetrade.Mainframe;
import org.spicetrade.tools.Collection;

public class Journal
extends Collection {
    Hashtable tasksOpen;
    Hashtable tasksClosed;
    Hashtable timestamp;
    Vector tasks = new Vector();
    public static final String xml = "/data/journal.xml";

    public Journal() {
        super(xml);
        this.tasksOpen = new Hashtable();
        this.tasksClosed = new Hashtable();
        this.timestamp = new Hashtable();
    }

    public void refresh() {
        this.refresh(xml);
    }

    public void open(String task) {
        this.open(task, "");
    }

    public void open(String task, String value) {
        Mainframe mf = Mainframe.me;
        if (!this.isDone(task) && !this.has(task)) {
            mf.sounds.playSound("/music/fx_hit.ogg");
            this.tasksOpen.put(task, value);
            this.stamp(task);
        }
    }

    public boolean contains(String task, String value) {
        String compare = this.get(task);
        return compare.indexOf(value) != -1;
    }

    public String get(String task) {
        if (this.tasksOpen.containsKey(task)) {
            return (String)this.tasksOpen.get(task);
        }
        if (this.tasksClosed.containsKey(task)) {
            return (String)this.tasksClosed.get(task);
        }
        return "";
    }

    public boolean has(String task) {
        return this.tasksOpen.containsKey(task);
    }

    public void done(String task) {
        this.done(task, "");
    }

    public void done(String task, String value) {
        this.done(task, value, false);
    }

    public void done(String task, String value, boolean replace) {
        Mainframe mf = Mainframe.me;
        if (!this.isDone(task)) {
            String newValue = value;
            if (!replace) {
                newValue = String.valueOf(this.get(task)) + value;
            }
            mf.sounds.playSound("/music/fx_famous_ending.ogg");
            this.tasks.add(task);
            this.tasksClosed.put(task, newValue);
            this.tasksOpen.remove(task);
            this.stamp(task);
        }
    }

    public boolean isDone(String task) {
        return this.tasksClosed.containsKey(task);
    }

    public void remove(String task) {
        if (this.has(task)) {
            this.tasksOpen.remove(task);
        }
    }

    public void add(String task, String value) {
        this.put(task, String.valueOf(this.get(task)) + value);
    }

    public void put(String task, String value) {
        if (this.tasksOpen.containsKey(task)) {
            this.tasksOpen.put(task, value);
            this.stamp(task);
        } else if (this.tasksClosed.containsKey(task)) {
            this.tasksClosed.put(task, value);
            this.stamp(task);
        }
    }

    public String getPicture(String task) {
        return this.getString(task, "Picture");
    }

    public void stamp(String task) {
        Mainframe mf = Mainframe.me;
        this.timestamp.put(task, String.valueOf(mf.player.day + mf.player.month * 30 + mf.player.year * 360));
    }
}

