/*
 * Decompiled with CFR 0.152.
 */
package org.spicetrade;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import org.spicetrade.Journal;
import org.spicetrade.Mainframe;
import org.spicetrade.tools.Item;
import org.spicetrade.tools.LogItem;

public class Player {
    public Hashtable attr;
    public Vector soldItems;
    public Vector items;
    public Vector log;
    public boolean fullScreen = false;
    public int x;
    public int y;
    public int xHomeCountry;
    public int yHomeCountry;
    public int year;
    public int month;
    public int day;
    public int age;
    public String ageType;
    public double health;
    public int money;
    public int happiness;
    public int moral;
    public int force;
    public int baseForce;
    public int culture;
    public int economy;
    public int wifes;
    public int children;
    public String place;
    public String city;
    public String nicecity;
    public String lastPlace;
    public String logo;
    public String lastWords;
    public boolean inGame;
    public boolean inBattle;
    public boolean inGameOver;
    public int transport;
    public Journal journal;
    public boolean addictedHashish;
    public boolean addictedOpium;
    public boolean sickPlague;
    public boolean sickGeneral;
    public boolean sickPoisoned;
    public int deathType = 0;
    public int difficulty = 1;
    public String statusFace = "/pics/navigation/abus/abu_young01.png";
    public static final String[] cities = new String[]{"baghdad", "anjoudan", "najaf", "latakia", "konya", "baku", "constantinopol", "venice", "madrid", "lisboa", "budapest", "vienna", "moscow", "hamburg", "amsterdam", "london", "paris"};
    public static final String[] niceCities = new String[]{"Baghdad", "Anjoudan", "Najaf", "al-Ladiqiyah", "Konya", "Baku", "Constantinople", "Venice", "Madrid", "Lisbon", "Budapest", "Vienna", "Moscow", "Hamburg", "Amsterdam", "London", "Paris"};

    public Player() {
        this(1);
    }

    public Player(int difficulty) {
        this.difficulty = difficulty;
        this.attr = new Hashtable();
        this.soldItems = new Vector();
        this.items = new Vector();
        this.journal = new Journal();
        this.log = new Vector();
        this.x = 0;
        this.y = 0;
        this.xHomeCountry = 0;
        this.yHomeCountry = 0;
        this.moral = 0;
        this.inGameOver = false;
        this.addictedHashish = false;
        this.addictedOpium = false;
        this.sickPlague = false;
        this.inBattle = false;
        this.lastWords = "";
        this.ageType = "young";
        this.attr.put("Name", "Abu Mansur 'abd ar-Rahman al-Qazzaz");
        this.attr.put("dateAndPlace", "C. 500 AH, Baghdad");
        this.attr.put("wifes", "");
        this.attr.put("children", "");
        Random r = new Random();
        int c = 0;
        c = r.nextInt(100);
        while (c < 60) {
            c = r.nextInt(100);
        }
        this.attr.put("culturebaghdad", String.valueOf(c));
        c = r.nextInt(100);
        while (c < 40) {
            c = r.nextInt(100);
        }
        this.attr.put("cultureanjoudan", String.valueOf(c));
        c = r.nextInt(100);
        while (c < 40) {
            c = r.nextInt(100);
        }
        this.attr.put("culturenajaf", String.valueOf(c));
        c = r.nextInt(100);
        while (c < 40) {
            c = r.nextInt(100);
        }
        this.attr.put("culturelatakia", String.valueOf(c));
        c = r.nextInt(100);
        while (c < 20) {
            c = r.nextInt(100);
        }
        this.attr.put("cultureconstantinopol", String.valueOf(c));
        c = r.nextInt(100);
        while (c < 30) {
            c = r.nextInt(100);
        }
        this.attr.put("culturekonya", String.valueOf(c));
        c = r.nextInt(100);
        while (c < 30) {
            c = r.nextInt(100);
        }
        this.attr.put("culturebaku", String.valueOf(c));
        c = r.nextInt(100);
        while (c < 30) {
            c = r.nextInt(100);
        }
        this.attr.put("culturevienna", String.valueOf(-c));
        c = r.nextInt(100);
        while (c < 30) {
            c = r.nextInt(100);
        }
        this.attr.put("culturebudapest", String.valueOf(-c));
        c = r.nextInt(100);
        while (c < 60) {
            c = r.nextInt(100);
        }
        this.attr.put("culturevenice", String.valueOf(-c));
        c = r.nextInt(100);
        while (c < 50) {
            c = r.nextInt(100);
        }
        this.attr.put("culturemadrid", String.valueOf(-c));
        c = r.nextInt(100);
        while (c < 40) {
            c = r.nextInt(100);
        }
        this.attr.put("culturelisboa", String.valueOf(-c));
        c = r.nextInt(100);
        while (c < 60) {
            c = r.nextInt(100);
        }
        this.attr.put("cultureparis", String.valueOf(-c));
        c = r.nextInt(100);
        while (c < 40) {
            c = r.nextInt(100);
        }
        this.attr.put("cultureamsterdam", String.valueOf(-c));
        c = r.nextInt(100);
        while (c < 50) {
            c = r.nextInt(100);
        }
        this.attr.put("culturehamburg", String.valueOf(-c));
        c = r.nextInt(100);
        while (c < 60) {
            c = r.nextInt(100);
        }
        this.attr.put("culturemoscow", String.valueOf(-c));
        c = r.nextInt(100);
        while (c < 60) {
            c = r.nextInt(100);
        }
        this.attr.put("culturelondon", String.valueOf(-c));
        this.attr.put("Moneyunit", "Dirham");
        this.attr.put("Timeunit", "AH");
        this.attr.put("Special", "Navigation");
        this.year = 500;
        this.month = 4;
        this.day = 7;
        this.age = 17;
        this.health = difficulty == 1 ? 50.0 : 80.0;
        this.happiness = 30;
        this.money = difficulty == 1 ? 25 : 100;
        this.baseForce = difficulty == 1 ? 2 : 5;
        this.force = this.baseForce;
        this.economy = 0;
        this.culture = 0;
        this.wifes = 0;
        this.children = 0;
        this.place = "";
        this.lastPlace = "";
        this.logo = "logoIntro";
        this.to(141, 421);
        this.toHomeCountry(249, 135, "baghdad", "Baghdad");
        this.buyItem("12050", 0);
        this.buyItem("14000", 0);
        this.buyItem("10000", 0);
        this.buyItem("10300", 0);
        Mainframe.me.showMapGlobe = false;
        this.inGame = false;
        this.transport = 0;
    }

    public String get(String s) {
        try {
            return (String)this.attr.get(s);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean has(String n) {
        return this.attr.containsKey(n);
    }

    public void add(String n) {
        this.attr.put(n, "");
    }

    public void add(String n, String v) {
        this.attr.put(n, v);
    }

    public void remove(String n) {
        this.attr.remove(n);
    }

    public boolean contains(String n, String v) {
        String c = "";
        if (this.has(n)) {
            c = this.get(n);
        }
        return c.indexOf(v) != -1;
    }

    public void addWife(String name) {
        if (this.contains("wifes", name)) {
            return;
        }
        String all = (String)this.attr.get("wifes");
        all = all == null || all.equals("") ? name : String.valueOf(all) + ", " + name;
        this.attr.put("wifes", all);
        ++this.wifes;
    }

    public boolean hasWife(String name) {
        return this.contains("wifes", name);
    }

    public void removeWife(String name) {
        if (!this.contains("wifes", name)) {
            return;
        }
        String all = (String)this.attr.get("wifes");
        all = all.indexOf(name) == 0 ? (all.indexOf(",") == -1 ? "" : all.substring(all.indexOf(","), all.length())) : all.substring(all.indexOf(", " + name) + name.length() + 2, all.length());
        this.attr.put("wifes", all);
        --this.wifes;
    }

    public void addChild(String name) {
        if (this.contains("children", name)) {
            return;
        }
        String all = (String)this.attr.get("children");
        all = all == null || all.equals("") ? name : String.valueOf(all) + ", " + name;
        this.attr.put("children", all);
        ++this.children;
    }

    public boolean hasChild(String name) {
        return this.contains("children", name);
    }

    public void removeChild(String name) {
        if (!this.contains("children", name)) {
            return;
        }
        String all = (String)this.attr.get("children");
        all = all.indexOf(name) == 0 ? (all.indexOf(",") == -1 ? "" : all.substring(all.indexOf(","), all.length())) : all.substring(all.indexOf(", " + name) + name.length() + 2, all.length());
        this.attr.put("children", all);
        --this.children;
    }

    public void addLog(String id, String action, int when) {
        if (this.inGame) {
            this.log.add(new LogItem(id, action, when));
        }
        if (this.log.size() > 100) {
            this.log.remove(0);
        }
    }

    public void addMoney(int amount) {
        this.money += amount;
    }

    public void removeMoney(int amount) {
        this.money -= amount;
    }

    public Vector getInventory() {
        Vector<Item> inventory = new Vector<Item>();
        Item item = null;
        int i = 0;
        int j = this.items.size();
        while (i < j) {
            item = (Item)this.items.elementAt(i);
            if (item.inventory) {
                inventory.add(item);
            }
            ++i;
        }
        return inventory;
    }

    public void buyItem(String id) {
        try {
            Item item = Mainframe.me.market.getItem(id);
            this.buyItem(id, item.price);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void buyItem(String id, int price, boolean only) {
        try {
            if (only && !this.hasItem(id)) {
                this.buyItem(id, price);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void buyItem(String id, int price, String who) {
        try {
            int i = 0;
            int j = this.soldItems.size();
            while (i < j) {
                Item item = (Item)this.soldItems.elementAt(i);
                if (item.who.equals(who) && item.id.equals(id)) {
                    this.buyItem(id, price);
                    this.soldItems.remove(i);
                    break;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void buyItem(String id, int price) {
        try {
            Mainframe mf = Mainframe.me;
            Item item = mf.market.getItem(id);
            this.money -= price;
            if (id.equals("16000") || id.equals("16010") || id.equals("16020") || id.equals("16030")) {
                item.name = String.valueOf(item.name) + ", " + this.get("worker");
            }
            mf.sounds.playSound("/music/fx_hit.ogg");
            this.items.add(item);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean hasSold(String id) {
        return this.hasSold(id, null);
    }

    public boolean hasSold(String id, String who) {
        boolean ret = false;
        Iterator iter = this.soldItems.iterator();
        while (iter.hasNext()) {
            Item item = (Item)iter.next();
            if (!item.id.equals(id) || who != null && !who.equals(item.who)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public void sellItem(String id) {
        try {
            Item item = Mainframe.me.market.getItem(id);
            this.sellItem(id, item.price);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void sellItem(String id, int price) {
        try {
            Mainframe mf = Mainframe.me;
            if (this.journal.has("field2")) {
                this.journal.done("field2", "\u00a7- I sold some spices in " + this.nicecity);
            }
            this.money += price;
            mf.sounds.playSound("/music/fx_hit.ogg");
            this.removeItem(id);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Vector getSoldItems(String who) {
        Vector<Item> res = new Vector<Item>();
        try {
            Iterator iter = this.soldItems.iterator();
            while (iter.hasNext()) {
                Item item = (Item)iter.next();
                if (item.who == null || !who.equals(item.who)) continue;
                res.add(item);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return res;
    }

    public void sellItem(String id, int price, String who) {
        Mainframe mf = Mainframe.me;
        if (this.hasItem(id)) {
            Item item = mf.market.getItem(id);
            this.removeItem(id);
            item.who = who;
            this.money += (int)(mf.traders.getSellFactor(who) * (double)price);
            this.soldItems.add(item);
        }
    }

    public boolean hasItem(String id) {
        return this.hasItem(id, 1);
    }

    public boolean hasItem(String id, int amount) {
        return this.hasItem(id, amount, true);
    }

    public boolean hasItem(String id, int amount, boolean givenItems) {
        Item item = null;
        int count = 0;
        boolean res = false;
        int i = 0;
        int j = this.items.size();
        while (i < j) {
            item = (Item)this.items.get(i);
            if (item.id.equals(id)) {
                ++count;
            }
            ++i;
        }
        i = 0;
        j = this.soldItems.size();
        while (i < j) {
            item = (Item)this.soldItems.get(i);
            if (item.id.equals(id)) {
                ++count;
            }
            ++i;
        }
        if (this.attr.containsKey(id) && givenItems) {
            ++count;
        }
        if (count >= amount) {
            res = true;
        }
        return res;
    }

    public boolean hasAnyItems(String[] ids) {
        Item item = null;
        boolean res = false;
        int i = 0;
        int j = this.items.size();
        while (i < j) {
            item = (Item)this.items.get(i);
            int k = 0;
            int l = ids.length;
            while (k < l) {
                if (item.id.equals(ids[k])) {
                    res = true;
                }
                ++k;
            }
            ++i;
        }
        return res;
    }

    public boolean hasAllItems(String[] ids) {
        Item item = null;
        boolean res = false;
        int i = 0;
        int j = this.items.size();
        while (i < j) {
            item = (Item)this.items.get(i);
            int k = 0;
            int l = ids.length;
            while (k < l) {
                res = item.id.equals(ids[k]);
                ++k;
            }
            ++i;
        }
        return res;
    }

    public boolean canBuy(String id) {
        try {
            return this.money >= Mainframe.me.market.getPrice(id);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean hasMoney(int compare) {
        return this.money >= compare;
    }

    public boolean hasMoreMoney(int compare) {
        return this.money > compare;
    }

    public void removeItem(String id) {
        Item item = null;
        int i = 0;
        int j = this.items.size();
        while (i < j) {
            item = (Item)this.items.get(i);
            if (item.id.equals(id)) {
                this.items.remove(i);
                break;
            }
            ++i;
        }
    }

    public void giveItem(String id) {
        this.removeItem(id);
        this.attr.put(id, "");
    }

    public boolean inPlace(String where) {
        return this.inPlace(where, false);
    }

    public boolean inPlace(String where, boolean exact) {
        boolean ret = false;
        ret = exact ? where.equals(this.place) : this.place.indexOf(where) != -1;
        return ret;
    }

    public void to(int _x, int _y) {
        this.x = _x;
        this.y = _y;
    }

    public void toHomeCountry(int _x, int _y, String _city, String _nicecity) {
        this.xHomeCountry = _x;
        this.yHomeCountry = _y;
        this.city = _city;
        this.nicecity = _nicecity;
    }

    public void nextDay() {
        this.nextDay(false);
    }

    public void nextDay(int amount) {
        this.nextDay(amount, false);
    }

    public void nextDay(int amount, boolean travelling) {
        int i = 0;
        while (i < amount) {
            this.nextDay(travelling);
            ++i;
        }
    }

    public void nextDay(boolean travelling) {
        Mainframe mf = Mainframe.me;
        if (this.day++ == 30) {
            this.nextMonth(travelling);
        }
        if (this.health > 300.0) {
            this.health = 300.0;
        }
        if (travelling) {
            switch (this.transport) {
                case 0: {
                    if (this.difficulty == 1) {
                        this.health -= 0.5;
                        break;
                    }
                    this.health -= 0.3;
                    break;
                }
                case 1: {
                    if (this.difficulty == 1) {
                        this.health -= 0.4;
                        break;
                    }
                    this.health -= 0.2;
                    break;
                }
                case 2: {
                    if (this.difficulty == 1) {
                        this.health -= 0.4;
                        break;
                    }
                    this.health -= 0.2;
                    break;
                }
                case 3: {
                    if (this.difficulty == 1) {
                        this.health -= 0.2;
                        break;
                    }
                    this.health -= 0.1;
                    break;
                }
                case 4: {
                    if (this.difficulty == 1) {
                        this.health -= 0.4;
                        break;
                    }
                    this.health -= 0.2;
                    break;
                }
                case 5: {
                    if (this.difficulty == 1) {
                        this.health -= 0.2;
                        break;
                    }
                    this.health -= 0.1;
                    break;
                }
                case 6: {
                    if (this.difficulty == 1) {
                        this.health -= 0.2;
                        break;
                    }
                    this.health -= 0.1;
                }
            }
        }
        if (this.sickGeneral) {
            this.health -= 0.01;
        } else if (this.sickPlague) {
            this.health -= 0.1;
        } else if (this.sickPoisoned) {
            this.health -= 1.0;
        }
        if (this.sickPoisoned) {
            int value = Integer.parseInt((String)this.attr.get("poisoned"));
            this.attr.put("poisoned", String.valueOf(++value));
            if (value >= 100) {
                mf.doActionOnEntering = "mf.gotoDeath(\"Abu died of poisoning.\", 3);";
            }
        }
        if (this.health < 1.0) {
            mf.doActionOnEntering = "mf.gotoDialog(\"9110\");";
        }
    }

    public void nextMonth() {
        this.nextMonth(false);
    }

    public void nextMonth(boolean travelling) {
        String permit;
        this.day = 1;
        ++this.month;
        if (this.month > 12) {
            this.month = 1;
            this.nextYear();
        }
        int months = this.age * 12 + this.month;
        Mainframe mf = Mainframe.me;
        mf.nextInt = mf.random.nextInt(100);
        this.ageType = "young";
        int randomEffect = 0;
        this.force = this.baseForce;
        Iterator iter = this.items.iterator();
        while (iter.hasNext()) {
            Item item = (Item)iter.next();
            if (item.id.length() != 5) continue;
            this.health += (double)item.health;
            this.money += item.monthlyCost;
            this.culture += item.culture;
            this.economy += item.economy;
            this.force += item.force;
            this.happiness += item.happiness;
            randomEffect += item.random;
        }
        if (this.hasItem("11000") && this.hasItem("11001") && this.hasItem("11002") && this.hasItem("11003") && this.hasItem("11004") && this.hasItem("11005") || this.hasItem("11010") && this.hasItem("11011") && this.hasItem("11012") && this.hasItem("11013") && this.hasItem("11014") && this.hasItem("11015")) {
            this.logo = "logoAmulet";
            ++this.happiness;
            this.health += 5.0;
            ++this.baseForce;
            randomEffect += 5;
        } else if (this.journal.has("yima1") && !this.journal.contains("yima1", "cursed by Yima")) {
            int value = Integer.parseInt(this.journal.get("yima1").substring(1, this.journal.get("yima1").length()));
            this.journal.put("yima1", "!" + --value);
            if (value < 1) {
                if (mf.rB(0, 25 - randomEffect)) {
                    this.journal.put("yima1", "\u00a7- I was cursed by Yima");
                    this.journal.open("random2");
                    this.logo = "logoEvil";
                } else if (mf.rB(25, 50 - randomEffect)) {
                    this.journal.put("yima1", "\u00a7- I was cursed by Yima");
                    this.journal.open("random3");
                    this.logo = "logoEvil";
                } else if (mf.rB(50, 65 - randomEffect)) {
                    this.journal.put("yima1", "\u00a7- I was cursed by Yima");
                    this.journal.open("random1");
                    this.logo = "logoEvil";
                } else if (mf.rB(65, 70 - randomEffect)) {
                    this.journal.put("yima1", "\u00a7- I was cursed by Yima");
                    this.addAddiction("plague", 10);
                    this.logo = "logoEvil";
                }
            }
        }
        if (this.journal.has("iblis1") && this.journal.get("iblis1").charAt(0) == '!') {
            int value = Integer.parseInt(this.journal.get("iblis1").substring(1, this.journal.get("iblis1").length()));
            this.journal.put("iblis1", "!" + --value);
            if (value <= 0 && mf.rB(0, 75 - randomEffect)) {
                mf.doActionOnEntering = "mf.gotoPlace(\"supernaturalbad2\");mf.gotoDialog(\"1571\");";
                this.logo = "logoEvil";
            }
        }
        if (this.journal.has(permit = "permit1") && !this.journal.get(permit).equals("") && this.journal.get(permit).charAt(0) == '!') {
            int value = Integer.parseInt(this.journal.get(permit).substring(1, this.journal.get(permit).length()));
            this.journal.put(permit, "!" + --value);
            if (value <= 0) {
                this.journal.put(permit, "\u00a7- The permit can be retrieved from the sultan's official");
            }
        }
        if (this.journal.has(permit = "permit2") && !this.journal.get(permit).equals("") && this.journal.get(permit).charAt(0) == '!') {
            int value = Integer.parseInt(this.journal.get(permit).substring(1, this.journal.get(permit).length()));
            this.journal.put(permit, "!" + --value);
            if (value <= 0) {
                this.journal.put(permit, "\u00a7- The permit can be retrieved from the sultan's official");
            }
        }
        if (this.journal.has(permit = "permit3") && !this.journal.get(permit).equals("") && this.journal.get(permit).charAt(0) == '!') {
            int value = Integer.parseInt(this.journal.get(permit).substring(1, this.journal.get(permit).length()));
            this.journal.put(permit, "!" + --value);
            if (value <= 0) {
                this.journal.put(permit, "\u00a7- The permit can be retrieved from the sultan's official");
            }
        }
        if (this.journal.has(permit = "permit4") && !this.journal.get(permit).equals("") && this.journal.get(permit).charAt(0) == '!') {
            int value = Integer.parseInt(this.journal.get(permit).substring(1, this.journal.get(permit).length()));
            this.journal.put(permit, "!" + --value);
            if (value <= 0) {
                this.journal.put(permit, "\u00a7- The permit can be retrieved from the sultan's official");
            }
        }
        if (this.journal.has(permit = "permit10") && !this.journal.get(permit).equals("") && this.journal.get(permit).charAt(0) == '!') {
            int value = Integer.parseInt(this.journal.get(permit).substring(1, this.journal.get(permit).length()));
            this.journal.put(permit, "!" + --value);
            if (value <= 0) {
                this.journal.put(permit, "\u00a7- The permit can be retrieved from the sultan's official");
            }
        }
        if (this.journal.has(permit = "permit11") && !this.journal.get(permit).equals("") && this.journal.get(permit).charAt(0) == '!') {
            int value = Integer.parseInt(this.journal.get(permit).substring(1, this.journal.get(permit).length()));
            this.journal.put(permit, "!" + --value);
            if (value <= 0) {
                this.journal.put(permit, "\u00a7- The permit can be retrieved from the sultan's official");
            }
        }
        if (this.journal.has(permit = "permit12") && !this.journal.get(permit).equals("") && this.journal.get(permit).charAt(0) == '!') {
            int value = Integer.parseInt(this.journal.get(permit).substring(1, this.journal.get(permit).length()));
            this.journal.put(permit, "!" + --value);
            if (value <= 0) {
                this.journal.put(permit, "\u00a7- The permit can be retrieved from the king's official");
            }
        }
        if (this.journal.has("abdullah2") && this.journal.get("abdullah2").charAt(0) == '!') {
            String parse = this.journal.get("abdullah2").substring(1, 2);
            String other = this.journal.get("abdullah2").substring(2, this.journal.get("abdullah2").length());
            this.journal.put("abdullah2", String.valueOf(other) + "\u00a7- I waited one month to see Umm again");
        }
        int i = 0;
        int j = cities.length;
        while (i < j) {
            Vector museumItems = null;
            if (this.has("museum" + cities[i])) {
                int l;
                Item item;
                if (cities[i].equals("baghdad")) {
                    museumItems = this.itemsVector("museum");
                    Iterator iter2 = museumItems.iterator();
                    while (iter2.hasNext()) {
                        item = (Item)iter2.next();
                        int k = 0;
                        l = cities.length;
                        while (k < l) {
                            this.addCulture(cities[l], item.culture / 2);
                            ++k;
                        }
                    }
                } else {
                    museumItems = this.itemsVector(String.valueOf(cities[i]) + "museum");
                    Iterator iter3 = museumItems.iterator();
                    while (iter3.hasNext()) {
                        item = (Item)iter3.next();
                        int k = 0;
                        l = cities.length;
                        while (k < l) {
                            this.addCulture(cities[l], item.culture / 4);
                            ++k;
                        }
                        this.addCulture(cities[i], item.culture);
                    }
                }
            }
            if (this.getCulture(cities[i]) < 0) {
                boolean destroy = false;
                if (this.has("museum" + cities[i]) && !this.journal.contains("permit" + cities[i], "destroyed") && mf.doActionOnEntering.equals("")) {
                    Iterator iter4;
                    if (cities[i].equals("amsterdam")) {
                        mf.doActionOnEntering = "mf.gotoDialog(\"3340\");";
                    } else if (cities[i].equals("venice")) {
                        mf.doActionOnEntering = "mf.gotoDialog(\"3341\");";
                    } else if (cities[i].equals("budapest")) {
                        mf.doActionOnEntering = "mf.gotoDialog(\"3342\");";
                    } else if (cities[i].equals("vienna")) {
                        mf.doActionOnEntering = "mf.gotoDialog(\"3343\");";
                    } else if (cities[i].equals("moscow")) {
                        mf.doActionOnEntering = "mf.gotoDialog(\"3344\");";
                    } else if (cities[i].equals("madrid")) {
                        mf.doActionOnEntering = "mf.gotoDialog(\"3345\");";
                    } else if (cities[i].equals("lisboa")) {
                        mf.doActionOnEntering = "mf.gotoDialog(\"3346\");";
                    } else if (cities[i].equals("paris")) {
                        mf.doActionOnEntering = "mf.gotoDialog(\"3347\");";
                    } else if (cities[i].equals("london")) {
                        mf.doActionOnEntering = "mf.gotoDialog(\"3348\");";
                    } else if (cities[i].equals("hamburg")) {
                        mf.doActionOnEntering = "mf.gotoDialog(\"3349\");";
                    }
                    destroy = true;
                    if (cities[i].equals("baghdad")) {
                        museumItems = this.itemsVector("museum");
                        iter4 = museumItems.iterator();
                        while (iter4.hasNext()) {
                            Item item = (Item)iter4.next();
                            this.giveItem(item.id);
                        }
                    } else {
                        museumItems = this.itemsVector(String.valueOf(cities[i]) + "museum");
                        iter4 = museumItems.iterator();
                        while (iter4.hasNext()) {
                            Item item = (Item)iter4.next();
                            this.giveItem(item.id);
                        }
                    }
                    this.journal.add("permit" + cities[i], "\u00a7- They destroyed my museum and my collections");
                    this.add("removemuseum" + cities[i]);
                }
                if (this.has("mosque" + cities[i]) && (destroy || mf.doActionOnEntering.equals("")) && !this.journal.contains("church" + cities[i], "mosque is gone")) {
                    if (cities[i].equals("amsterdam")) {
                        mf.doActionOnEntering = destroy ? "mf.gotoDialog(\"3330\");" : "mf.gotoDialog(\"3320\");";
                    } else if (cities[i].equals("venice")) {
                        mf.doActionOnEntering = destroy ? "mf.gotoDialog(\"3331\");" : "mf.gotoDialog(\"3321\");";
                    } else if (cities[i].equals("budapest")) {
                        mf.doActionOnEntering = destroy ? "mf.gotoDialog(\"3332\");" : "mf.gotoDialog(\"3322\");";
                    } else if (cities[i].equals("vienna")) {
                        mf.doActionOnEntering = destroy ? "mf.gotoDialog(\"3333\");" : "mf.gotoDialog(\"3323\");";
                    } else if (cities[i].equals("moscow")) {
                        mf.doActionOnEntering = destroy ? "mf.gotoDialog(\"3334\");" : "mf.gotoDialog(\"3324\");";
                    } else if (cities[i].equals("madrid")) {
                        mf.doActionOnEntering = destroy ? "mf.gotoDialog(\"3335\");" : "mf.gotoDialog(\"3325\");";
                    } else if (cities[i].equals("lisboa")) {
                        mf.doActionOnEntering = destroy ? "mf.gotoDialog(\"3336\");" : "mf.gotoDialog(\"3326\");";
                    } else if (cities[i].equals("paris")) {
                        mf.doActionOnEntering = destroy ? "mf.gotoDialog(\"3337\");" : "mf.gotoDialog(\"3327\");";
                    } else if (cities[i].equals("london")) {
                        mf.doActionOnEntering = destroy ? "mf.gotoDialog(\"3338\");" : "mf.gotoDialog(\"3328\");";
                    } else if (cities[i].equals("hamburg")) {
                        mf.doActionOnEntering = destroy ? "mf.gotoDialog(\"3339\");" : "mf.gotoDialog(\"3329\");";
                    }
                    this.journal.add("church" + cities[i], "\u00a7- The mosque is gone and a church stands in it's place");
                    this.add("removemosque" + cities[i]);
                }
            } else if (this.getCulture(cities[i]) > 49 && !this.has("museum" + cities[i])) {
                if (!this.has("museum" + cities[i]) && !this.journal.has("permit" + cities[i]) && !this.journal.isDone("permit" + cities[i]) && mf.doActionOnEntering.equals("")) {
                    if (cities[i].equals("amsterdam")) {
                        mf.doActionOnEntering = "mf.gotoDialog(\"3300\");";
                    } else if (cities[i].equals("venice")) {
                        mf.doActionOnEntering = "mf.gotoDialog(\"3301\");";
                    } else if (cities[i].equals("budapest")) {
                        mf.doActionOnEntering = "mf.gotoDialog(\"3302\");";
                    } else if (cities[i].equals("vienna")) {
                        mf.doActionOnEntering = "mf.gotoDialog(\"3303\");";
                    } else if (cities[i].equals("moscow")) {
                        mf.doActionOnEntering = "mf.gotoDialog(\"3304\");";
                    } else if (cities[i].equals("madrid")) {
                        mf.doActionOnEntering = "mf.gotoDialog(\"3305\");";
                    } else if (cities[i].equals("lisboa")) {
                        mf.doActionOnEntering = "mf.gotoDialog(\"3306\");";
                    } else if (cities[i].equals("paris")) {
                        mf.doActionOnEntering = "mf.gotoDialog(\"3307\");";
                    } else if (cities[i].equals("london")) {
                        mf.doActionOnEntering = "mf.gotoDialog(\"3308\");";
                    } else if (cities[i].equals("hamburg")) {
                        mf.doActionOnEntering = "mf.gotoDialog(\"3309\");";
                    }
                }
            } else if (this.getCulture(cities[i]) > 79 && !this.has("mosque" + cities[i]) && !this.journal.has("church" + cities[i]) && !this.journal.isDone("church" + cities[i]) && mf.doActionOnEntering.equals("")) {
                if (cities[i].equals("amsterdam")) {
                    mf.doActionOnEntering = "mf.gotoDialog(\"3310\");";
                } else if (cities[i].equals("venice")) {
                    mf.doActionOnEntering = "mf.gotoDialog(\"3311\");";
                } else if (cities[i].equals("budapest")) {
                    mf.doActionOnEntering = "mf.gotoDialog(\"3312\");";
                } else if (cities[i].equals("vienna")) {
                    mf.doActionOnEntering = "mf.gotoDialog(\"3313\");";
                } else if (cities[i].equals("moscow")) {
                    mf.doActionOnEntering = "mf.gotoDialog(\"3314\");";
                } else if (cities[i].equals("madrid")) {
                    mf.doActionOnEntering = "mf.gotoDialog(\"3315\");";
                } else if (cities[i].equals("lisboa")) {
                    mf.doActionOnEntering = "mf.gotoDialog(\"3316\");";
                } else if (cities[i].equals("paris")) {
                    mf.doActionOnEntering = "mf.gotoDialog(\"3317\");";
                } else if (cities[i].equals("london")) {
                    mf.doActionOnEntering = "mf.gotoDialog(\"3318\");";
                } else if (cities[i].equals("hamburg")) {
                    mf.doActionOnEntering = "mf.gotoDialog(\"3319\");";
                }
            }
            ++i;
        }
        if (this.getCulture("baghdad") < 0 && !this.has("churchbaghdad")) {
            if (mf.doActionOnEntering.equals("")) {
                this.add("churchbaghdad");
                mf.doActionOnEntering = "mf.gotoDialog(\"5100\");";
            }
        } else if (this.getCulture("najaf") < 0 && !this.has("churchnajaf")) {
            if (mf.doActionOnEntering.equals("")) {
                this.add("churchnajaf");
                mf.doActionOnEntering = "mf.gotoDialog(\"5101\");";
            }
        } else if (this.getCulture("anjoudan") < 0 && !this.has("churchanjoudan")) {
            if (mf.doActionOnEntering.equals("")) {
                this.add("churchanjoudan");
                mf.doActionOnEntering = "mf.gotoDialog(\"5102\");";
            }
        } else if (this.getCulture("latakia") < 0 && !this.has("churchlatakia")) {
            if (mf.doActionOnEntering.equals("")) {
                this.add("churchlatakia");
                mf.doActionOnEntering = "mf.gotoDialog(\"5103\");";
            }
        } else if (this.getCulture("konya") < 0 && !this.has("churchkonya")) {
            if (mf.doActionOnEntering.equals("")) {
                this.add("churchkonya");
                mf.doActionOnEntering = "mf.gotoDialog(\"5104\");";
            }
        } else if (this.getCulture("baku") < 0 && !this.has("churchbaku")) {
            if (mf.doActionOnEntering.equals("")) {
                this.add("churchbaku");
                mf.doActionOnEntering = "mf.gotoDialog(\"5105\");";
            }
        } else if (this.getCulture("constantinopol") < 0 && !this.has("churchconstantinopol") && mf.doActionOnEntering.equals("")) {
            this.add("churchconstantinopol");
            mf.doActionOnEntering = "mf.gotoDialog(\"5106\");";
        }
        if (this.getCulture("baghdad") > 9 && this.has("churchbaghdad")) {
            if (mf.doActionOnEntering.equals("")) {
                this.add("mosquebaghdad");
                this.remove("churchbaghdad");
                mf.doActionOnEntering = "mf.gotoDialog(\"5110\");";
            }
        } else if (this.getCulture("najaf") > 9 && this.has("churchnajaf")) {
            if (mf.doActionOnEntering.equals("")) {
                this.add("mosquenajaf");
                this.remove("churchnajaf");
                mf.doActionOnEntering = "mf.gotoDialog(\"5111\");";
            }
        } else if (this.getCulture("anjoudan") > 9 && this.has("churchanjoudan")) {
            if (mf.doActionOnEntering.equals("")) {
                this.add("mosqueanjoudan");
                this.remove("churchanjoudan");
                mf.doActionOnEntering = "mf.gotoDialog(\"5112\");";
            }
        } else if (this.getCulture("latakia") > 9 && this.has("churchlatakia")) {
            if (mf.doActionOnEntering.equals("")) {
                this.add("mosquelatakia");
                this.remove("churchlatakia");
                mf.doActionOnEntering = "mf.gotoDialog(\"5113\");";
            }
        } else if (this.getCulture("konya") > 9 && this.has("churchkonya")) {
            if (mf.doActionOnEntering.equals("")) {
                this.add("mosquekonya");
                this.remove("churchkonya");
                mf.doActionOnEntering = "mf.gotoDialog(\"5114\");";
            }
        } else if (this.getCulture("baku") > 9 && this.has("churchbaku")) {
            if (mf.doActionOnEntering.equals("")) {
                this.add("mosquebaku");
                this.remove("churchbaku");
                mf.doActionOnEntering = "mf.gotoDialog(\"5115\");";
            }
        } else if (this.getCulture("constantinopol") > 9 && this.has("churchconstantinopol") && mf.doActionOnEntering.equals("")) {
            this.add("mosqueconstantinopol");
            this.remove("churchconstantinopol");
            mf.doActionOnEntering = "mf.gotoDialog(\"5116\");";
        }
        if (this.difficulty == 0) {
            if (this.age > 19 && (this.money > 10000 || this.journal.isDone("mahdi1") || this.journal.isDone("yima1") || this.journal.isDone("grave3")) && !this.journal.has("permit2") && !this.journal.isDone("permit2") && mf.doActionOnEntering.equals("")) {
                this.journal.open("permit2");
                this.journal.open("");
                this.add("buildingpermit");
                mf.doActionOnEntering = "mf.gotoDialog(\"3110\");";
            } else if (this.age > 24 && (this.money > 10000 || this.journal.isDone("mahdi1") || this.journal.isDone("yima1") || this.journal.isDone("grave3")) && !this.journal.has("permit10") && !this.journal.isDone("permit10") && mf.doActionOnEntering.equals("") && this.journal.isDone("permit2")) {
                this.journal.open("permit10");
                this.add("buildingpermit");
                mf.doActionOnEntering = "mf.gotoDialog(\"3080\");";
            }
        } else if (this.difficulty == 1) {
            if (this.age > 25 && (this.money > 20000 || this.journal.isDone("mahdi1") || this.journal.isDone("yima1") || this.journal.isDone("grave5")) && !this.journal.has("permit2") && !this.journal.isDone("permit2") && mf.doActionOnEntering.equals("")) {
                this.journal.open("permit2");
                this.add("buildingpermit");
                mf.doActionOnEntering = "mf.gotoDialog(\"3110\");";
            } else if (this.age > 29 && (this.money > 20000 || this.journal.isDone("mahdi1") || this.journal.isDone("yima1") || this.journal.isDone("grave5")) && !this.journal.has("permit10") && !this.journal.isDone("permit10") && mf.doActionOnEntering.equals("") && this.journal.isDone("permit2")) {
                this.journal.open("permit10");
                this.add("buildingpermit");
                mf.doActionOnEntering = "mf.gotoDialog(\"3080\");";
            }
        }
        if (this.addictedHashish) {
            if (this.hasItem("10220")) {
                this.removeItem("10220");
                this.addLog("You smoked hashish", "res=false;", this.day + this.month * 30 + this.year * 360);
            } else {
                this.health -= 5.0;
                this.addLog("You had no hashish, even though you are addicted to it. You feel weaker.", "res=false;", this.day + this.month * 30 + this.year * 360);
            }
        } else if (this.addictedOpium) {
            if (this.hasItem("10230")) {
                this.removeItem("10230");
                this.addLog("You smoked opium", "res=false;", this.day + this.month * 30 + this.year * 360);
            } else {
                this.health -= 20.0;
                this.addLog("You had no opium, even though you are addicted to it. You feel weaker.", "res=false;", this.day + this.month * 30 + this.year * 360);
            }
        }
        String[] armies = new String[]{"venice", "lisboa", "paris", "hamburg", "moscow", "budapest", "vienna", "madrid", "london", "amsterdam"};
        Random r = new Random();
        int army = r.nextInt(9);
        if (!this.journal.isDone("random1") && this.hasItem("16020") && this.age > 18) {
            this.add("foreignarmy", armies[0]);
            this.journal.open("random1", "\u00a7- The army of " + mf.armies.getName(armies[0]) + " is attacking your country!");
        } else if (!this.journal.isDone("random4") && this.journal.isDone("random1") && this.hasItem("16020") && this.age > 20) {
            this.add("foreignarmy", armies[1]);
            this.journal.open("random4", "\u00a7- The army of " + mf.armies.getName(armies[1]) + " is attacking your country!");
        } else if (!this.journal.isDone("random5") && this.journal.isDone("random4") && this.hasItem("16020") && this.age > 23) {
            this.add("foreignarmy", armies[2]);
            this.journal.open("random5", "\u00a7- The army of " + mf.armies.getName(armies[1]) + " is attacking your country!");
        } else if (!this.journal.isDone("random6") && this.journal.isDone("random5") && this.hasItem("16020") && this.age > 24) {
            this.add("foreignarmy", armies[3]);
            this.journal.open("random6", "\u00a7- The army of " + mf.armies.getName(armies[1]) + " is attacking your country!");
        } else if (!this.journal.isDone("random7") && this.journal.isDone("random6") && this.hasItem("16020") && this.age > 27) {
            this.add("foreignarmy", armies[4]);
            this.journal.open("random7", "\u00a7- The army of " + mf.armies.getName(armies[1]) + " is attacking your country!");
        } else if (!this.journal.isDone("random8") && this.journal.isDone("random7") && this.hasItem("16020") && this.age > 29) {
            this.add("foreignarmy", armies[5]);
            this.journal.open("random8", "\u00a7- The army of " + mf.armies.getName(armies[1]) + " is attacking your country!");
        } else if (!this.journal.isDone("random9") && this.journal.isDone("random8") && this.hasItem("16020") && this.age > 34) {
            this.add("foreignarmy", armies[6]);
            this.journal.open("random9", "\u00a7- The army of " + mf.armies.getName(armies[1]) + " is attacking your country!");
        } else if (!this.journal.isDone("random10") && this.journal.isDone("random9") && this.hasItem("16020") && this.age > 35) {
            this.add("foreignarmy", armies[7]);
            this.journal.open("random10", "\u00a7- The army of " + mf.armies.getName(armies[1]) + " is attacking your country!");
        } else if (!this.journal.isDone("random11") && this.journal.isDone("random10") && this.hasItem("16020") && this.age > 39) {
            this.add("foreignarmy", armies[8]);
            this.journal.open("random11", "\u00a7- The army of " + mf.armies.getName(armies[1]) + " is attacking your country!");
        } else if (!this.journal.isDone("random12") && this.journal.isDone("random11") && this.hasItem("16020") && this.age > 44) {
            this.add("foreignarmy", armies[9]);
            this.journal.open("random12", "\u00a7- The army of " + mf.armies.getName(armies[1]) + " is attacking your country!");
        }
        int allCulture = 0;
        int i2 = 0;
        int j2 = cities.length;
        while (i2 < j2) {
            allCulture += this.getCulture(cities[i2]);
            ++i2;
        }
        this.culture = allCulture / cities.length;
        String[] shopCities = new String[]{"amsterdam", "budapest", "constantinopol", "hamburg", "lisboa", "london", "madrid", "moscow", "paris", "venice", "vienna"};
        String[] shops = new String[]{"12080", "12081", "12082", "12083", "12084", "12085", "12086", "12087", "12088", "12089", "12090"};
        int i3 = 0;
        int j3 = shops.length;
        while (i3 < j3) {
            if (this.hasItem(shops[i3])) {
                this.putShopMoney(shopCities[i3], 150);
            }
            ++i3;
        }
        this.chooseFace(true);
    }

    public void nextYear() {
        Mainframe mf = Mainframe.me;
        Random r = new Random();
        ++this.age;
        ++this.year;
        this.baseForce += 3;
        if (this.difficulty == 0) {
            this.baseForce += 2;
        }
        int i = 0;
        int j = cities.length;
        while (i < j) {
            this.attr.remove(String.valueOf(cities[i]) + "mappiece");
            ++i;
        }
        String[] ccities = new String[]{"venice", "lisboa", "paris", "hamburg", "moscow", "budapest", "vienna", "madrid", "london", "amsterdam"};
        int[] cultures = new int[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
        int whole = 0;
        int i2 = 0;
        int j2 = ccities.length;
        while (i2 < j2) {
            whole += cultures[i2];
            if (r.nextInt(10) > 7) {
                this.removeCulture(ccities[i2], (int)((double)cultures[i2] * r.nextDouble()));
            } else {
                this.addCulture(ccities[i2], (int)((double)cultures[i2] * r.nextDouble()));
            }
            ++i2;
        }
        if (r.nextInt(10) > 7) {
            this.addCulture("baghdad", whole / 10);
            this.addCulture("najaf", whole / 8);
            this.addCulture("anjoudan", whole / 8);
            this.addCulture("latakia", whole / 6);
            this.addCulture("konya", whole / 6);
            this.addCulture("baku", whole / 6);
            this.addCulture("constantinopol", whole / 3);
        } else {
            this.removeCulture("baghdad", whole / 10);
            this.removeCulture("najaf", whole / 8);
            this.removeCulture("anjoudan", whole / 8);
            this.removeCulture("latakia", whole / 6);
            this.removeCulture("konya", whole / 6);
            this.removeCulture("baku", whole / 6);
            this.removeCulture("constantinopol", whole / 3);
        }
        if (this.age > 50 && this.health < 60.0 && r.nextInt(100) < this.age || this.age > 70 && r.nextBoolean()) {
            mf.doActionOnEntering = "mf.gotoDialog(\"9120\");";
        }
    }

    public void chooseFace() {
        this.chooseFace(false, "");
    }

    public void chooseFace(String number) {
        this.chooseFace(false, number);
    }

    public void chooseFace(boolean nextMonth) {
        this.chooseFace(nextMonth, "");
    }

    public void chooseFace(boolean nextMonth, String number) {
        Mainframe mf = Mainframe.me;
        String beginning = "/pics/navigation/abus/abu_";
        this.ageType = this.age > 49 ? "old" : (this.age > 29 ? "middleaged" : "young");
        this.statusFace = number.equals("") ? (this.health < 10.0 ? String.valueOf(beginning) + this.ageType + "08.png" : (this.health < 20.0 ? String.valueOf(beginning) + this.ageType + "12.png" : (this.health < 35.0 ? (this.moral < -75 ? String.valueOf(beginning) + this.ageType + "07.png" : (this.moral > 75 ? String.valueOf(beginning) + this.ageType + "17.png" : String.valueOf(beginning) + this.ageType + "04.png")) : (this.health < 60.0 ? (this.moral < -75 ? String.valueOf(beginning) + this.ageType + "07.png" : (this.moral > 75 ? String.valueOf(beginning) + this.ageType + "17.png" : (this.money < 200 && mf.rB(0, 2) ? String.valueOf(beginning) + this.ageType + "15.png" : String.valueOf(beginning) + this.ageType + "01.png"))) : (this.health < 75.0 ? (this.moral < -75 ? String.valueOf(beginning) + this.ageType + "07.png" : (this.moral > 75 ? String.valueOf(beginning) + this.ageType + "17.png" : String.valueOf(beginning) + this.ageType + "06.png")) : (this.health < 90.0 ? (this.moral < -75 ? String.valueOf(beginning) + this.ageType + "07.png" : (this.moral > 75 ? String.valueOf(beginning) + this.ageType + "17.png" : String.valueOf(beginning) + this.ageType + "09.png")) : (this.moral < -75 ? String.valueOf(beginning) + this.ageType + "07.png" : (this.moral > 75 ? String.valueOf(beginning) + this.ageType + "17.png" : String.valueOf(beginning) + this.ageType + "11.png")))))))) : String.valueOf(beginning) + this.ageType + number + ".png";
    }

    public void addGood(int amount) {
        this.addBad(-amount);
    }

    public void addBad(int amount) {
        Mainframe mf = Mainframe.me;
        if (this.moral >= -100 - amount && this.moral <= 100 + amount) {
            this.moral -= amount;
        }
        this.chooseFace();
    }

    public void addAddiction(String addiction, int amount) {
        Mainframe mf = Mainframe.me;
        int value = 0;
        if (this.attr.containsKey(addiction)) {
            value = Integer.parseInt((String)this.attr.get(addiction));
        }
        this.attr.put(addiction, String.valueOf(value += amount));
        if (addiction.equals("hashish")) {
            if (value > 20 && mf.rB(0, 60)) {
                this.addictedHashish = true;
            } else if (value < 20) {
                this.addictedHashish = false;
            }
        } else if (addiction.equals("opium")) {
            if (value > 20 && mf.rB(0, 80)) {
                this.addictedOpium = true;
            } else if (value < 20) {
                this.addictedOpium = false;
            }
        } else if (addiction.equals("sick")) {
            if (value > 0) {
                this.sickGeneral = true;
            } else if (value <= 0) {
                this.sickGeneral = false;
            }
        } else if (addiction.equals("poisoned")) {
            if (value > 0) {
                this.sickPoisoned = true;
            } else if (value <= 0) {
                this.sickPoisoned = false;
            }
        } else if (addiction.equals("plague")) {
            if (value > 0) {
                this.sickPlague = true;
            } else if (value <= 0) {
                this.sickPlague = false;
            }
        }
        this.logo = "logoIntro";
        if (this.addictedHashish) {
            this.logo = "logoHashish";
        }
        if (this.addictedOpium) {
            this.logo = "logoOpium";
        }
        if (this.sickPlague || this.sickGeneral || this.sickPoisoned) {
            this.logo = "logoPlague";
        }
        this.chooseFace();
    }

    public void removeAddiction(String addiction) {
        if (addiction.equals("hashish")) {
            this.attr.remove(addiction);
            this.addictedHashish = false;
        } else if (addiction.equals("opium")) {
            this.attr.remove(addiction);
            this.addictedOpium = false;
        } else if (addiction.equals("sick")) {
            this.attr.remove(addiction);
            this.sickGeneral = false;
        } else if (addiction.equals("poisoned")) {
            this.attr.remove(addiction);
            this.sickPoisoned = false;
        } else if (addiction.equals("plague")) {
            this.attr.remove(addiction);
            this.sickPlague = false;
        }
        this.logo = "logoIntro";
        this.chooseFace();
    }

    public void removeAddictions() {
        this.removeAddiction("hashish");
        this.removeAddiction("opium");
        this.removeAddiction("sick");
        this.removeAddiction("poisoned");
        this.removeAddiction("plague");
    }

    public void switchItem(String id, String id2) {
        this.switchItem(id, id2, false);
    }

    public void switchItem(String id, String id2, boolean out) {
        try {
            if (!this.hasItem(id)) {
                return;
            }
            Mainframe mf = Mainframe.me;
            this.removeItem(id);
            Item item = mf.market.getItem(id2);
            if (!out) {
                item.where = this.place;
            }
            this.items.add(item);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean itemHere(String id) {
        Iterator iter = this.items.iterator();
        while (iter.hasNext()) {
            Item item = (Item)iter.next();
            if (!item.id.equals(id) || !item.here()) continue;
            return true;
        }
        return false;
    }

    public int itemsHere() {
        return this.itemsHere(this.place);
    }

    public int itemsHere(String place) {
        int counter = 0;
        Iterator iter = this.items.iterator();
        while (iter.hasNext()) {
            Item item = (Item)iter.next();
            if (!item.here(place)) continue;
            ++counter;
        }
        return counter;
    }

    public Vector itemsVector(String place) {
        Vector<Item> ret = new Vector<Item>();
        boolean counter = false;
        Iterator iter = this.items.iterator();
        while (iter.hasNext()) {
            Item item = (Item)iter.next();
            if (!item.here(place)) continue;
            ret.add(item);
        }
        return ret;
    }

    public void addCulture(String where, int amount) {
        this.removeCulture(where, -amount);
    }

    public void removeCulture(String where, int amount) {
        try {
            String parse = (String)this.attr.get("culture" + where);
            int value = Integer.parseInt(parse);
            amount = -amount;
            this.attr.put("culture" + where, String.valueOf(value += amount));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getCulture(String where) {
        try {
            String parse = (String)this.attr.get("culture" + where);
            int value = Integer.parseInt(parse);
            return value;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public void getShopMoney(String where) {
        try {
            String[] shops = new String[]{"amsterdam", "budapest", "constantinopol", "hamburg", "lisboa", "london", "madrid", "moscow", "paris", "venice", "vienna"};
            if (where.equals("all")) {
                int i = 0;
                int j = shops.length;
                while (i < j) {
                    String string = shops[i];
                    if (this.has(String.valueOf(where) + "shop")) {
                        String parse = (String)this.attr.get(String.valueOf(where) + "shop");
                        int value = Integer.parseInt(parse);
                        this.money += value;
                        this.attr.put(String.valueOf(where) + "shop", "0");
                    }
                    ++i;
                }
            } else if (this.has(String.valueOf(where) + "shop")) {
                String parse = (String)this.attr.get(String.valueOf(where) + "shop");
                int value = Integer.parseInt(parse);
                this.money += value;
                this.attr.put(String.valueOf(where) + "shop", "0");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void putShopMoney(String where, int amount) {
        try {
            if (this.has(String.valueOf(where) + "shop")) {
                String parse = (String)this.attr.get(String.valueOf(where) + "shop");
                int value = Integer.parseInt(parse);
                this.attr.put(String.valueOf(where) + "shop", String.valueOf(value += amount));
            } else {
                this.attr.put(String.valueOf(where) + "shop", "0");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

