/*
 * Decompiled with CFR 0.152.
 */
package org.spicetrade;

import java.util.Enumeration;
import java.util.Hashtable;
import org.spicetrade.tools.Sound;

public class Sounds {
    Hashtable sounds = new Hashtable();
    public boolean musicOn = true;
    public String lastMusic = "";
    public String currentMusic = "";

    public void playSound(String file, boolean loop) {
        if (!this.musicOn) {
            return;
        }
        try {
            if (this.isPlaying(file)) {
                return;
            }
            if (this.has(file)) {
                this.sounds.remove(file);
            }
            Sound sound = new Sound();
            sound.start(file, loop);
            this.sounds.put(file, sound);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void playSound(String file) {
        this.playSound(file, false);
    }

    public void loopSound(String file) {
        this.playSound(file, true);
    }

    public void playMusic(String file) {
        if (!this.musicOn) {
            return;
        }
        try {
            if (this.isPlaying(file)) {
                return;
            }
            this.stopAll();
            this.playSound(file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void loopMusic(String file) {
        if (!this.musicOn) {
            return;
        }
        try {
            if (this.isPlaying(file)) {
                return;
            }
            this.lastMusic = this.currentMusic;
            this.currentMusic = file;
            this.stopAll();
            this.loopSound(file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void stopSound(String file) {
        try {
            if (!this.isPlaying(file)) {
                return;
            }
            Sound sound = (Sound)this.sounds.get(file);
            sound.stop();
            this.sounds.remove(file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void stopAll() {
        Sound sound = null;
        Enumeration enumeration = this.sounds.elements();
        while (enumeration.hasMoreElements()) {
            sound = (Sound)enumeration.nextElement();
            sound.stop();
            this.sounds.remove(sound.name);
        }
        this.sounds = new Hashtable();
    }

    public boolean has(String file) {
        return this.sounds.containsKey(file);
    }

    public boolean isPlaying(String file) {
        if (this.has(file)) {
            Sound sound = (Sound)this.sounds.get(file);
            return sound.playing;
        }
        return false;
    }
}

