/*
 * Decompiled with CFR 0.152.
 */
package org.spicetrade;

import java.util.Iterator;
import java.util.Vector;
import org.spicetrade.Mainframe;
import org.spicetrade.tools.Collection;
import org.spicetrade.tools.Item;

public class Traders
extends Collection {
    public static final String xml = "/data/traders.xml";

    public Traders() {
        super(xml);
    }

    public void refresh() {
        this.refresh(xml);
    }

    public String getName(String s) {
        return this.getString(s, "Name");
    }

    public String getDisplay(String s) {
        return this.getString(s, "Display");
    }

    public int getDescription(String s) {
        return this.getInt(s, "Description");
    }

    public double getBuyFactor(String s) {
        return this.getDouble(s, "Buy factor");
    }

    public double getSellFactor(String s) {
        return this.getDouble(s, "Sell factor");
    }

    public int getSellPrice(String who, String id) {
        Mainframe mf = Mainframe.me;
        Item item = mf.market.getItem(id);
        int ret = (int)((double)item.price * this.getSellFactor(who));
        if (mf.player.difficulty == 0) {
            ret = (int)((double)ret * 1.15);
        }
        return ret;
    }

    public int getBuyPrice(String who, String id) {
        Mainframe mf = Mainframe.me;
        Item item = mf.market.getItem(id);
        int ret = (int)((double)item.price * this.getBuyFactor(who));
        if (mf.player.difficulty == 0) {
            ret = (int)((double)ret * 0.85);
        }
        return ret;
    }

    public Vector getBuyItems(String who) {
        return this.getItems("Buy items", who, false);
    }

    public Vector getSellItems(String who) {
        return this.getItems("Sell items", who, true);
    }

    public Vector getItems(String what, String who, boolean selling) {
        Mainframe mf = Mainframe.me;
        Vector<Item> res = new Vector<Item>();
        try {
            Vector v = this.getVector(who, what);
            Item item = new Item();
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                String s = (String)iter.next();
                item = mf.market.getItem(s);
                if (!selling && (item.id.equals("10100") || item.id.equals("10110") || item.id.equals("10120") || item.id.equals("10130") || item.id.equals("10200") || item.id.equals("10210") || item.id.equals("10220") || item.id.equals("10230")) && !mf.player.has(item.id)) {
                    res.add(item);
                    continue;
                }
                if (mf.player.hasItem(item.id) && selling && !mf.player.hasSold(item.id)) {
                    res.add(item);
                    continue;
                }
                if (mf.player.hasSold(item.id, who) || mf.player.hasItem(item.id) || selling) continue;
                res.add(item);
            }
            if (!selling) {
                Vector soldItems = mf.player.getSoldItems(who);
                Iterator iterator = soldItems.iterator();
                while (iterator.hasNext()) {
                    Item soldItem = (Item)iterator.next();
                    res.add(soldItem);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return res;
    }
}

