/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNEvent {
    private String myMimeType;
    private SVNErrorMessage myErrorMessage;
    private SVNEventAction myAction;
    private SVNNodeKind myNodeKind;
    private long myRevision;
    private SVNStatusType myContentsStatus;
    private SVNStatusType myPropertiesStatus;
    private SVNStatusType myLockStatus;
    private SVNLock myLock;
    private SVNAdminAreaInfo myAdminAreaInfo;
    private String myName;
    private String myPath;
    private File myRoot;
    private File myRootFile;
    private SVNEventAction myExpectedAction;

    public SVNEvent(SVNErrorMessage errorMessage) {
        this.myErrorMessage = errorMessage;
    }

    public SVNEvent(SVNAdminAreaInfo info, SVNAdminArea adminArea, String name, SVNEventAction action, SVNEventAction expectedAction, SVNNodeKind kind, long revision, String mimetype, SVNStatusType cstatus, SVNStatusType pstatus, SVNStatusType lstatus, SVNLock lock, SVNErrorMessage error) {
        this.myMimeType = mimetype;
        this.myErrorMessage = error;
        this.myExpectedAction = expectedAction != null ? expectedAction : action;
        this.myAction = action;
        this.myNodeKind = kind == null ? SVNNodeKind.UNKNOWN : kind;
        this.myRevision = revision;
        this.myContentsStatus = cstatus == null ? SVNStatusType.INAPPLICABLE : cstatus;
        this.myPropertiesStatus = pstatus == null ? SVNStatusType.INAPPLICABLE : pstatus;
        this.myLockStatus = lstatus == null ? SVNStatusType.INAPPLICABLE : lstatus;
        this.myLock = lock;
        this.myAdminAreaInfo = info;
        this.myRoot = adminArea != null ? adminArea.getRoot() : null;
        this.myName = name;
    }

    public SVNEvent(SVNAdminAreaInfo info, SVNAdminArea adminArea, String name, SVNEventAction action, SVNNodeKind kind, long revision, String mimetype, SVNStatusType cstatus, SVNStatusType pstatus, SVNStatusType lstatus, SVNLock lock, SVNErrorMessage error) {
        this(info, adminArea, name, action, null, kind, revision, mimetype, cstatus, pstatus, lstatus, lock, error);
    }

    public SVNEvent(File rootFile, File file, SVNEventAction action, SVNEventAction expected, SVNNodeKind kind, long revision, String mimetype, SVNStatusType cstatus, SVNStatusType pstatus, SVNStatusType lstatus, SVNLock lock, SVNErrorMessage error) {
        this.myMimeType = mimetype;
        this.myExpectedAction = expected != null ? expected : action;
        this.myErrorMessage = error;
        this.myAction = action;
        this.myNodeKind = kind == null ? SVNNodeKind.UNKNOWN : kind;
        this.myRevision = revision;
        this.myContentsStatus = cstatus == null ? SVNStatusType.INAPPLICABLE : cstatus;
        this.myPropertiesStatus = pstatus == null ? SVNStatusType.INAPPLICABLE : pstatus;
        this.myLockStatus = lstatus == null ? SVNStatusType.INAPPLICABLE : lstatus;
        this.myLock = lock;
        this.myRoot = file != null ? file.getParentFile() : null;
        this.myRootFile = rootFile;
        this.myName = file != null ? file.getName() : "";
    }

    public SVNEvent(File rootFile, File file, SVNEventAction action, SVNNodeKind kind, long revision, String mimetype, SVNStatusType cstatus, SVNStatusType pstatus, SVNStatusType lstatus, SVNLock lock, SVNErrorMessage error) {
        this(rootFile, file, action, null, kind, revision, mimetype, cstatus, pstatus, lstatus, lock, error);
    }

    public String getPath() {
        if (this.myPath != null) {
            return this.myPath;
        }
        if (this.myAdminAreaInfo == null && this.myRootFile == null) {
            return this.myName;
        }
        File file = this.getFile();
        File root = this.myAdminAreaInfo != null ? this.myAdminAreaInfo.getAnchor().getRoot() : this.myRootFile;
        String rootPath = root.getAbsolutePath().replace(File.separatorChar, '/');
        String filePath = file.getAbsolutePath().replace(File.separatorChar, '/');
        this.myPath = filePath.substring(rootPath.length());
        if (this.myPath.startsWith("/")) {
            this.myPath = this.myPath.substring(1);
        }
        return this.myPath;
    }

    public File getFile() {
        if (this.myRoot != null) {
            return "".equals(this.myName) || ".".equals(this.myName) ? this.myRoot : new File(this.myRoot, this.myName);
        }
        if (this.myAdminAreaInfo != null && this.getPath() != null) {
            return new File(this.myAdminAreaInfo.getAnchor().getRoot(), this.getPath());
        }
        return null;
    }

    public SVNEventAction getAction() {
        return this.myAction;
    }

    public SVNEventAction getExpectedAction() {
        return this.myExpectedAction;
    }

    public SVNStatusType getContentsStatus() {
        return this.myContentsStatus;
    }

    public SVNErrorMessage getErrorMessage() {
        return this.myErrorMessage;
    }

    public void setErrorMessage(SVNErrorMessage errorMessage) {
        this.myErrorMessage = errorMessage;
    }

    public SVNLock getLock() {
        return this.myLock;
    }

    public SVNStatusType getLockStatus() {
        return this.myLockStatus;
    }

    public String getMimeType() {
        return this.myMimeType;
    }

    public SVNNodeKind getNodeKind() {
        return this.myNodeKind;
    }

    public SVNStatusType getPropertiesStatus() {
        return this.myPropertiesStatus;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public void setPath(String path) {
        this.myPath = path;
    }
}

