/*
 * Decompiled with CFR 0.152.
 */
package gamemaker;

import gamemaker.Coordinate;
import gamemaker.Panels.GamePanel;
import gamemaker.Panels.XMLable;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.ArrayList;

public class Area
implements XMLable {
    private ArrayList<Coordinate> area;
    private boolean shapeComplete;
    private Polygon finalShape;
    private GamePanel panel;
    private Color strokeColor = Color.red;
    private BasicStroke strokeStyle = new BasicStroke(3.0f, 1, 2);
    private float fillOpacity = 0.3f;
    private GradientPaint fillGradient = new GradientPaint(0.0f, 0.0f, new Color(0, 0, 0), 3.0f, 3.0f, new Color(255, 255, 255), true);

    public Area(GamePanel panel) {
        this.area = new ArrayList(25);
        this.shapeComplete = false;
        this.panel = panel;
    }

    public Area(Coordinate startPoint, GamePanel panel) {
        this.area = new ArrayList(25);
        this.addPoint(startPoint);
        this.shapeComplete = false;
        this.panel = panel;
    }

    public Polygon getFinalShape() {
        return this.finalShape;
    }

    public int getSize() {
        return this.area.size();
    }

    public Coordinate getCoordinate(int index) {
        return this.area.get(index);
    }

    public void addPoint(Coordinate point) {
        if (this.shapeComplete) {
            this.clearPoints();
            this.shapeComplete = false;
        }
        this.area.add(point);
    }

    public void removeLastPoint() {
        int lastPoint = this.area.size() - 1;
        if (lastPoint >= 0) {
            this.area.remove(lastPoint);
        }
    }

    public void clearPoints() {
        this.area.clear();
        this.finalShape = null;
    }

    public boolean isComplete() {
        return this.shapeComplete;
    }

    public boolean isPointWithin(int x, int y) {
        if (this.finalShape == null) {
            return false;
        }
        return this.finalShape.contains(x, y);
    }

    private void createFinalShape() {
        int[] x = new int[this.area.size()];
        int[] y = new int[this.area.size()];
        for (int i = 0; i < this.area.size(); ++i) {
            x[i] = this.area.get(i).getX();
            y[i] = this.area.get(i).getY();
        }
        this.finalShape = new Polygon(x, y, this.area.size());
    }

    public void setComplete() {
        this.shapeComplete = true;
        this.createFinalShape();
    }

    public void setStrokeColor(Color c) {
        this.strokeColor = c;
    }

    public void setStrokeStyle(BasicStroke strokeStyle) {
        this.strokeStyle = strokeStyle;
    }

    public void setFillOpacity(float opacity) {
        this.fillOpacity = opacity;
    }

    public void setFillGradient(Color c1, Color c2) {
        this.fillGradient = new GradientPaint(0.0f, 0.0f, c1, 3.0f, 3.0f, c2, true);
    }

    public void setFillGradient(GradientPaint f) {
        this.fillGradient = f;
    }

    public void setFill(Color c1) {
        this.fillGradient = new GradientPaint(0.0f, 0.0f, c1, 3.0f, 3.0f, c1, true);
    }

    public void drawArea(Graphics2D g2) {
        g2.setColor(this.strokeColor);
        g2.setStroke(this.strokeStyle);
        if (!this.isComplete()) {
            for (int i = 0; i < this.getSize() - 1; ++i) {
                int thisIndex = i % this.getSize();
                int nextIndex = (i + 1) % this.getSize();
                g2.drawLine(this.getCoordinate(thisIndex).getX(), this.getCoordinate(thisIndex).getY(), this.getCoordinate(nextIndex).getX(), this.getCoordinate(nextIndex).getY());
            }
        }
        if (this.isComplete() && this.getSize() > 0) {
            g2.setPaint(this.fillGradient);
            g2.setComposite(AlphaComposite.getInstance(3, this.fillOpacity));
            g2.fill(this.finalShape);
            g2.setColor(Color.BLACK);
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g2.draw(this.finalShape);
        } else if (this.getSize() > 0 && !this.isComplete()) {
            g2.drawLine(this.getCoordinate(this.getSize() - 1).getX(), this.getCoordinate(this.getSize() - 1).getY(), this.panel.getLastMousePosition().getX(), this.panel.getLastMousePosition().getY());
        }
    }

    public boolean isValid() {
        return this.getSize() >= 3;
    }

    public String toXML() {
        return this.toXML("<area>", "</area>");
    }

    public String toXML(String openTag, String closeTag) {
        String xml = "";
        xml = xml + openTag + "\n";
        for (int i = 0; i < this.area.size(); ++i) {
            xml = xml + "<point index=\"" + i + "\" xaxis=\"" + this.area.get(i).getX() + "\" yaxis=\"" + this.area.get(i).getY() + "\" />";
            xml = xml + "\n";
        }
        xml = xml + closeTag + "\n";
        return xml;
    }

    public String toString() {
        String theString = "";
        for (int j = 0; j < this.area.size(); ++j) {
            theString = theString + "" + this.area.get(j).toString() + "\n";
        }
        return theString;
    }
}

