/*
 * Decompiled with CFR 0.152.
 */
package gamemaker;

import gamemaker.GameMaps;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public class ImageList
extends JList {
    private JScrollPane listScrollPane;
    private JPanel listPane;
    private Vector vector;
    private ArrayList<JPanel> listItems;
    private static final int LISTWIDTH = 197;
    private static final int LISTHEIGHT = 70;
    private GameMaps maps;

    public ImageList(GameMaps maps) {
        this.maps = maps;
        this.setCellRenderer(new ImageCellRenderer());
        this.listPane = new JPanel();
        this.listItems = new ArrayList();
    }

    public void repaint() {
        if (this.maps != null && this.maps.getCurrentMapIndex() >= 0) {
            this.setSelectedIndex(this.maps.getCurrentMapIndex());
        }
        if (this.listItems != null) {
            for (int i = 0; i < this.listItems.size(); ++i) {
                this.listItems.get(i).repaint();
            }
        }
        if (this.listPane != null) {
            this.listPane.repaint();
        }
        super.repaint();
    }

    public JScrollPane getListScrollPanel() {
        this.refreshVector();
        this.setListData(this.vector);
        this.listPane = new JPanel();
        this.listPane.setLayout(new BoxLayout(this.listPane, 1));
        this.listPane.add(this);
        this.listPane.setForeground(Color.black);
        this.listPane.setBackground(Color.WHITE);
        this.listScrollPane = new JScrollPane();
        this.listScrollPane.add(this.listPane);
        this.listScrollPane.setViewportView(this.listPane);
        this.listScrollPane.setVisible(true);
        this.listPane.setVisible(true);
        return this.listScrollPane;
    }

    public void refreshVector() {
        this.vector = new Vector();
        for (int i = 0; i < this.listItems.size(); ++i) {
            this.vector.addElement(this.listItems.get(i));
        }
    }

    public void increaseListCount() {
        JPanel p = new JPanel();
        this.listItems.add(p);
    }

    public void addListItem(JPanel p) {
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        p.setLayout(flowLayout);
        p.setPreferredSize(new Dimension(197, 70));
        p.setSize(new Dimension(197, 70));
        p.setBackground(Color.red);
        p.setVisible(true);
        this.listItems.add(p);
    }

    public void addListItem(Component comp) {
        JPanel p = new JPanel();
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        p.setLayout(flowLayout);
        p.setPreferredSize(new Dimension(197, 70));
        p.setSize(new Dimension(197, 70));
        p.add(comp);
        p.setAlignmentX(0.0f);
        this.listItems.add(p);
        p.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
    }

    public void addComponentToListIndex(int index, Component comp) {
        this.listItems.get(index).add(comp);
    }

    public void addComponentToLastListItem(Component comp) {
        this.listItems.get(this.listItems.size() - 1).add(comp);
    }

    class ImageCellRenderer
    implements ListCellRenderer {
        ImageCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = (Component)value;
            Color background = isSelected ? new Color(145, 179, 242) : Color.white;
            Color foreground = isSelected ? Color.white : new Color(145, 179, 242);
            component.setBackground(background);
            component.setForeground(foreground);
            return component;
        }
    }
}

