/*
 * Decompiled with CFR 0.152.
 */
package gamemaker.Panels;

import gamemaker.GameMap;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

public class DialoguePanel
extends JPanel {
    public final int TYPE_MESSAGE = 1;
    private boolean displayDialogue;
    private String message;
    private Font boxFont = new Font("Arial", 0, 24);
    private GameMap gameMap;
    private final int boxmargin = 10;

    public DialoguePanel(GameMap gameMap) {
        this.setOpaque(false);
        this.setLayout(null);
        this.displayDialogue = false;
        this.gameMap = gameMap;
        this.setMessage("No Dialogue Set liubl bhl hbl jbhl  \n testing this thing \n one \n two \n three four five six seven eight nine ten \n 11 \n 12");
    }

    public void setDialogueOn(boolean isOn) {
        this.displayDialogue = isOn;
        this.repaint();
    }

    public void action() {
        this.displayDialogue = false;
        this.repaint();
    }

    public boolean isDialogueDisplayed() {
        return this.displayDialogue;
    }

    public void setMessage(String message) {
        message = message.replace("\n ", System.getProperty("line.separator"));
        message = message.replace(" \n", System.getProperty("line.separator"));
        message = message.replace(" \n ", System.getProperty("line.separator"));
        this.message = message = message.replace("\n", System.getProperty("line.separator"));
    }

    private int[] getStringCharWidth(String s) {
        int i;
        String[] strings = s.split(System.getProperty("line.separator"));
        int[] size = new int[]{0, 0};
        for (i = 0; i < strings.length; ++i) {
            int len = strings[i].length();
            if (len <= size[0]) continue;
            size[0] = len;
        }
        size[1] = i;
        return size;
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.displayDialogue) {
            int viewWidth = (int)Math.ceil(this.gameMap.getGameMaps().getPaintPanel().getVisibleRect().getWidth());
            int viewHeight = (int)Math.ceil(this.gameMap.getGameMaps().getPaintPanel().getVisibleRect().getHeight());
            int viewx = this.gameMap.getGameMaps().getPaintPanel().getTopX();
            int viewy = this.gameMap.getGameMaps().getPaintPanel().getTopY();
            int[] stringSize = this.getStringCharWidth(this.message);
            int numlines = this.message.split(System.getProperty("line.separator")).length;
            this.message.replace("\n", System.getProperty("line.separator"));
            String temp = this.message.replace(" ", "");
            int width = 10;
            if (temp.length() != 0) {
                TextLayout textLayout = new TextLayout(this.getLongestLine(this.message), this.boxFont, g2.getFontRenderContext());
                width = (int)textLayout.getBounds().getWidth() + 30;
            }
            int height = (int)Math.ceil(this.boxFont.getStringBounds(this.message, g2.getFontRenderContext()).getHeight()) * numlines + 20;
            int x = viewx + viewWidth / 2 - width / 2;
            int y = viewy + viewHeight / 2 - height / 2;
            Rectangle2D.Double area = new Rectangle2D.Double(viewx, viewy, viewWidth, viewHeight);
            g2.setColor(new Color(255, 255, 255, 200));
            g2.fill(area);
            g2.setColor(Color.DARK_GRAY);
            g2.fill(new Rectangle2D.Double(x + 5, y + 5, width, height));
            g2.setColor(new Color(230, 230, 230));
            Rectangle2D.Double rect = new Rectangle2D.Double(x, y, width, height);
            g2.fill(rect);
            g2.setColor(Color.black);
            g2.draw(rect);
            this.drawText(this.message, g2, x, y);
            g2.setColor(Color.black);
            g2.fill(new Rectangle2D.Double(x, y - this.boxFont.getSize() - 10, 130.0, 34.0));
            g2.setColor(Color.white);
            this.drawText("Message:", g2, x, y - this.boxFont.getSize() - 10 - 10);
        }
    }

    private String getLongestLine(String message) {
        message.replace("\n", System.getProperty("line.separator"));
        String[] lines = message.split(System.getProperty("line.separator"));
        int longestIndex = -1;
        int largestCount = 0;
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].length() <= largestCount) continue;
            longestIndex = i;
            largestCount = lines[i].length();
        }
        if (longestIndex != -1) {
            return lines[longestIndex];
        }
        return "";
    }

    private void drawText(String text, Graphics2D g2, int x, int y) {
        int margin = 3;
        int lineheight = (int)Math.ceil(this.boxFont.getStringBounds(this.message, g2.getFontRenderContext()).getHeight());
        g2.setFont(this.boxFont);
        String[] strings = text.split(System.getProperty("line.separator"));
        for (int i = 0; i < strings.length; ++i) {
            g2.drawString(strings[i], 10 + x, 10 + y + this.boxFont.getSize() + lineheight * i);
        }
    }
}

