/*
 * Decompiled with CFR 0.152.
 */
package gamemaker.Panels;

import gamemaker.Coordinate;
import gamemaker.Exceptions.SpriteNotSetException;
import gamemaker.GameMap;
import gamemaker.Panels.EventPanel;
import gamemaker.Panels.GamePanel;
import gamemaker.Perspective;
import gamemaker.Sprite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.io.IOException;

public class SpritePanel
extends GamePanel {
    private Sprite theSprite;
    private boolean displaySprite = true;
    private Perspective perspective;
    private EventPanel eventPanel;
    private GameMap gameMap;

    public SpritePanel(Sprite s, GameMap gameMap) throws IOException {
        this.theSprite = s;
        this.gameMap = gameMap;
        this.theSprite.loadDefaultSprite();
        this.perspective = new Perspective();
        this.setOpaque(false);
        this.setDoubleBuffered(true);
    }

    public Sprite getSprite() {
        return this.theSprite;
    }

    public void setSprite(Sprite newSprite) {
        this.theSprite = newSprite;
    }

    public void setEventPanel(EventPanel eventPanel) {
        this.eventPanel = eventPanel;
    }

    public void setSpritePosition(Point p) {
        this.theSprite.setSpritePosition(p);
    }

    public Coordinate getSpritePositionCoord() {
        return new Coordinate(this.theSprite.getSpritePosition().getX(), this.theSprite.getSpritePosition().getY());
    }

    public Point getSpritePosition() {
        return this.theSprite.getSpritePosition();
    }

    public void setPerspective(Perspective p) {
        this.perspective = p;
        this.repaint();
    }

    public Perspective getPerspective() {
        return this.perspective;
    }

    public void setDisplaySprite(boolean displaySprite) {
        this.displaySprite = displaySprite;
    }

    public void paintComponent(Graphics g) {
        Panel p = new Panel();
        Graphics2D g2 = (Graphics2D)g;
        if (this.displaySprite && this.theSprite != null && this.theSprite.isImageSet() && this.theSprite.getCurrentGameMap().equals(this.gameMap)) {
            try {
                Image spriteToPaint = this.theSprite.getSpriteImage(this.theSprite.getSpritePosition(), this.perspective);
                int drawX = (int)Math.round(this.theSprite.getSpritePosition().getX() - (double)(spriteToPaint.getWidth(p) / 2));
                int drawY = (int)Math.round(this.theSprite.getSpritePosition().getY() - (double)spriteToPaint.getHeight(p));
                g2.drawImage(spriteToPaint, drawX, drawY, this);
            }
            catch (SpriteNotSetException snse) {
                System.err.println(snse);
            }
        }
    }
}

