/*
 * Decompiled with CFR 0.152.
 */
package gamemaker;

import gamemaker.Coordinate;
import gamemaker.Exceptions.GameXmlIncorrectException;
import gamemaker.Exceptions.SpriteNotSetException;
import gamemaker.FileHandler;
import gamemaker.GameMap;
import gamemaker.Panels.XMLable;
import gamemaker.Perspective;
import gamemaker.XMLSimplify;
import gamemaker.events.VariableOperation;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.jdom.Element;

public class Sprite
implements XMLable {
    public final int NORTH = 0;
    public final int NORTHEAST = 1;
    public final int EAST = 2;
    public final int SOUTHEAST = 3;
    public final int SOUTH = 4;
    public final int SOUTHWEST = 5;
    public final int WEST = 6;
    public final int NORTHWEST = 7;
    private final int NUMDIRECTIONS = 8;
    private Point spritePosition;
    private int currentMap = 0;
    private GameMap currentGameMap;
    private Image[][] spriteImages = new Image[8][];
    private boolean imageSet = false;
    private String spriteNumber;
    private int currentDirection = 4;
    private int currentStep = 0;
    double movespeed = 50.0;
    private String workingDir = "";
    private int[] spriteVars = new int[10];

    public Sprite() {
        this.spritePosition = new Point(500, 500);
        this.workingDir = this.getClass().getResource("").getPath();
        this.workingDir = this.workingDir.replace("%20", " ") + "files/";
    }

    public Image[][] getImageArray() {
        return this.spriteImages;
    }

    public void setImageArray(Image[][] images) {
        this.spriteImages = images;
    }

    public int getSpriteVar(int index) {
        return this.spriteVars[index];
    }

    public void setSpriteVar(int index, int value) {
        this.spriteVars[index] = value;
    }

    public int getNumSpriteVars() {
        return this.spriteVars.length;
    }

    public Point getSpritePosition() {
        return this.spritePosition;
    }

    public Coordinate getSpritePositionCoord() {
        return new Coordinate(this.spritePosition.getX(), this.spritePosition.getY());
    }

    public void setSpritePosition(Point c) {
        this.spritePosition = c;
    }

    public void setVariable(VariableOperation operation) {
        operation.applyChange(this);
    }

    public void setStartPosition(GameMap map, int mapIndex, Point c) {
        this.currentGameMap = map;
        this.spritePosition = c;
        this.setCurrentMap(mapIndex);
    }

    public void setCurrentGameMap(GameMap map) {
        this.currentGameMap = map;
    }

    public void setCurrentMap(int mapID) {
        this.currentMap = mapID;
    }

    public int getCurrentMap() {
        return this.currentMap;
    }

    public GameMap getCurrentGameMap() {
        return this.currentGameMap;
    }

    public void setSpriteSpeed(double movespeed) {
        this.movespeed = movespeed;
    }

    public double getSpriteSpeed() {
        return this.movespeed;
    }

    public Image getSpriteImage() {
        return this.spriteImages[this.currentDirection][this.currentStep];
    }

    public Image getSpriteImage(Point point, Perspective perspective) throws SpriteNotSetException {
        if (this.spriteImages[this.currentDirection][this.currentStep] != null && this.spriteImages[this.currentDirection] != null && this.spriteImages != null) {
            Panel p = new Panel();
            int height = this.spriteImages[this.currentDirection][this.currentStep].getHeight(p);
            int width = this.spriteImages[this.currentDirection][this.currentStep].getWidth(p);
            Dimension dimension = perspective.getPerspetiveDimensions(new Dimension(width, height), point);
            if ((int)dimension.getWidth() != 0 && (int)dimension.getHeight() != 0) {
                return this.spriteImages[this.currentDirection][this.currentStep].getScaledInstance((int)dimension.getWidth(), (int)dimension.getHeight(), 1);
            }
            return this.spriteImages[this.currentDirection][this.currentStep];
        }
        String error = "Coordinate:" + point + " Perspective:" + perspective;
        error = error + " currentDirection: " + this.currentDirection + " CurrentStep: " + this.currentStep;
        throw new SpriteNotSetException(error);
    }

    public void setSpriteFacing(int direction) {
        this.currentDirection = direction % 8;
    }

    public void takeStep() {
        this.currentStep = (this.currentStep + 1) % this.spriteImages[this.currentDirection].length;
        if (this.currentStep == 0) {
            ++this.currentStep;
        }
    }

    public void stopWalk() {
        this.currentStep = 0;
    }

    public boolean isImageSet() {
        return this.imageSet;
    }

    public void loadDefaultSprite() throws IOException {
        this.spriteNumber = "0001";
        this.setSpriteFromFolder(this.spriteNumber);
    }

    public void setSpriteFromFolder(String spriteDir) throws IOException {
        this.spriteNumber = spriteDir;
        this.spriteImages[0] = this.loadDirection("sprite/" + spriteDir + "/N/");
        this.spriteImages[1] = this.loadDirection("sprite/" + spriteDir + "/NE/");
        this.spriteImages[2] = this.loadDirection("sprite/" + spriteDir + "/E/");
        this.spriteImages[3] = this.loadDirection("sprite/" + spriteDir + "/SE/");
        this.spriteImages[4] = this.loadDirection("sprite/" + spriteDir + "/S/");
        this.spriteImages[5] = this.loadDirection("sprite/" + spriteDir + "/SW/");
        this.spriteImages[6] = this.loadDirection("sprite/" + spriteDir + "/W/");
        this.spriteImages[7] = this.loadDirection("sprite/" + spriteDir + "/NW/");
        this.imageSet = true;
    }

    private Image[] loadDirection(String path) throws IOException {
        File f = new File(FileHandler.getFilesLocation() + path);
        ArrayList<Image> images = new ArrayList<Image>();
        ArrayList<String> names = new ArrayList<String>();
        int counter = 0;
        for (int i = 0; i < f.listFiles().length; ++i) {
            if (!this.isImageExtension(this.getFileExtension(f.listFiles()[i].getName()))) continue;
            images.add(ImageIO.read(f.listFiles()[i]));
            names.add(f.listFiles()[i].getName());
            ++counter;
        }
        for (int i = 0; i < counter; ++i) {
            for (int j = 0; j < counter; ++j) {
                if (((String)names.get(i)).compareTo((String)names.get(j)) >= 0) continue;
                Image tempI = (Image)images.get(i);
                images.set(i, (Image)images.get(j));
                images.set(j, tempI);
                String tempS = (String)names.get(i);
                names.set(i, (String)names.get(j));
                names.set(j, tempS);
            }
        }
        Image[] image = new Image[counter];
        for (int i = 0; i < counter; ++i) {
            image[i] = (Image)images.get(i);
        }
        return image;
    }

    private boolean isImageExtension(String extension) {
        return extension.equals("png") || extension.equals("PNG") || extension.equals("GIF") || extension.equals("gif") || extension.equals("jpeg") || extension.equals("jpg") || extension.equals("JPEG") || extension.equals("JPG");
    }

    private String getFileExtension(String fileName) {
        String[] parts = fileName.split("\\.");
        return parts[parts.length - 1];
    }

    public void fromXML(Element spriteElement) throws GameXmlIncorrectException {
        Element location = XMLSimplify.getStrictlySingleElement(spriteElement, "location");
        Element appearance = XMLSimplify.getStrictlySingleElement(spriteElement, "appearance");
        Element variables = XMLSimplify.getStrictlySingleElement(spriteElement, "appearance");
        int mapid = (int)XMLSimplify.getXMLDouble(location, "mapid");
        int xaxis = (int)XMLSimplify.getXMLDouble(location, "xaxis");
        int yaxis = (int)XMLSimplify.getXMLDouble(location, "yaxis");
        String spriteRef = appearance.getAttribute("ref").getValue();
        try {
            this.setSpriteFromFolder(spriteRef);
        }
        catch (IOException dce) {
            throw new GameXmlIncorrectException("The sprite reference folder does not exist.");
        }
        List elements = variables.getChildren("gamemap");
        for (int i = 0; i < elements.size(); ++i) {
            this.setSpriteVar(i, XMLSimplify.getXMLInt((Element)elements.get(i), "variable"));
        }
        this.setCurrentMap(mapid);
        this.setSpritePosition(new Point(xaxis, yaxis));
    }

    public String toXML() {
        return this.toXML("<sprite>", "</sprite>");
    }

    public String toXML(String openTag, String closeTag) {
        String xml = "";
        xml = xml + openTag + "\n";
        xml = xml + "<location mapid=\"" + this.currentMap + "\" xaxis=\"" + this.spritePosition.getX() + "\" yaxis=\"" + this.spritePosition.getY() + "\"/>" + "\n";
        xml = xml + "<appearance ref=\"" + this.spriteNumber + "\" />" + "\n";
        xml = xml + "<variables>";
        for (int i = 0; i < this.getNumSpriteVars(); ++i) {
            xml = xml + "<variable index=\"" + i + "\" value=\"" + this.getSpriteVar(i) + "\" />";
        }
        xml = xml + "</variables>";
        xml = xml + closeTag + "\n";
        return xml;
    }

    public String toString() {
        String s = "Sprite coordinates:" + this.spritePosition + " currentMapID:" + this.currentMap + ".\n";
        for (int i = 0; i < this.getNumSpriteVars(); ++i) {
            s = s + "Var " + i + ":" + this.getSpriteVar(i) + "\n";
        }
        return s;
    }
}

