/*
 * Decompiled with CFR 0.152.
 */
package gamemaker;

import gamemaker.Coordinate;
import gamemaker.FileHandler;
import gamemaker.GameMaps;
import gamemaker.RightPanels.MapList_RightPanel;
import gamemaker.TeleportLocation;
import gamemaker.events.ListActionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;

public class TeleportInput
implements ListActionListener {
    private JDialog theDialog;
    private JScrollPane scrollPane;
    private MapList_RightPanel rightPanel;
    private JPanel buttonPanel;
    private JPanel infoPanel;
    private JLabel label;
    private GameMaps maps;
    private TeleportLocation teleportTo;
    private int initialMap;
    private Image markerImage;

    public TeleportInput(GameMaps maps) {
        this.maps = maps;
        this.teleportTo = new TeleportLocation(100, 100, 0);
        this.initialMap = maps.getCurrentMapIndex();
        this.label = new JLabel(this.teleportTo.toString());
        this.infoPanel = new JPanel();
        this.infoPanel.add(this.label);
        this.buttonPanel = new JPanel();
        this.rightPanel = new MapList_RightPanel(maps, this);
        try {
            this.markerImage = ImageIO.read(new File(FileHandler.getFilesLocation() + "mapmarker.png"));
            if (this.markerImage != null) {
                maps.getCurrentMap().getGlassPanel().setMarker(this.markerImage);
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
    }

    private void constructFrame() {
        this.teleportTo = new TeleportLocation(100, 100, 0);
        this.maps.getCurrentMap().getGlassPanel().setMarkerPosition(new Coordinate(100, 100));
        this.label.setText(this.teleportTo.toString());
        this.theDialog = new JDialog();
        this.theDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.theDialog.setSize(800, 600);
        this.theDialog.setTitle("Please Select A map to teleport to");
        this.theDialog.setDefaultCloseOperation(2);
        this.theDialog.setLocationRelativeTo(null);
        this.theDialog.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this.maps.getCurrentMap());
        BoxLayout buttonBoxLayout = new BoxLayout(this.buttonPanel, 0);
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.setLayout(buttonBoxLayout);
        JButton ok = new JButton("OK");
        JButton cancel = new JButton("Cancel");
        ok.addActionListener(this);
        cancel.addActionListener(this);
        this.buttonPanel.add((Component)ok, "align right");
        this.buttonPanel.add((Component)cancel, "align right");
        this.theDialog.add((Component)this.scrollPane, "Center");
        this.theDialog.add((Component)this.rightPanel, "East");
        this.theDialog.add((Component)this.buttonPanel, "South");
        this.theDialog.add((Component)this.infoPanel, "North");
        this.maps.getCurrentMap().setTeleportLocation(this);
        this.theDialog.setVisible(true);
        this.scrollPane.setVisible(true);
        this.scrollPane.repaint();
        this.theDialog.repaint();
    }

    public TeleportLocation getInput() {
        this.constructFrame();
        this.maps.getCurrentMap().unsetTeleportLocation();
        this.maps.setCurrentMap(this.initialMap);
        this.maps.repaint();
        this.maps.getMapsContainer().repaint();
        this.maps.clearAllMarkers();
        return this.teleportTo;
    }

    public void setCoordinate(Coordinate c) {
        this.teleportTo.setX(c.getX());
        this.teleportTo.setY(c.getY());
        this.maps.getCurrentMap().getGlassPanel().setMarkerPosition(c);
        this.maps.repaint();
        this.label.setText(this.teleportTo.toString());
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OK")) {
            if (this.theDialog != null) {
                this.closeDialogue();
            }
            this.maps.repaint();
            this.maps.getMapsContainer().repaint();
        } else if (e.getActionCommand().equals("Cancel")) {
            this.teleportTo = null;
            if (this.theDialog != null) {
                this.closeDialogue();
            }
            this.maps.repaint();
            this.maps.getMapsContainer().repaint();
        }
    }

    public void closeDialogue() {
        this.theDialog.setVisible(false);
        this.theDialog.dispose();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && this.rightPanel != null && this.rightPanel.getList().getSelectedIndex() >= 0) {
            this.maps.getCurrentMap().unsetTeleportLocation();
            this.maps.getCurrentMap().getGlassPanel().clearMarker();
            this.scrollPane.remove(this.maps.getCurrentMap());
            this.maps.setCurrentMap(this.rightPanel.getList().getSelectedIndex());
            this.scrollPane.add(this.maps.getCurrentMap());
            this.scrollPane.setViewportView(this.maps.getCurrentMap());
            this.maps.getCurrentMap().setTeleportLocation(this);
            this.teleportTo.setMapIndex(this.maps.getCurrentMapIndex());
            this.label.setText(this.teleportTo.toString());
            this.maps.getCurrentMap().getGlassPanel().setMarker(this.markerImage);
            this.maps.getCurrentMap().getGlassPanel().setMarkerPosition(new Coordinate(this.teleportTo.getX(), this.teleportTo.getY()));
        }
    }
}

