/*
 * Decompiled with CFR 0.152.
 */
package gamemaker.events;

import gamemaker.Exceptions.GameXmlIncorrectException;
import gamemaker.Exceptions.IllegalReferenceValueException;
import gamemaker.Panels.XMLable;
import gamemaker.Sprite;
import gamemaker.XMLSimplify;
import java.util.List;
import org.jdom.Element;

public class EventCondition
implements XMLable {
    private int variableIndex1 = -1;
    private int variableIndex2 = -1;
    private int value = 0;
    private int operation = -1;
    private boolean conditionEnabled = true;
    private boolean valOrVarCondition = false;
    public static final boolean USE_VALUE = true;
    public static final boolean USE_VARIABLE = false;
    public static final int GREATER_THAN = 0;
    public static final int LESS_THAN = 1;
    public static final int EQUAL_TO = 2;
    public static final int GREATER_THAN_OR_EQUAL_TO = 3;
    public static final int LESS_THAN_OR_EQUAL_TO = 4;
    public static final int NOT_EQUAL_TO = 5;

    public EventCondition(int varIndex1, int valOrVarIndex, int operator, boolean varOrVal) throws IllegalReferenceValueException {
        this.variableIndex1 = varIndex1;
        this.variableIndex2 = valOrVarIndex;
        this.value = valOrVarIndex;
        this.valOrVarCondition = varOrVal;
        if (operator < 0 || operator > 5) {
            throw new IllegalReferenceValueException("Operator must be >0 and <=5");
        }
        this.operation = operator;
    }

    public EventCondition() {
        this.conditionEnabled = false;
    }

    public EventCondition(Element e) throws GameXmlIncorrectException {
        this.fromXML(e);
    }

    public boolean isConditionEnabled() {
        return this.conditionEnabled;
    }

    private boolean compare(int value1, int value2) {
        if (this.operation == 0) {
            return value1 > value2;
        }
        if (this.operation == 1) {
            return value1 < value2;
        }
        if (this.operation == 3) {
            return value1 >= value2;
        }
        if (this.operation == 4) {
            return value1 <= value2;
        }
        if (this.operation == 2) {
            return value1 == value2;
        }
        if (this.operation == 5) {
            return value1 != value2;
        }
        return false;
    }

    public boolean isConditionSatisfied(Sprite s) {
        if (this.conditionEnabled) {
            if (!this.valOrVarCondition) {
                return this.compare(s.getSpriteVar(this.variableIndex1), s.getSpriteVar(this.variableIndex2));
            }
            if (this.valOrVarCondition) {
                return this.compare(s.getSpriteVar(this.variableIndex1), this.value);
            }
            return false;
        }
        return true;
    }

    public void enableCondition() {
        this.conditionEnabled = true;
    }

    public void disableCondition() {
        this.conditionEnabled = false;
    }

    public String toXML() {
        String opening = "";
        String closing = "";
        return this.toXML(opening, closing);
    }

    public String toXML(String openTag, String closeTag) {
        String xml = "";
        xml = xml + openTag + "\n";
        String varOrVal = "";
        int v2 = 0;
        if (this.valOrVarCondition) {
            varOrVal = "value";
            v2 = this.value;
        } else if (!this.valOrVarCondition) {
            varOrVal = "variable";
            v2 = this.variableIndex2;
        }
        String enabled = "";
        enabled = this.conditionEnabled ? "true" : "false";
        xml = xml + "<eventcondition v1=\"" + this.variableIndex1 + "\" " + "v2=\"" + v2 + "\" " + "varorval=\"" + varOrVal + "\" " + "operation=\"" + this.operation + "\" " + "enabled=\"" + enabled + "\" />";
        xml = xml + closeTag + "\n";
        return xml;
    }

    private boolean varOrValFromString(String varorval) throws GameXmlIncorrectException {
        if ((varorval = varorval.toLowerCase()).equals("value")) {
            return true;
        }
        if (varorval.equals("variable")) {
            return false;
        }
        throw new GameXmlIncorrectException("varorval variable incorrectly defined.");
    }

    public void fromXML(Element element) throws GameXmlIncorrectException {
        List elements = element.getChildren("eventcondition");
        int size = elements.size();
        if (size <= 0) {
            this.conditionEnabled = false;
        } else if (size == 1) {
            this.variableIndex1 = XMLSimplify.getXMLInt((Element)elements.get(0), "v1");
            this.value = this.variableIndex2 = XMLSimplify.getXMLInt((Element)elements.get(0), "v2");
            this.valOrVarCondition = this.varOrValFromString(((Element)elements.get(0)).getAttribute("varorval").getValue());
            int opcode = XMLSimplify.getXMLInt((Element)elements.get(0), "operation");
            this.conditionEnabled = XMLSimplify.getXMLBool((Element)elements.get(0), "enabled");
            if (opcode < -1 || opcode >= 6) {
                throw new GameXmlIncorrectException("operation must be between 0 and 5");
            }
            this.operation = opcode;
        } else {
            throw new GameXmlIncorrectException("There can only be one event condition element per event.");
        }
    }
}

