/*
 * Decompiled with CFR 0.152.
 */
package gamemaker.events;

import gamemaker.Sprite;

public class VariableOperation {
    private int indexToChange;
    private int value;
    private int operation;
    public static final int NOTHING = -1;
    public static final int ADD = 0;
    public static final int SUBTRACT = 1;
    public static final int SET = 2;

    public VariableOperation() {
        this.indexToChange = -1;
        this.value = 0;
        this.operation = 0;
    }

    public VariableOperation(int indexToChange, int value, int operation) {
        this.setUp(indexToChange, value, operation);
    }

    public VariableOperation(int indexToChange, int value, String operation) {
        this.setUp(indexToChange, value, this.operationFromString(operation));
    }

    public void setUp(int indexToChange, int value, int operation) {
        this.value = value;
        this.indexToChange = indexToChange;
        this.operation = operation;
    }

    public void applyChange(Sprite s) throws ArrayIndexOutOfBoundsException {
        if (this.indexToChange < s.getNumSpriteVars() && this.indexToChange >= 0) {
            if (this.operation == 0) {
                s.setSpriteVar(this.indexToChange, s.getSpriteVar(this.indexToChange) + this.value);
            } else if (this.operation == 1) {
                s.setSpriteVar(this.indexToChange, s.getSpriteVar(this.indexToChange) - this.value);
            } else if (this.operation == 2) {
                s.setSpriteVar(this.indexToChange, this.value);
            }
        } else {
            throw new ArrayIndexOutOfBoundsException("incorrect sprite variable index.");
        }
    }

    public int operationFromString(String string) {
        if (string.equals("add")) {
            return 0;
        }
        if (string.equals("subtract")) {
            return 1;
        }
        if (string.equals("set")) {
            return 2;
        }
        return -1;
    }

    public String operationToString() {
        String s = "nothing";
        if (this.operation == 0) {
            s = "add";
        } else if (this.operation == 1) {
            s = "subtract";
        } else if (this.operation == 2) {
            s = "set";
        }
        return s;
    }

    public String toXML() {
        String opening = "<variable index=\"" + this.indexToChange + "\" " + "value=\"" + this.value + "\" " + "operation=\"" + this.operationToString() + "\" />";
        String closing = "";
        return this.toXML(opening, closing);
    }

    public String toXML(String openTag, String closeTag) {
        String xml = "";
        xml = xml + openTag;
        xml = xml + closeTag;
        return xml;
    }
}

