/*
 * Decompiled with CFR 0.152.
 */
package gamemaker.events;

import gamemaker.Coordinate;
import gamemaker.GameMaps;
import gamemaker.Panels.EventPanel;
import gamemaker.TeleportInput;
import gamemaker.TeleportLocation;
import gamemaker.events.GameEvent;
import java.awt.Point;

public class teleportEvent
extends GameEvent {
    private GameMaps maps;
    private TeleportLocation teleportLocation;

    public teleportEvent(EventPanel eventPanel, GameMaps maps) {
        super(eventPanel, "teleport");
        this.maps = maps;
        this.teleportLocation = new TeleportLocation(100, 100, -1);
    }

    public void setTeleportLocation(TeleportLocation t) {
        this.teleportLocation = t;
    }

    public void setTeleportLocation(int mapIndex, Point p) {
        this.teleportLocation = new TeleportLocation((int)p.getX(), (int)p.getY(), mapIndex);
    }

    public void setTeleportLocation(int mapIndex, Coordinate c) {
        this.setTeleportLocation(mapIndex, c.getPoint());
    }

    public TeleportLocation getTeleportLocation() {
        return this.teleportLocation;
    }

    public boolean eventAction() {
        if (this.isEventActionAbleToRun()) {
            if (this.teleportLocation.getMapIndex() != -1) {
                this.maps.setCurrentMap(this.teleportLocation.getMapIndex());
                this.maps.getSprite().setCurrentGameMap(this.maps.getCurrentMap());
                this.maps.getSprite().setCurrentMap(this.maps.getCurrentMapIndex());
                this.maps.getSprite().setSpritePosition(this.teleportLocation.getPoint());
                this.maps.getMapsContainer().setMaximumSize(this.maps.getCurrentMap().getBackgroundPanel().getSize());
                this.maps.getMapsContainer().repaint();
            } else {
                System.err.println("Problem teleporting to map");
            }
            return true;
        }
        return false;
    }

    public void configureEvent(boolean requireCondition) {
        if (this.createCondition(requireCondition)) {
            TeleportInput teleInput = new TeleportInput(this.maps);
            this.teleportLocation = teleInput.getInput();
            if (this.teleportLocation == null) {
                this.deleteMyself();
            }
            this.maps.repaint();
        } else {
            this.deleteMyself();
        }
    }

    public String toXML() {
        String opening = "<event type=\"" + this.getEventFuntion() + "\" " + "trigger=\"" + this.eventTriggerToString() + "\" " + "mapid=\"" + this.teleportLocation.getMapIndex() + "\" xaxis=\"" + this.teleportLocation.getX() + "\" yaxis=\"" + this.teleportLocation.getY() + "\">";
        String closing = "</event>";
        return this.toXML(opening, closing);
    }

    public String toXML(String openTag, String closeTag) {
        String xml = "";
        this.teleportLocation.getMapIndex();
        xml = xml + openTag + "\n";
        xml = xml + this.alwaysToXML();
        xml = xml + closeTag + "\n";
        return xml;
    }
}

