/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.xml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import org.basex.build.SingleParser;
import org.basex.build.xml.CatalogWrapper;
import org.basex.build.xml.SAXHandler;
import org.basex.core.MainOptions;
import org.basex.core.ProcException;
import org.basex.core.Text;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.IOUrl;
import org.basex.util.Util;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class SAXWrapper
extends SingleParser {
    private long counter;
    private int line = 1;
    private SAXHandler saxh;
    private final SAXSource saxs;
    private long length;

    public SAXWrapper(IO source, MainOptions opts) {
        super(source, opts);
        this.saxs = new SAXSource(source.inputSource());
    }

    @Override
    public void parse() throws IOException {
        InputSource is = this.wrap(this.saxs.getInputSource());
        String in = this.saxs.getSystemId() == null ? "..." : this.saxs.getSystemId();
        try {
            Object r = this.saxs.getXMLReader();
            if (r == null) {
                boolean dtd = this.options.get(MainOptions.DTD);
                SAXParserFactory f = SAXParserFactory.newInstance();
                f.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", dtd);
                f.setFeature("http://xml.org/sax/features/external-parameter-entities", dtd);
                f.setFeature("http://xml.org/sax/features/use-entity-resolver2", false);
                f.setNamespaceAware(true);
                f.setValidating(false);
                f.setXIncludeAware(true);
                r = f.newSAXParser().getXMLReader();
            }
            this.saxh = new SAXHandler(this.builder, this.options.get(MainOptions.CHOP), this.options.get(MainOptions.STRIPNS));
            String cat = this.options.get(MainOptions.CATFILE);
            if (!cat.isEmpty()) {
                CatalogWrapper.set((XMLReader)r, cat);
            }
            r.setDTDHandler(this.saxh);
            r.setContentHandler(this.saxh);
            r.setProperty("http://xml.org/sax/properties/lexical-handler", this.saxh);
            r.setErrorHandler(this.saxh);
            if (is != null) {
                r.parse(is);
            } else {
                r.parse(this.saxs.getSystemId());
            }
        }
        catch (SAXParseException ex) {
            String msg = Util.info(Text.SCANPOS_X_X, in, ex.getLineNumber(), ex.getColumnNumber()) + ": " + Util.message(ex);
            throw new IOException(msg, ex);
        }
        catch (ProcException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String msg = '\"' + in + '\"' + ": " + Util.message(ex);
            throw new IOException(msg, ex);
        }
        finally {
            if (is != null) {
                try {
                    InputStream ist;
                    Reader r = is.getCharacterStream();
                    if (r != null) {
                        r.close();
                    }
                    if ((ist = is.getByteStream()) != null) {
                        ist.close();
                    }
                }
                catch (IOException ex) {
                    Util.debug(ex);
                }
            }
        }
    }

    private InputSource wrap(InputSource is) throws IOException {
        InputStream in;
        if (is == null) {
            return null;
        }
        if (is.getByteStream() != null) {
            in = is.getByteStream();
        } else {
            if (is.getSystemId() == null || is.getSystemId().isEmpty()) {
                return is;
            }
            if (this.src instanceof IOFile) {
                in = new FileInputStream(this.src.path());
            } else if (this.src instanceof IOContent || this.src instanceof IOUrl) {
                in = new ByteArrayInputStream(this.src.read());
            } else {
                return is;
            }
        }
        this.length = this.src.length();
        try {
            if (this.length <= 0L) {
                this.length = in.available();
            }
        }
        catch (IOException ex) {
            in.close();
            throw ex;
        }
        InputSource tmp = new InputSource(new InputStream(){
            final InputStream buffer;
            {
                this.buffer = in instanceof ByteArrayInputStream ? in : new BufferedInputStream(in);
            }

            @Override
            public int read() throws IOException {
                int i = this.buffer.read();
                if (i == 10) {
                    ++SAXWrapper.this.line;
                }
                ++SAXWrapper.this.counter;
                return i;
            }

            @Override
            public void close() throws IOException {
                this.buffer.close();
            }
        });
        this.saxs.setInputSource(tmp);
        this.saxs.setSystemId(is.getSystemId());
        return tmp;
    }

    @Override
    public String det() {
        return this.length == 0L ? super.det() : Util.info(Text.SCANPOS_X_X, this.src.name(), this.line);
    }

    @Override
    public double prog() {
        return this.length == 0L ? (this.saxh == null ? 0.0 : (double)this.saxh.nodes / 3000000.0 % 1.0) : (double)this.counter / (double)this.length;
    }
}

