/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import org.basex.core.DBLocking;
import org.basex.core.Databases;
import org.basex.core.Datas;
import org.basex.core.Events;
import org.basex.core.GlobalOptions;
import org.basex.core.LockResult;
import org.basex.core.Locking;
import org.basex.core.MainOptions;
import org.basex.core.Perm;
import org.basex.core.Proc;
import org.basex.core.ProcLocking;
import org.basex.core.User;
import org.basex.core.Users;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.data.Nodes;
import org.basex.io.random.TableDiskAccess;
import org.basex.query.util.pkg.Repo;
import org.basex.server.ClientBlocker;
import org.basex.server.ClientListener;
import org.basex.server.Log;
import org.basex.server.Sessions;
import org.basex.util.Token;
import org.basex.util.list.StringList;

public final class Context {
    public final ClientListener listener;
    public final ClientBlocker blocker;
    public final MainOptions options = new MainOptions();
    public final GlobalOptions globalopts;
    public final Sessions sessions;
    public final Events events;
    public final Datas dbs;
    public final Users users;
    public final Repo repo;
    public final Databases databases;
    public User user;
    public final Log log;
    public Nodes marked;
    public Nodes copied;
    public int focused = -1;
    private Nodes current;
    private final Locking locks;
    private Data data;

    public Context() {
        this(true);
    }

    public Context(boolean file) {
        this(new GlobalOptions(file));
    }

    public Context(Context ctx, ClientListener cl) {
        this.listener = cl;
        this.globalopts = ctx.globalopts;
        this.dbs = ctx.dbs;
        this.events = ctx.events;
        this.sessions = ctx.sessions;
        this.databases = ctx.databases;
        this.blocker = ctx.blocker;
        this.locks = ctx.locks;
        this.users = ctx.users;
        this.repo = ctx.repo;
        this.log = ctx.log;
    }

    private Context(GlobalOptions gopts) {
        this.globalopts = gopts;
        this.dbs = new Datas();
        this.events = new Events();
        this.sessions = new Sessions();
        this.blocker = new ClientBlocker();
        this.databases = new Databases(this);
        this.locks = gopts.get(GlobalOptions.GLOBALLOCK) != false ? new ProcLocking(this) : new DBLocking(gopts);
        this.users = new Users(this);
        this.repo = new Repo(this);
        this.log = new Log(this);
        this.user = this.users.get("admin");
        this.listener = null;
    }

    public synchronized void close() {
        while (!this.sessions.isEmpty()) {
            ((ClientListener)this.sessions.get(0)).quit();
        }
        this.dbs.close();
        this.log.close();
    }

    public boolean root() {
        return this.data != null && this.current == null;
    }

    public Data data() {
        return this.data;
    }

    public Nodes current() {
        if (this.current != null || this.data == null) {
            return this.current;
        }
        Nodes n = new Nodes(this.data.resources.docs().toArray(), this.data);
        n.root = true;
        return n;
    }

    public void current(Nodes curr) {
        this.current = curr.checkRoot();
    }

    public void openDB(Data d) {
        this.data = d;
        this.copied = null;
        this.set(null, new Nodes(d));
    }

    public void closeDB() {
        this.data = null;
        this.copied = null;
        this.set(null, null);
    }

    public void set(Nodes curr, Nodes mark) {
        this.current = curr;
        this.marked = mark;
        this.focused = -1;
    }

    public void update() {
        this.current = null;
    }

    public boolean pinned(String db) {
        return this.dbs.pinned(db) || TableDiskAccess.locked(db, this);
    }

    public boolean perm(Perm p, MetaData md) {
        User us = md == null || p == Perm.CREATE || p == Perm.ADMIN ? null : md.users.get(this.user.name);
        return (us == null ? this.user : us).has(p);
    }

    public void register(Proc pr) {
        assert (!pr.registered()) : "Already registered:" + pr;
        pr.registered(true);
        if (!this.user.has(Perm.ADMIN)) {
            pr.startTimeout((long)this.globalopts.get(GlobalOptions.TIMEOUT).intValue() * 1000L);
        }
        LockResult lr = new LockResult();
        pr.databases(lr);
        StringList read = this.prepareLock(lr.read, lr.readAll);
        StringList write = this.prepareLock(lr.write, lr.writeAll);
        this.locks.acquire(pr, read, write);
    }

    public void unregister(Proc pr) {
        assert (pr.registered()) : "Not registered:" + pr;
        pr.registered(false);
        this.locks.release(pr);
        pr.stopTimeout();
    }

    private StringList prepareLock(StringList sl, boolean all) {
        if (all) {
            return null;
        }
        for (int d = 0; d < sl.size(); ++d) {
            if (!Token.eq(sl.get(d), "%CTX", "%COLL")) continue;
            if (this.data == null) {
                sl.deleteAt(d);
                continue;
            }
            sl.set(d, this.data.meta.name);
        }
        return sl.sort(true).unique();
    }
}

