/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.util.HashSet;
import java.util.regex.Pattern;
import org.basex.core.Context;
import org.basex.core.GlobalOptions;
import org.basex.io.IOFile;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.list.StringList;

public final class Databases {
    public static final String DBCHARS = "-+=~!#$%^&()[]{}@'`";
    public static final String REGEXCHARS = "-+=~!#$%^&()[]{}@'`".replaceAll("(.)", "\\\\$1");
    private static final Pattern ZIPPATTERN = Pattern.compile("-\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}\\.zip$");
    private static final Pattern REGEX = Pattern.compile(".*[*?,].*");
    private final GlobalOptions gopts;

    Databases(Context c) {
        this.gopts = c.globalopts;
    }

    public StringList list() {
        return this.list(true, true, null);
    }

    public StringList listDBs() {
        return this.list(true, false, null);
    }

    public StringList listDBs(String name) {
        return this.list(true, false, name);
    }

    private StringList list(boolean db, boolean backup, String name) {
        Pattern pt;
        if (name != null) {
            String nm = REGEX.matcher(name).matches() ? IOFile.regex(name) : name.replaceAll("([" + REGEXCHARS + "])", "\\\\$1");
            pt = Pattern.compile(nm, Prop.CASE ? 0 : 2);
        } else {
            pt = null;
        }
        IOFile[] children = this.gopts.dbpath().children();
        StringList list = new StringList(children.length);
        HashSet<String> map = new HashSet<String>(children.length);
        for (IOFile f : children) {
            String fn = f.name();
            String add = null;
            if (backup && fn.endsWith(".zip")) {
                String nn = ZIPPATTERN.split(fn)[0];
                if (!nn.equals(fn)) {
                    add = nn;
                }
            } else if (db && f.isDir() && fn.indexOf(46) == -1) {
                add = fn;
            }
            if (add == null || pt != null && !pt.matcher(add).matches() || !map.add(add)) continue;
            list.add(add);
        }
        return list.sort(false);
    }

    public StringList backups() {
        StringList backups = new StringList();
        for (IOFile f : this.gopts.dbpath().children()) {
            String n = f.name();
            if (!n.endsWith(".zip")) continue;
            backups.add(n.substring(0, n.lastIndexOf(46)));
        }
        return backups;
    }

    public StringList backups(String db) {
        StringList backups = new StringList();
        IOFile file = this.gopts.dbpath(db + ".zip");
        if (file.exists()) {
            backups.add(db);
        } else {
            String regex = db.replaceAll("([" + REGEXCHARS + "])", "\\\\$1") + "-\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}" + ".zip";
            for (IOFile f : this.gopts.dbpath().children()) {
                String n = f.name();
                if (!n.matches(regex)) continue;
                backups.add(n.substring(0, n.lastIndexOf(46)));
            }
        }
        return backups.sort(Prop.CASE, false);
    }

    public static String name(String backup) {
        return Pattern.compile("-\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}$").split(backup)[0];
    }

    public static boolean validChar(int ch) {
        return Token.letterOrDigit(ch) || DBCHARS.indexOf(ch) != -1;
    }

    public static boolean validName(String name) {
        return Databases.validName(name, false);
    }

    public static boolean validName(String name, boolean glob) {
        if (name == null) {
            return false;
        }
        int nl = name.length();
        for (int n = 0; n < nl; ++n) {
            char ch = name.charAt(n);
            if (glob && (ch == '?' || ch == '*' || ch == ',') || Databases.validChar(ch)) continue;
            return false;
        }
        return nl != 0;
    }
}

