/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.Databases;
import org.basex.core.Text;
import org.basex.core.cmd.AUser;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.util.Util;

public final class CreateUser
extends AUser {
    public CreateUser(String name, String pw) {
        super(name, pw);
    }

    @Override
    protected boolean run() {
        try {
            CreateUser.create(this.args[0], this.args[1], this.context);
            return this.info(Text.USER_CREATED_X, this.args[0]);
        }
        catch (BaseXException ex) {
            return this.error(Util.message(ex), new Object[0]);
        }
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.CREATE) + " " + (Object)((Object)Commands.CmdCreate.USER)).args();
    }

    private static void create(String user, String pass, Context ctx) throws BaseXException {
        if (!Databases.validName(user)) {
            throw new BaseXException(Text.NAME_INVALID_X, user);
        }
        if (!CreateUser.isMD5(pass)) {
            throw new BaseXException(Text.PW_NOT_VALID, new Object[0]);
        }
        if (!ctx.users.create(user, pass)) {
            throw new BaseXException(Text.USER_EXISTS_X, user);
        }
    }
}

