/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.data.Data;
import org.basex.index.IndexType;

public final class DropIndex
extends ACreate {
    public DropIndex(Object type) {
        super(Perm.WRITE, true, type.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean run() {
        IndexType it;
        Data data = this.context.data();
        if (data.inMemory()) {
            return this.error(Text.NO_MAINMEM, new Object[0]);
        }
        Commands.CmdIndex ci = this.getOption(Commands.CmdIndex.class);
        if (ci == null) {
            return this.error(Text.UNKNOWN_CMD_X, this);
        }
        switch (ci) {
            case TEXT: {
                data.meta.createtext = false;
                it = IndexType.TEXT;
                break;
            }
            case ATTRIBUTE: {
                data.meta.createattr = false;
                it = IndexType.ATTRIBUTE;
                break;
            }
            case FULLTEXT: {
                data.meta.createftxt = false;
                it = IndexType.FULLTEXT;
                break;
            }
            default: {
                return this.error(Text.UNKNOWN_CMD_X, this);
            }
        }
        if (!data.startUpdate()) {
            return this.error(Text.DB_PINNED_X, data.meta.name);
        }
        try {
            boolean bl = DropIndex.drop(it, this.context.data()) ? this.info(Text.INDEX_DROPPED_X_X, new Object[]{it, this.perf}) : this.error(Text.INDEX_NOT_DROPPED_X, new Object[]{it});
            return bl;
        }
        finally {
            data.finishUpdate();
        }
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.DROP) + " " + (Object)((Object)Commands.CmdDrop.INDEX)).args();
    }
}

