/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.index.IndexType;
import org.basex.util.Util;
import org.basex.util.list.IntList;

public final class Optimize
extends ACreate {
    private int pre;
    private int size;

    public Optimize() {
        super(Perm.WRITE, true, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean run() {
        Data data = this.context.data();
        MetaData m = data.meta;
        this.size = m.size;
        if (!data.startUpdate()) {
            return this.error(Text.DB_PINNED_X, data.meta.name);
        }
        try {
            Optimize.optimize(data, this);
            boolean bl = this.info(Text.DB_OPTIMIZED_X, m.name, this.perf);
            return bl;
        }
        catch (IOException ex) {
            boolean bl = this.error(Util.message(ex), new Object[0]);
            return bl;
        }
        finally {
            data.finishUpdate();
        }
    }

    @Override
    public double prog() {
        return (double)this.pre / (double)this.size;
    }

    @Override
    public boolean stoppable() {
        return false;
    }

    @Override
    public String det() {
        return Text.CREATE_STATS_D;
    }

    public static void optimize(Data data, Optimize cmd) throws IOException {
        Optimize.optimize(data, false, false, cmd);
    }

    public static void optimize(Data data, boolean rebuild, boolean rebuildFT, Optimize cmd) throws IOException {
        MetaData md = data.meta;
        if (!md.uptodate) {
            data.paths.init();
            data.resources.init();
            data.tagindex.init();
            data.atnindex.init();
            md.dirty = true;
            IntList pars = new IntList();
            IntList tags = new IntList();
            int n = 0;
            for (int pre = 0; pre < md.size; ++pre) {
                byte kind = (byte)data.kind(pre);
                int par = data.parent(pre, kind);
                while (!pars.isEmpty() && pars.peek() > par) {
                    pars.pop();
                    tags.pop();
                }
                int level = pars.size();
                if (kind == 0) {
                    data.paths.put(0, (byte)0, level);
                    pars.push(pre);
                    tags.push(0);
                    ++n;
                } else if (kind == 1) {
                    int id = data.name(pre);
                    data.tagindex.index(data.tagindex.key(id), null, true);
                    data.paths.put(id, (byte)1, level);
                    pars.push(pre);
                    tags.push(id);
                } else if (kind == 3) {
                    int id = data.name(pre);
                    byte[] val = data.text(pre, false);
                    data.atnindex.index(data.atnindex.key(id), val, true);
                    data.paths.put(id, (byte)3, level, val, md);
                } else {
                    byte[] val = data.text(pre, true);
                    if (kind == 2 && level > 1) {
                        data.tagindex.index(tags.peek(), val);
                    }
                    data.paths.put(0, kind, level, val, md);
                }
                if (cmd == null) continue;
                cmd.pre = pre;
            }
            md.ndocs = n;
            md.uptodate = true;
        }
        Optimize.optimize(IndexType.ATTRIBUTE, data, md.createattr, md.attrindex, rebuild, cmd);
        Optimize.optimize(IndexType.TEXT, data, md.createtext, md.textindex, rebuild, cmd);
        Optimize.optimize(IndexType.FULLTEXT, data, md.createftxt, md.ftxtindex, rebuild || rebuildFT, cmd);
    }

    private static void optimize(IndexType type, Data d, boolean create, boolean old, boolean rebuild, Optimize cmd) throws IOException {
        if (!rebuild && create == old) {
            return;
        }
        if (create) {
            Optimize.create(type, d, cmd);
        } else {
            Optimize.drop(type, d);
        }
    }
}

