/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Command;
import org.basex.core.Databases;
import org.basex.core.LockResult;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Open;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.data.Data;
import org.basex.util.Util;

public final class ShowUsers
extends Command {
    public ShowUsers() {
        this(null);
    }

    public ShowUsers(String db) {
        super(Perm.ADMIN, db);
    }

    @Override
    protected boolean run() throws IOException {
        String name;
        String string = name = this.args[0] == null || this.args[0].isEmpty() ? null : this.args[0];
        if (name != null && !Databases.validName(name)) {
            return this.error(Text.NAME_INVALID_X, name);
        }
        if (name != null) {
            try {
                Data data = Open.open(name, this.context);
                this.out.println(data.meta.users.info(this.context.users).finish());
                Close.close(data, this.context);
                return true;
            }
            catch (IOException ex) {
                return this.error(Util.message(ex), new Object[0]);
            }
        }
        this.out.println(this.context.users.info(null).finish());
        return true;
    }

    @Override
    public void databases(LockResult lr) {
        lr.read.add("%ADMIN");
        if (this.args[0] != null) {
            this.databases(lr.read, 0);
        }
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.SHOW) + " " + (Object)((Object)Commands.CmdShow.USERS)).arg("ON", 0);
    }
}

