/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.LockResult;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.io.IOFile;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.XMLSerializer;
import org.basex.query.util.unit.Suite;
import org.basex.util.Util;

public final class Test
extends Command {
    public Test(String path) {
        super(Perm.ADMIN, false, path);
    }

    @Override
    protected boolean run() {
        IOFile root = new IOFile(this.args[0]);
        if (!root.exists()) {
            return this.error(Text.RES_NOT_FOUND_X, this.context.user.has(Perm.CREATE) ? root : this.args[0]);
        }
        try {
            XMLSerializer ser = Serializer.get(this.out);
            Suite suite = new Suite();
            ser.serialize(suite.test(root, this.context));
            this.out.print(Text.NL);
            this.out.flush();
            StringBuilder sb = new StringBuilder(Text.RESULT).append(": ");
            this.add(sb, "test", suite.tests);
            this.add(sb, "failure", suite.failures);
            this.add(sb, "error", suite.errors);
            sb.append(suite.skipped).append(' ').append("skipped.");
            return suite.errors + suite.failures == 0 ? this.info(sb.toString(), new Object[0]) : this.error(sb.toString(), new Object[0]);
        }
        catch (IOException ex) {
            this.cause = ex;
            return this.error(Util.message(ex), new Object[0]);
        }
    }

    private void add(StringBuilder sb, String string, int number) {
        sb.append(number).append(' ').append(string);
        if (number != 1) {
            sb.append('s');
        }
        sb.append(", ");
    }

    @Override
    public boolean updating(Context ctx) {
        return true;
    }

    @Override
    public void databases(LockResult lr) {
        lr.writeAll = true;
    }
}

