/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUICommand;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXImages;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;

public class BaseXButton
extends JButton {
    private static final AbstractButton TEMPLATE = BaseXButton.style(new JToggleButton());

    public BaseXButton(String label, Window win) {
        super(label);
        BaseXLayout.addInteraction(this, win);
        if (!(win instanceof BaseXDialog)) {
            return;
        }
        final BaseXDialog d = (BaseXDialog)win;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = BaseXButton.this.getText();
                if (text.equals(Text.CANCEL)) {
                    d.cancel();
                } else if (text.equals(Text.B_OK)) {
                    d.close();
                } else {
                    d.action(e.getSource());
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (BaseXKeys.ESCAPE.is(e)) {
                    d.cancel();
                } else if (BaseXKeys.NEXTCHAR.is(e) || BaseXKeys.NEXTLINE.is(e)) {
                    BaseXButton.this.transferFocus();
                } else if (BaseXKeys.PREVCHAR.is(e) || BaseXKeys.PREVLINE.is(e)) {
                    BaseXButton.this.transferFocusBackward();
                }
            }
        });
        BaseXLayout.setMnemonic(this, d.mnem);
    }

    public static AbstractButton get(String icon, String tooltip, boolean toggle, Window gui) {
        AbstractButton button = toggle ? new JToggleButton() : new JButton();
        BaseXButton.init(button, icon, tooltip, gui);
        if (!toggle) {
            button.setBorder(TEMPLATE.getBorder());
            button.setMargin(TEMPLATE.getMargin());
        }
        return button;
    }

    private static void init(AbstractButton button, String icon, String tooltip, Window gui) {
        button.setIcon(BaseXImages.icon(icon));
        BaseXLayout.addInteraction(button, gui);
        if (tooltip != null) {
            button.setToolTipText(tooltip);
        }
        BaseXButton.style(button);
    }

    private static AbstractButton style(AbstractButton button) {
        button.setOpaque(false);
        Insets in = button.getMargin();
        in.left /= 4;
        in.right /= 4;
        if (in.top < in.left) {
            button.setMargin(in);
        }
        return button;
    }

    public static AbstractButton command(final GUICommand cmd, final GUI gui) {
        String name = cmd.toString().toLowerCase(Locale.ENGLISH);
        AbstractButton button = BaseXButton.get(name, cmd.shortcut(), cmd.toggle(), gui);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cmd.execute(gui);
            }
        });
        return button;
    }

    @Override
    public void setEnabled(boolean flag) {
        if (flag != this.isEnabled()) {
            super.setEnabled(flag);
        }
    }
}

