/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;
import org.basex.util.Performance;

public final class BaseXScrollBar
extends BaseXPanel {
    public static final int SIZE = 16;
    private static final int MAXSTEP = 15;
    private static final int[] STEPS = new int[]{-15, -14, -11, -8, -6, -4, -3, -2, -1, -1, 0, 0, 1, 1, 2, 3, 4, 6, 8, 11, 14, 15};
    private static final int MINSIZE = 20;
    private final BaseXPanel comp;
    private final int ww;
    private int step = STEPS.length / 2;
    private boolean animated;
    private int hh;
    private int barPos;
    private int barSize;
    private int dragPos;
    private boolean button;
    private boolean down;
    private boolean sliding;
    private boolean moving;
    private int pos;
    private int height;
    private boolean up;
    private int barOffset;

    public BaseXScrollBar(BaseXPanel cmp) {
        super(cmp.gui);
        this.comp = cmp;
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addMouseMotionListener(this);
        this.mode(GUIConstants.Fill.NONE);
        BaseXLayout.setWidth(this, 16);
        this.ww = 16;
    }

    public void pos(int p) {
        int pp = Math.max(0, Math.min(this.height - this.getHeight(), p));
        if (this.pos == pp) {
            return;
        }
        this.pos = pp;
        this.repaint();
    }

    public int pos() {
        return this.pos;
    }

    public void height(int h) {
        if (this.height != h) {
            this.height = h;
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        this.hh = this.getHeight();
        super.paintComponent(g);
        if (this.hh >= this.height) {
            return;
        }
        int barH = this.hh - this.ww * 2 + 4;
        float factor = (float)(barH - this.barOffset) / (float)this.height;
        int size = (int)((float)this.hh * factor);
        this.barOffset = size < 20 ? 20 - size : 0;
        this.barSize = Math.min(size += this.barOffset, barH - 1);
        this.barPos = (int)Math.max(0.0f, Math.min((float)this.pos * factor, (float)(barH - this.barSize)));
        g.setColor(GUIConstants.LGRAY);
        g.fillRect(0, 0, this.ww, this.hh);
        int bh = this.ww - 2 + this.barPos;
        BaseXLayout.drawCell(g, 0, this.ww, bh, bh + this.barSize, false);
        g.setColor(GUIConstants.DGRAY);
        g.drawLine(5, bh += this.barSize >> 1, this.ww - 6, bh);
        g.drawLine(5, bh - 2, this.ww - 6, bh - 2);
        g.drawLine(5, bh + 2, this.ww - 6, bh + 2);
        BaseXScrollBar.smooth(g);
        this.drawButton(g, new int[][]{{0, 6, 3}, {6, 6, 0}}, 0, this.button && this.up);
        this.drawButton(g, new int[][]{{0, 6, 3}, {0, 0, 6}}, Math.max(16, this.hh - this.ww), this.button && this.down);
        g.setColor(GUIConstants.GRAY);
        g.drawLine(0, 0, 0, this.hh);
        g.drawLine(this.ww - 1, 0, this.ww - 1, this.hh);
    }

    private void drawButton(Graphics g, int[][] pol, int y, boolean focus) {
        BaseXLayout.drawCell(g, 0, this.ww, y, y + this.ww, focus);
        int i = 0;
        while (i < pol[0].length) {
            int[] nArray = pol[0];
            int n = i;
            nArray[n] = nArray[n] + 5;
            int[] nArray2 = pol[1];
            int n2 = i++;
            nArray2[n2] = nArray2[n2] + (y + 8 - 3);
        }
        g.setColor(focus ? Color.black : GUIConstants.DGRAY);
        g.fillPolygon(pol[0], pol[1], 3);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        final int y = e.getY();
        this.sliding = y > this.ww + this.barPos && y < this.ww + this.barPos + this.barSize;
        this.moving = !this.sliding;
        this.up = y < this.ww + this.barPos;
        this.down = y > this.ww + this.barPos + this.barSize;
        boolean bl = this.button = y < this.ww || y > this.hh - this.ww;
        if (this.sliding) {
            this.dragPos = this.barPos - y;
        }
        if (this.sliding || this.animated) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                BaseXScrollBar.this.animated = BaseXScrollBar.this.moving;
                while (BaseXScrollBar.this.animated) {
                    if (BaseXScrollBar.this.moving) {
                        BaseXScrollBar.this.step = Math.max(0, Math.min(STEPS.length - 1, BaseXScrollBar.this.step + (BaseXScrollBar.this.down ? 1 : -1)));
                    } else {
                        BaseXScrollBar.this.step += BaseXScrollBar.this.step < STEPS.length / 2 ? 1 : -1;
                    }
                    int offset = STEPS[BaseXScrollBar.this.step];
                    if (!BaseXScrollBar.this.button) {
                        offset = offset * BaseXScrollBar.this.hh / 15 / 4;
                    }
                    BaseXScrollBar.this.pos = Math.max(0, Math.min(BaseXScrollBar.this.height - BaseXScrollBar.this.hh, BaseXScrollBar.this.pos + offset));
                    BaseXScrollBar.this.comp.repaint();
                    Performance.sleep(25L);
                    BaseXScrollBar.this.animated = BaseXScrollBar.this.step != STEPS.length / 2;
                    if (y <= BaseXScrollBar.this.ww + BaseXScrollBar.this.barPos || y >= BaseXScrollBar.this.ww + BaseXScrollBar.this.barPos + BaseXScrollBar.this.barSize) continue;
                    BaseXScrollBar.this.dragPos = BaseXScrollBar.this.barPos - y;
                    BaseXScrollBar.this.animated = false;
                    BaseXScrollBar.this.sliding = true;
                    BaseXScrollBar.this.step = STEPS.length / 2;
                }
            }
        }.start();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.up = false;
        this.down = false;
        this.moving = false;
        this.sliding = false;
        this.comp.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.sliding) {
            return;
        }
        this.pos = (int)((long)(e.getY() + this.dragPos) * (long)this.height / (long)(this.hh - this.ww * 2));
        this.pos = Math.max(0, Math.min(this.height - this.hh, this.pos));
        this.comp.repaint();
    }
}

