/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.text;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.text.ReplaceContext;
import org.basex.gui.text.SearchContext;
import org.basex.gui.text.TextPanel;
import org.basex.util.options.BooleanOption;

public final class SearchBar
extends BaseXBack {
    private final KeyAdapter escape = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (BaseXKeys.ESCAPE.is(e)) {
                SearchBar.this.deactivate(true);
            }
        }
    };
    final AbstractButton regex;
    final AbstractButton mcase;
    final AbstractButton word;
    final AbstractButton multi;
    private final AbstractButton rplc;
    private final AbstractButton cls;
    private final GUI gui;
    private final BaseXTextField search;
    private final BaseXTextField replace;
    private AbstractButton button;
    private TextPanel editor;

    SearchBar(final GUI main) {
        this.layout(new BorderLayout(2, 0));
        this.mode(GUIConstants.Fill.NONE);
        this.setVisible(false);
        this.gui = main;
        this.search = new BaseXTextField(main);
        this.search.history(GUIOptions.SEARCHED, this.gui);
        this.search.setPreferredSize(null);
        this.search.hint(Text.FIND + "...");
        this.replace = new BaseXTextField(main);
        this.replace.history(GUIOptions.REPLACED, this.gui);
        this.replace.setPreferredSize(null);
        this.replace.hint(Text.REPLACE_WITH + "...");
        this.regex = this.onOffButton("f_regex", Text.REGULAR_EXPR, GUIOptions.SR_REGEX);
        this.mcase = this.onOffButton("f_case", Text.MATCH_CASE, GUIOptions.SR_CASE);
        this.word = this.onOffButton("f_word", Text.WHOLE_WORD, GUIOptions.SR_WORD);
        this.multi = this.onOffButton("f_multi", Text.MULTI_LINE, GUIOptions.SR_MULTI);
        this.rplc = BaseXButton.get("f_replace", Text.REPLACE_ALL, false, main);
        this.cls = BaseXButton.get("f_close", BaseXLayout.addShortcut(Text.CLOSE, BaseXKeys.ESCAPE.toString()), false, main);
        this.multi.setEnabled(this.regex.isSelected());
        this.word.setEnabled(!this.regex.isSelected());
        this.search.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (BaseXKeys.FINDPREV1.is(e) || BaseXKeys.FINDPREV2.is(e) || BaseXKeys.FINDNEXT1.is(e) || BaseXKeys.FINDNEXT2.is(e)) {
                    ((SearchBar)SearchBar.this).editor.editor.noSelect();
                    SearchBar.this.deactivate(false);
                } else if (BaseXKeys.ESCAPE.is(e)) {
                    SearchBar.this.deactivate(SearchBar.this.search.getText().isEmpty());
                } else if (BaseXKeys.ENTER.is(e)) {
                    SearchBar.this.editor.jump(e.isShiftDown() ? TextPanel.SearchDir.BACKWARD : TextPanel.SearchDir.FORWARD, true);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                main.gopts.set(GUIOptions.SR_SEARCH, SearchBar.this.search.getText());
                SearchBar.this.search();
            }
        });
        BaseXLayout.addDrop(this.search, new BaseXLayout.DropHandler(){

            @Override
            public void drop(Object object) {
                SearchBar.this.search.setText(object.toString());
                SearchBar.this.search();
            }
        });
        this.replace.addKeyListener(this.escape);
        this.replace.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                main.gopts.set(GUIOptions.SR_REPLACE, SearchBar.this.replace.getText());
            }
        });
        this.cls.addKeyListener(this.escape);
        this.cls.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.deactivate(true);
            }
        });
        this.rplc.addKeyListener(this.escape);
        this.rplc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.search.store();
                SearchBar.this.replace.store();
                String in = SearchBar.this.replace.getText();
                SearchBar.this.editor.replace(new ReplaceContext(SearchBar.this.regex.isSelected() ? SearchBar.decode(in) : in));
                SearchBar.this.deactivate(true);
            }
        });
    }

    public void editor(TextPanel e, boolean srch) {
        boolean ed = e.isEditable();
        if (this.editor == null || ed != this.editor.isEditable()) {
            this.removeAll();
            BaseXBack wst = new BaseXBack(GUIConstants.Fill.NONE).layout(new TableLayout(1, 4, 1, 0));
            wst.add(this.mcase);
            wst.add(this.word);
            wst.add(this.regex);
            wst.add(this.multi);
            BaseXBack ctr = new BaseXBack(GUIConstants.Fill.NONE).layout(new GridLayout(1, 2, 2, 0));
            ctr.add(this.search);
            if (ed) {
                ctr.add(this.replace);
            }
            BaseXBack est = new BaseXBack(GUIConstants.Fill.NONE).layout(new TableLayout(1, 3, 1, 0));
            if (ed) {
                est.add(this.rplc);
            }
            est.add(this.cls);
            this.add((Component)wst, "West");
            this.add((Component)ctr, "Center");
            this.add((Component)est, "East");
        }
        this.editor = e;
        this.refreshLayout();
        e.setSearch(this);
        if (srch) {
            this.search(false);
        }
    }

    public AbstractButton button(String help) {
        this.button = BaseXButton.get("c_find", BaseXLayout.addShortcut(help, BaseXKeys.FIND.toString()), true, this.gui);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SearchBar.this.isVisible()) {
                    SearchBar.this.deactivate(true);
                } else {
                    SearchBar.this.activate(null, true);
                }
            }
        });
        return this.button;
    }

    public void refreshLayout() {
        if (this.editor == null) {
            return;
        }
        Font ef = this.editor.getFont().deriveFont(7.0f + (float)(GUIConstants.fontSize >> 1));
        this.search.setFont(ef);
        this.replace.setFont(ef);
    }

    public void reset() {
        this.regex.setSelected(false);
        this.mcase.setSelected(false);
        this.word.setSelected(false);
        this.multi.setSelected(false);
    }

    public void activate(String string, boolean focus) {
        boolean action;
        boolean bl = action = !this.isVisible();
        if (action) {
            this.setVisible(true);
            if (this.button != null) {
                this.button.setSelected(true);
            }
        }
        if (focus) {
            this.search.requestFocusInWindow();
        }
        if (string != null && !new SearchContext(this, this.search.getText()).matches(string)) {
            this.search.setText(string);
            this.search.store();
            this.regex.setSelected(false);
            action = true;
        }
        if (action) {
            this.search();
        }
    }

    public boolean deactivate(boolean close) {
        this.search.store();
        this.editor.requestFocusInWindow();
        if (!close || !this.isVisible()) {
            return false;
        }
        this.setVisible(false);
        if (this.button != null) {
            this.button.setSelected(false);
        }
        this.search();
        return true;
    }

    private void search() {
        this.search(true);
    }

    private void search(boolean jump) {
        String text = this.isVisible() ? this.search.getText() : "";
        this.editor.search(new SearchContext(this, text), jump);
    }

    void refresh(SearchContext sc) {
        boolean nohits = sc.nr == 0;
        boolean empty = sc.search.isEmpty();
        this.rplc.setEnabled(!nohits && !empty);
        this.search.setBackground(nohits && !empty ? GUIConstants.LRED : Color.white);
    }

    private AbstractButton onOffButton(String icon, String tooltip, final BooleanOption option) {
        final AbstractButton b = BaseXButton.get(icon, tooltip, true, this.gui);
        b.setSelected(this.gui.gopts.get(option));
        b.addKeyListener(this.escape);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean sel = b.isSelected();
                ((SearchBar)SearchBar.this).gui.gopts.set(option, sel);
                if (b == SearchBar.this.regex) {
                    SearchBar.this.multi.setEnabled(sel);
                    SearchBar.this.word.setEnabled(!sel);
                }
                SearchBar.this.search();
            }
        });
        return b;
    }

    private static String decode(String in) {
        StringBuilder sb = new StringBuilder();
        boolean bs = false;
        for (int i = 0; i < in.length(); ++i) {
            char ch = in.charAt(i);
            if (bs) {
                if (ch == 'n') {
                    sb.append('\n');
                } else if (ch == 't') {
                    sb.append('\t');
                } else {
                    sb.append('\\');
                    if (ch != '\\') {
                        sb.append(ch);
                    }
                }
                bs = false;
                continue;
            }
            if (ch == '\\') {
                bs = true;
                continue;
            }
            sb.append(ch);
        }
        if (bs) {
            sb.append('\\');
        }
        return sb.toString();
    }
}

