/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.text;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.gui.text.SearchBar;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.IntList;

final class SearchContext {
    final SearchBar bar;
    final boolean mcase;
    final boolean regex;
    final boolean multi;
    final boolean word;
    final String search;
    int nr;

    SearchContext(SearchBar sb, String text) {
        String s;
        this.bar = sb;
        this.mcase = sb.mcase.isSelected();
        this.word = sb.word.isSelected();
        this.regex = sb.regex.isSelected();
        this.multi = sb.multi.isSelected();
        String string = s = this.mcase ? text : text.toLowerCase(Locale.ENGLISH);
        if (this.regex && (s.startsWith(".*") || s.startsWith("(.*") || s.startsWith(".+") || s.startsWith("(.+"))) {
            s = '^' + s;
        }
        this.search = s;
    }

    IntList[] search(byte[] txt) {
        IntList start = new IntList();
        IntList end = new IntList();
        if (!this.search.isEmpty()) {
            if (this.regex) {
                this.searchRegEx(start, end, txt);
            } else {
                this.searchSimple(start, end, txt);
            }
        }
        this.nr = start.size();
        this.bar.refresh(this);
        return new IntList[]{start, end};
    }

    private void searchRegEx(IntList start, IntList end, byte[] text) {
        int flags = 32;
        if (!this.mcase) {
            flags |= 2;
        }
        Pattern pattern = Pattern.compile(this.search, flags);
        if (this.multi) {
            int c = 0;
            int p = 0;
            Matcher m = pattern.matcher(Token.string(text));
            while (m.find()) {
                int s = m.start();
                int e = m.end();
                while (c < s) {
                    p += Token.cl(text, p);
                    ++c;
                }
                start.add(p);
                while (c < e) {
                    p += Token.cl(text, p);
                    ++c;
                }
                end.add(p);
            }
        } else {
            int os = text.length;
            TokenBuilder tb = new TokenBuilder(os);
            int t = 0;
            for (int o = 0; o <= os; ++o) {
                if (!(o < os ? text[o] == 10 : o != t)) continue;
                int c = 0;
                int p = t;
                Matcher m = pattern.matcher(Token.string(text, t, o - t));
                while (m.find()) {
                    int s = m.start();
                    int e = m.end();
                    while (c < s) {
                        p += Token.cl(text, p);
                        ++c;
                    }
                    start.add(p);
                    while (c < e) {
                        p += Token.cl(text, p);
                        ++c;
                    }
                    end.add(p);
                }
                if (o < os) {
                    tb.add(10);
                }
                t = o + 1;
            }
        }
    }

    private void searchSimple(IntList start, IntList end, byte[] text) {
        byte[] srch = Token.token(this.search);
        int ss = srch.length;
        int os = text.length;
        boolean s = true;
        int o = 0;
        while (o < os) {
            int sp;
            if (o + ss <= os && s) {
                if (this.mcase) {
                    for (sp = 0; sp < ss && text[o + sp] == srch[sp]; ++sp) {
                    }
                } else {
                    while (sp < ss && Token.lc(Token.cp(text, o + sp)) == Token.cp(srch, sp)) {
                        sp += Token.cl(srch, sp);
                    }
                }
            }
            if (!(sp != ss || this.word && o + ss != os && Character.isLetterOrDigit(Token.cp(text, o + ss)))) {
                start.add(o);
                end.add(o + ss);
                o += ss;
                s = !this.word;
                continue;
            }
            if (this.word) {
                s = !Character.isLetterOrDigit(Token.cp(text, o));
                o += Token.cl(text, o);
                continue;
            }
            ++o;
        }
    }

    boolean matches(String string) {
        if (string.isEmpty() || string.contains("\n")) {
            return true;
        }
        if (this.regex) {
            try {
                int flags = 32;
                if (!this.mcase) {
                    flags |= 2;
                }
                Pattern pattern = Pattern.compile(this.search, flags);
                return pattern.matcher(string).matches();
            }
            catch (Exception ex) {
                return false;
            }
        }
        return this.mcase ? this.search.equals(string) : this.search.equalsIgnoreCase(string);
    }

    int nr() {
        return this.nr;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SearchContext)) {
            return false;
        }
        SearchContext s = (SearchContext)obj;
        return this.mcase == s.mcase && this.word == s.word && this.regex == s.regex && this.multi == s.multi && Token.eq(this.search, s.search);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

