/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view;

import org.basex.data.Data;
import org.basex.data.DataText;
import org.basex.gui.GUIOptions;
import org.basex.query.func.Function;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.IntList;

public final class ViewData {
    private ViewData() {
    }

    public static boolean leaf(GUIOptions opts, Data d, int pre) {
        int kind = d.kind(pre);
        if (kind == 3) {
            return true;
        }
        boolean atts = opts.get(GUIOptions.MAPATTS);
        int last = pre + (atts ? 1 : d.attSize(pre, kind));
        return last == d.meta.size || d.parent(pre, kind) >= d.parent(last, d.kind(last));
    }

    public static byte[] path(Data data, int pre) {
        if (data == null || pre >= data.meta.size) {
            return Token.EMPTY;
        }
        int p = pre;
        int k = data.kind(p);
        IntList il = new IntList();
        while (k != 0) {
            il.add(p);
            p = data.parent(p, k);
            k = data.kind(p);
        }
        byte[] doc = ViewData.content(data, p, true);
        TokenBuilder tb = new TokenBuilder();
        tb.add(Function._DB_OPEN.args(data.meta.name, Token.string(doc)));
        for (int i = il.size() - 1; i >= 0; --i) {
            tb.add(47);
            tb.add(ViewData.content(data, il.get(i), true));
        }
        return tb.finish();
    }

    public static byte[] content(Data data, int p, boolean s) {
        int k = data.kind(p);
        switch (k) {
            case 1: {
                return data.name(p, k);
            }
            case 0: {
                return data.text(p, true);
            }
            case 2: {
                return s ? DataText.TEXT : data.text(p, true);
            }
            case 4: {
                return s ? DataText.COMMENT : data.text(p, true);
            }
            case 5: {
                return s ? DataText.PI : data.text(p, true);
            }
        }
        TokenBuilder tb = new TokenBuilder();
        tb.add(DataText.ATT);
        tb.add(data.name(p, k));
        if (!s) {
            tb.add(DataText.ATT1);
            tb.add(data.text(p, false));
            tb.add(DataText.ATT2);
        }
        return tb.finish();
    }

    public static byte[] name(GUIOptions opts, Data data, int pre) {
        byte[] att;
        int id;
        if (data.kind(pre) == 1 && (id = ViewData.nameID(data)) != 0 && opts.get(GUIOptions.SHOWNAME).booleanValue() && (att = data.attValue(id, pre)) != null) {
            return att;
        }
        return ViewData.content(data, pre, true);
    }

    public static int nameID(Data data) {
        return data.atnindex.id(DataText.T_NAME);
    }

    public static int sizeID(Data data) {
        return data.atnindex.id(DataText.T_SIZE);
    }

    public static int parent(Data data, int pre) {
        return data.parent(pre, data.kind(pre));
    }

    public static int size(Data data, int pre) {
        return data.size(pre, data.kind(pre));
    }
}

