/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.map;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Arrays;
import org.basex.data.FTPos;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.view.map.MapRect;
import org.basex.util.Token;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTSpan;
import org.basex.util.list.BoolList;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

final class MapRenderer {
    private static BoolList ttcol;
    private static int ul;

    private MapRenderer() {
    }

    static int calcHeight(Graphics g, MapRect r, byte[] s, int fs) {
        return MapRenderer.drawText(g, r, s, false, fs);
    }

    static void drawText(Graphics g, MapRect r, byte[] s, int fs) {
        MapRenderer.drawText(g, r, s, true, fs);
    }

    private static int drawText(Graphics g, MapRect r, byte[] s, boolean draw, int fs) {
        int[] cw = GUIConstants.fontWidths(g.getFont());
        int fh = (int)(1.2 * (double)fs);
        Color textc = g.getColor();
        int xx = r.x;
        int yy = r.y + fh;
        int ww = r.w;
        int ll = 0;
        FTLexer lex = new FTLexer().sc().init(s);
        while (lex.hasNext()) {
            FTSpan span = lex.next();
            byte[] tok = span.text;
            int wl = 0;
            for (int n = 0; n < tok.length; n += Token.cl(tok, n)) {
                wl += BaseXLayout.width(g, cw, Token.cp(tok, n));
            }
            if (ll + wl >= ww) {
                xx = r.x;
                if (ll != 0) {
                    yy += fh;
                }
                if (yy + fh > r.y + r.h) {
                    if (draw) {
                        g.drawString("...", xx + ll, yy);
                    }
                    return r.h;
                }
                ll = 0;
                if (draw && wl >= ww) {
                    int l;
                    int n;
                    int twl = 2 * BaseXLayout.width(g, cw, 46);
                    if (twl >= ww) {
                        return Integer.MAX_VALUE;
                    }
                    for (n = 0; n < tok.length && twl + (l = BaseXLayout.width(g, cw, Token.cp(tok, n))) < ww; n += Token.cl(tok, n)) {
                        twl += l;
                    }
                    tok = Arrays.copyOf(tok, n + 2);
                    tok[n] = 46;
                    tok[n + 1] = 46;
                }
            }
            if (draw) {
                g.setColor(r.pos != null && r.pos.contains(span.pos) && !span.special ? GUIConstants.GREEN : textc);
                g.drawString(Token.string(tok), xx + ll, yy);
            }
            ll += wl;
            if (!lex.paragraph()) continue;
            ll = 0;
            if ((yy += fh) + fh <= r.y + r.h) continue;
            if (draw) {
                g.drawString("...", xx + ll, yy);
            }
            return r.h;
        }
        return yy - r.y;
    }

    static void drawThumbnails(Graphics g, MapRect r, byte[] s, int fs) {
        double fnew;
        double ffmax = 0.25;
        double ffhmax = 0.5;
        double flhmax = 0.3;
        double ff = 0.25;
        double ffh = 0.5;
        double flh = 0.3;
        byte lhmi = (byte)Math.max(3.0, ffh * (double)fs);
        byte fhmi = (byte)Math.max(6.0, (flh + ffh) * (double)fs);
        int h = r.h;
        r.thumbf = ff * (double)fs;
        r.thumbal = 0;
        int[][] data = new FTLexer().init(s).info();
        boolean l = false;
        double flhmin = 0.168;
        double ffhmin = 0.28;
        double ffmin = 0.14;
        double flhtmin = 0.168;
        double ffhtmax = 0.5;
        double ffhtmin = 0.28;
        double fftmax = 0.25;
        double fftmin = 0.14;
        double bflh = 0.3;
        double bffh = 0.5;
        double bff = 0.25;
        double flhtmax = 0.3;
        while (r.thumbal < 2) {
            ff = MapRenderer.round(fftmax, fftmin);
            r.thumbf = ff * (double)fs;
            ffh = MapRenderer.round(ffhtmax, ffhtmin);
            r.thumbfh = (byte)Math.max(1.0, ffh * (double)fs);
            flh = MapRenderer.round(flhtmax, flhtmin);
            r.thumblh = (byte)Math.max(1.0, (flh + ffh) * (double)fs);
            r.thumbsw = r.thumbf;
            switch (r.thumbal) {
                case 0: {
                    h = MapRenderer.drawToken(g, r, data, false);
                    break;
                }
                case 1: 
                case 2: {
                    h = MapRenderer.drawSentence(g, r, data, false, r.h);
                }
            }
            if (h >= r.h || MapRenderer.le(0.25, ff) || MapRenderer.le(0.5, ffh) || MapRenderer.le(0.3, flh)) {
                if (l) {
                    r.thumbf = bff * (double)fs;
                    r.thumbfh = (byte)Math.max(1.0, bffh * (double)fs);
                    r.thumblh = (byte)Math.max(1.0, (bflh + bffh) * (double)fs);
                    r.thumbsw = r.thumbf;
                    switch (r.thumbal) {
                        case 0: {
                            MapRenderer.drawToken(g, r, data, true);
                            return;
                        }
                        case 1: 
                        case 2: {
                            MapRenderer.drawSentence(g, r, data, true, r.h);
                            return;
                        }
                    }
                }
                if (MapRenderer.le(ff, 0.14) || MapRenderer.le(ffh, 0.28) || MapRenderer.le(flh, 0.168)) {
                    r.thumbal = (byte)(r.thumbal + 1);
                    fhmi = r.thumbfh;
                    lhmi = r.thumblh;
                    fftmin = 0.14;
                    fftmax = 0.25;
                    ffhtmin = 0.28;
                    ffhtmax = 0.5;
                    flhtmin = 0.168;
                    flhtmax = 0.3;
                    continue;
                }
                fftmax = ff;
                ffhtmax = ffh;
                flhtmax = flh;
                continue;
            }
            l = true;
            bff = ff;
            bffh = ffh;
            bflh = flh;
            fftmin = ff;
            ffhtmin = ffh;
            flhtmin = flh;
        }
        double sum = data[3].length + data[4].length;
        double nl = ((double)r.h - 3.0) / (double)lhmi;
        r.thumbf = fnew = (nl * (double)(r.w - 3) - (double)data[4].length) / sum;
        r.thumbfh = fhmi;
        r.thumblh = lhmi;
        r.thumbsw = Math.max(1.0, fnew);
        MapRenderer.drawSentence(g, r, data, true, r.h);
    }

    private static boolean le(double a, double b) {
        return a < b || a / b < 1.05;
    }

    private static double round(double a, double b) {
        double v = (a + b) / 2.0;
        double d = v * 100000.0;
        int i = (int)d;
        double r = d - (double)i >= 0.5 ? (double)(i + 1) : (double)i;
        return r / 100000.0;
    }

    private static int drawSentence(Graphics g, MapRect r, int[][] data, boolean draw, int mh) {
        boolean sen = r.thumbal == 1;
        FTPos ftp = r.pos;
        int xx = r.x;
        int ww = r.w;
        int yy = r.y + 3;
        Color textc = GUIConstants.color(r.level + 4);
        g.setColor(textc);
        int count = -1;
        int pp = 0;
        int sl = 0;
        int pl = 0;
        int psl = 0;
        int ppl = 0;
        double error = 0.0;
        int i = 0;
        int ll = 0;
        while (i < data[0].length) {
            g.setColor(textc);
            int ct = 0;
            int wl = 0;
            while (i < data[0].length && ppl < data[2].length && data[2][ppl] > pl && (psl < data[1].length && data[1][psl] > sl || psl >= data[1].length)) {
                sl += data[0][i];
                pl += data[0][i];
                int lastl = (int)((double)data[0][i] * r.thumbf);
                if ((error += (double)data[0][i] * r.thumbf - (double)lastl) >= 1.0) {
                    wl += (int)error;
                    error -= (double)((int)error);
                }
                wl += lastl;
                if (ftp != null && ftp.contains(count)) {
                    ++ct;
                    ++pp;
                }
                ++count;
                if (i >= data[0].length) break;
                ++i;
            }
            if (ct == 0) {
                while (ll + wl >= ww) {
                    if (draw) {
                        g.fillRect(xx + ll, yy, ww - ll, r.thumbfh);
                    }
                    wl -= ww - ll;
                    ll = 0;
                    if ((yy += r.thumblh) + r.thumblh < r.y + mh) continue;
                    return r.h;
                }
                if (draw) {
                    g.fillRect(xx + ll, yy, wl, r.thumbfh);
                }
                ll += wl;
            } else {
                int wltmp = wl / ct;
                for (int cttmp = 0; cttmp < ct; ++cttmp) {
                    if (pp - ct + cttmp < ftp.size()) {
                        g.setColor(GUIConstants.GREEN);
                    }
                    while (ll + wltmp >= ww) {
                        if (draw) {
                            g.fillRect(xx + ll, yy, ww - ll, r.thumbfh);
                        }
                        wltmp -= ww - ll;
                        ll = 0;
                        if ((yy += r.thumblh) + r.thumblh < r.y + mh) continue;
                        return r.h;
                    }
                    if (draw) {
                        g.fillRect(xx + ll, yy, wltmp, r.thumbfh);
                    }
                    ll += wltmp;
                    wltmp = wl / ct + (cttmp == ct - 2 ? wl - wl / ct * ct : 0);
                }
            }
            if (psl < data[1].length && data[1][psl] == sl) {
                if ((double)ll + r.thumbsw >= (double)ww) {
                    ll = 0;
                    if ((yy += r.thumblh) + r.thumblh >= r.y + mh) {
                        return r.h;
                    }
                }
                if (draw) {
                    g.setColor(Color.black);
                    g.fillRect(xx + ll, yy, (int)r.thumbsw, r.thumbfh);
                    g.setColor(textc);
                }
                ll = (int)((double)ll + r.thumbsw);
                sl = 0;
                ++psl;
            }
            if (ppl >= data[2].length || data[2][ppl] != pl) continue;
            pl = 0;
            ++ppl;
            if (!sen) continue;
            ll = 0;
            if ((yy += r.thumblh) + r.thumblh < r.y + mh) continue;
            return r.h;
        }
        return yy - r.y + r.thumbfh;
    }

    private static int drawToken(Graphics g, MapRect r, int[][] data, boolean draw) {
        double xx = r.x;
        double ww = r.w;
        FTPos ftp = r.pos;
        int yy = r.y + 3;
        double ll = 0.0;
        double e = 0.0;
        Color textc = GUIConstants.color(r.level + 4);
        int count = 0;
        int sl = 0;
        int pl = 0;
        int psl = 0;
        int ppl = 0;
        for (int i = 0; i < data[0].length; ++i) {
            int wl = (int)((double)data[0][i] * r.thumbf);
            if ((e += (double)data[0][i] * r.thumbf - (double)wl) >= 1.0) {
                wl += (int)e;
                e -= (double)((int)e);
            }
            pl += data[0][i];
            double d = ll + (double)wl;
            double d2 = r.thumbsw;
            boolean bl = psl < data[1].length && (sl += data[0][i]) == data[1][psl];
            if (d + d2 * (double)bl >= ww) {
                yy += r.thumblh;
                ll = 0.0;
                if ((double)wl >= ww) {
                    return r.h + 3;
                }
            }
            if (draw) {
                g.setColor(ftp != null && ftp.contains(count) ? GUIConstants.GREEN : textc);
                g.fillRect((int)(xx + ll), yy, wl, r.thumbfh);
            }
            ll += (double)wl;
            ++count;
            if (psl < data[1].length && sl == data[1][psl]) {
                if (draw) {
                    g.setColor(Color.black);
                    g.fillRect((int)(xx + ll), yy, (int)r.thumbsw, r.thumbfh);
                    g.setColor(textc);
                }
                ll += r.thumbsw;
                ++psl;
                sl = 0;
            }
            ll += r.thumbf;
            if (ppl >= data[2].length || pl != data[2][ppl]) continue;
            yy += r.thumblh;
            ll = 0.0;
            ++ppl;
            pl = 0;
        }
        return yy - r.y + 3;
    }

    private static boolean inRect(double rx, int ry, double rw, int rh, int xx, int yy) {
        return (double)xx >= rx && (double)xx <= rx + rw && yy >= ry && yy <= ry + rh;
    }

    static TokenList calculateToolTip(MapRect r, int[][] data, int x, int y, int w, Graphics g) {
        if (r.thumbf == 0.0) {
            return null;
        }
        boolean sen = r.thumbal < 2;
        boolean ds = r.thumbal < 1;
        FTPos ftp = r.pos;
        int ww = r.w;
        int yy = r.y + 3;
        ul = -1;
        TokenList tl = new TokenList();
        ttcol = new BoolList();
        int cc = 0;
        int sl = 0;
        int pl = 0;
        int ppl = 0;
        int psl = 0;
        double error = 0.0;
        double ll = 0.0;
        for (int i = 0; i < data[0].length; ++i) {
            double wl = (double)data[0][i] * r.thumbf;
            if ((error += (double)data[0][i] * r.thumbf - wl) >= 1.0) {
                wl += error;
                error -= (double)((int)error);
            }
            pl += data[0][i];
            cc += data[0][i];
            boolean ir = false;
            double d = ds && psl < data[1].length && data[1][psl] == (sl += data[0][i]) ? r.thumbsw : 0.0;
            if (ll + wl + d >= (double)ww) {
                if (ds) {
                    ir = MapRenderer.inRect(r.x, yy += r.thumblh, wl, r.thumbfh, x, y);
                    ll = wl + (psl < data[1].length && data[1][psl] == sl ? r.thumbsw : r.thumbf);
                } else {
                    ir = MapRenderer.inRect(r.x, yy += r.thumblh, wl -= (double)ww - ll, r.thumbfh, x, y);
                    ll = wl + (psl < data[1].length && data[1][psl] == sl ? r.thumbsw : r.thumbf);
                }
            } else {
                ir |= MapRenderer.inRect((double)r.x + ll, yy, wl, r.thumbfh, x, y);
                ll += wl + (ds ? r.thumbf : 0.0);
            }
            if (ir) {
                int l;
                byte[] tok;
                boolean apm;
                int p;
                int si = i;
                int[] cw = GUIConstants.fontWidths(g.getFont());
                int sp = BaseXLayout.width(g, cw, 32);
                int sd = BaseXLayout.width(g, cw, 46);
                int bpsl = data[1][psl] == sl ? psl + 1 : psl;
                int bsl = data[1][psl] == sl ? 0 : sl;
                ll = sd * 2 + sp;
                int n = p = cc >= data[0][i] ? cc - data[0][i] : 0;
                while (p > -1 && i > -1) {
                    apm = psl < data[1].length && data[1][psl] == sl;
                    tok = new byte[data[0][i] + (apm ? 1 : 0)];
                    for (int k = 0; k < tok.length - (apm ? 1 : 0); ++k) {
                        tok[k] = (byte)data[3][p + k];
                    }
                    if (apm) {
                        tok[tok.length - 1] = (byte)data[4][psl];
                        ++sl;
                    }
                    if ((sl -= tok.length) == 0) {
                        if (--psl == -1) {
                            psl = data[1].length;
                        } else {
                            sl = data[1][psl];
                        }
                    }
                    l = 0;
                    for (int n2 = 0; n2 < tok.length; n2 += Token.cl(tok, n2)) {
                        l += BaseXLayout.width(g, cw, Token.cp(tok, n2));
                    }
                    if (si > i && ll + (double)l + (double)sp >= (double)w / 2.0) break;
                    ll += (double)(l + sp);
                    tl.add(tok);
                    ttcol.add(ftp != null && ftp.contains(i));
                    if (i == 0) break;
                    p -= data[0][i - 1];
                    --i;
                }
                if (i > 0) {
                    tl.add(new byte[]{46, 46});
                    ttcol.add(false);
                }
                i = si + 1;
                p = cc;
                ul = tl.size() - 1;
                byte[][] toks = tl.toArray();
                boolean[] tc = ttcol.toArray();
                tl.reset();
                ttcol.reset();
                for (int j = toks.length - 1; j >= 0; --j) {
                    tl.add(toks[j]);
                    ttcol.add(tc[j]);
                }
                ll = 0.0;
                sl = bsl;
                psl = bpsl;
                while (p < data[3].length && i < data[0].length) {
                    apm = false;
                    if (psl < data[1].length && data[1][psl] == sl + data[0][i]) {
                        apm = true;
                        sl = 0;
                        ++psl;
                    }
                    tok = new byte[data[0][i] + (apm ? 1 : 0)];
                    l = 0;
                    for (int k = 0; k < tok.length - (apm ? 1 : 0); ++k) {
                        tok[k] = (byte)data[3][p + k];
                    }
                    if (apm) {
                        tok[tok.length - 1] = (byte)data[4][psl - 1];
                    }
                    sl += apm ? sl : tok.length;
                    for (int n3 = 0; n3 < tok.length; n3 += Token.cl(tok, n3)) {
                        l += BaseXLayout.width(g, cw, Token.cp(tok, n3));
                    }
                    if (ll + (double)l + (double)sp + (double)(2 * sd) >= (double)w / 2.0) break;
                    ll += (double)(l + sp);
                    tl.add(tok);
                    ttcol.add(ftp != null && ftp.contains(i));
                    p += tok.length - (apm ? 1 : 0);
                    ++i;
                }
                if (i < data[0].length) {
                    tl.add(new byte[]{46, 46});
                    ttcol.add(false);
                }
                return tl;
            }
            if (ds && psl < data[1].length && data[1][psl] == sl) {
                if (ll + r.thumbsw >= (double)ww) {
                    yy += r.thumblh;
                    ll -= (double)ww;
                }
                ll += r.thumbsw;
                sl = 0;
                ++psl;
            }
            if (ppl >= data[2].length || data[2][ppl] != pl) continue;
            pl = 0;
            ++ppl;
            if (!sen) continue;
            yy += r.thumblh;
            ll = 0.0;
        }
        return tl;
    }

    static void drawToolTip(Graphics g, int x, int y, MapRect mr, TokenList tl, int fs) {
        int xx;
        if (tl == null || tl.isEmpty()) {
            return;
        }
        int[] cw = GUIConstants.fontWidths(g.getFont());
        int sw = BaseXLayout.width(g, cw, 32);
        int wl = 0;
        int nl = 1;
        int wi = mr.w / 2;
        IntList len = new IntList();
        for (int i = 0; i < tl.size(); ++i) {
            int l = 0;
            byte[] tok = tl.get(i);
            int ns = tok.length;
            for (int n = 0; n < ns; n += Token.cl(tok, n)) {
                l += BaseXLayout.width(g, cw, Token.cp(tok, n));
            }
            if (wl + l + sw < wi) {
                wl += l + sw;
            } else {
                ++nl;
                if (l > wi) {
                    wi = l;
                }
                wl = l + sw;
            }
            len.add(l);
        }
        int ww = nl == 1 && wl < wi ? wl : wi;
        int n = xx = x + 10 + ww >= mr.x + mr.w ? mr.x + mr.w - ww - 2 : x + 10;
        int yy = y + 28 + fs * nl + 4 < mr.y + mr.h ? y + 28 : (y - mr.y - 4 > fs * nl ? y - fs * nl : mr.y + mr.h - 4 - fs * nl);
        g.setColor(GUIConstants.color(10));
        g.drawRect(xx - 3, yy - fs - 1, ww + 3, fs * nl + 7);
        g.setColor(GUIConstants.color(0));
        g.fillRect(xx - 2, yy - fs, ww + 2, fs * nl + 6);
        g.setColor(GUIConstants.color(20));
        wl = 0;
        int is = tl.size();
        for (int i = 0; i < is; ++i) {
            boolean pm;
            int l = len.get(i);
            if (wl + l + sw >= wi) {
                yy += fs + 1;
                wl = 0;
            }
            boolean bl = pm = !Token.ftChar(tl.get(i)[tl.get(i).length - 1]);
            if (ttcol.get(i)) {
                g.setColor(GUIConstants.GREEN);
            }
            g.drawString(Token.string(tl.get(i)), xx + wl, yy);
            if (i == ul) {
                g.drawLine(xx + wl, yy + 1, xx + wl + (pm ? l - sw : l), yy + 1);
            }
            g.setColor(GUIConstants.color(24));
            wl += l + sw;
        }
    }
}

