/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.map;

import org.basex.gui.view.map.MapAlgo;
import org.basex.gui.view.map.MapList;
import org.basex.gui.view.map.MapRect;
import org.basex.gui.view.map.MapRects;

final class SliceDiceAlgo
extends MapAlgo {
    SliceDiceAlgo() {
    }

    @Override
    MapRects calcMap(MapRect r, MapList ml, int ns, int ne) {
        double xx = r.x;
        double yy = r.y;
        double ww = 0.0;
        double hh = 0.0;
        int tx = -1;
        int ty = -1;
        int th = -1;
        int tw = -1;
        MapRects rects = new MapRects();
        int is = ml.size();
        for (int i = 0; i < is; ++i) {
            if ((r.level & 1) == 0) {
                yy += hh;
                hh = ml.weight[i] * (double)r.h;
                ww = r.w;
            } else {
                xx += ww;
                ww = ml.weight[i] * (double)r.w;
                hh = r.h;
            }
            if (ww > 0.0 && hh > 0.0 && (tx != (int)xx || ty != (int)yy || th != (int)hh || tw != (int)ww)) {
                rects.add(new MapRect((int)xx, (int)yy, (int)ww, (int)hh, ml.get(i), r.level));
            }
            tx = (int)xx;
            ty = (int)yy;
            th = (int)hh;
            tw = (int)ww;
        }
        return rects;
    }
}

