/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.ft;

import org.basex.index.ft.FTIndexTree;

final class FTIndexTrees {
    private final FTIndexTree[] trees;
    private int ctree;

    FTIndexTrees(int size) {
        this.trees = new FTIndexTree[size + 1];
    }

    void index(byte[] tok, int pre, int pos, int cf) {
        int tl = tok.length;
        if (this.trees[tl] == null) {
            this.trees[tl] = new FTIndexTree();
        }
        this.trees[tl].index(tok, pre, pos, cf);
    }

    void initFT() {
        for (FTIndexTree tree : this.trees) {
            if (tree == null) continue;
            tree.initFT();
        }
    }

    void init() {
        for (FTIndexTree tree : this.trees) {
            if (tree == null) continue;
            tree.init();
        }
        this.ctree = -1;
    }

    boolean more(int cf) {
        if (this.ctree != -1 && this.trees[this.ctree].more(cf)) {
            return true;
        }
        while (++this.ctree < this.trees.length) {
            if (this.trees[this.ctree] == null) continue;
            return this.more(cf);
        }
        return false;
    }

    FTIndexTree nextTree() {
        return this.trees[this.ctree];
    }
}

