/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.in;

import java.io.IOException;
import java.io.InputStream;
import org.basex.io.IO;
import org.basex.io.in.ArrayInput;
import org.basex.io.in.NewlineInput;
import org.basex.util.Array;
import org.basex.util.Token;

public class XMLInput
extends InputStream {
    private NewlineInput[] inputs = new NewlineInput[1];
    private int ip;
    private int line = 1;
    private final int[] last = new int[16];
    private int lp;
    private int pp;

    public XMLInput(IO io) throws IOException {
        this.inputs[0] = new NewlineInput(io);
    }

    public void encoding(String e) throws IOException {
        this.inputs[0].encoding(e);
    }

    public IO io() {
        return this.inputs[0].io();
    }

    public void prev(int p) {
        this.pp -= p;
    }

    @Override
    public int read() throws IOException {
        if (this.pp != 0) {
            return this.last[this.lp + this.pp++ & 0xF];
        }
        int ch = this.inputs[this.ip].read();
        while (ch == -1 && this.ip != 0) {
            ch = this.inputs[--this.ip].read();
        }
        this.last[this.lp++] = ch;
        this.lp &= 0xF;
        if (this.ip == 0 && ch == 10) {
            ++this.line;
        }
        return ch;
    }

    public boolean add(byte[] val, boolean s) throws IOException {
        if (s) {
            this.add(new NewlineInput(new ArrayInput(Token.SPACE)));
        }
        this.add(new NewlineInput(new ArrayInput(val)));
        if (s) {
            this.add(new NewlineInput(new ArrayInput(Token.SPACE)));
        }
        return this.ip < 32;
    }

    private void add(NewlineInput ti) {
        if (++this.ip == this.inputs.length) {
            this.inputs = Array.copy(this.inputs, new NewlineInput[Array.newSize(this.ip)]);
        }
        this.inputs[this.ip] = ti;
    }

    @Override
    public void close() throws IOException {
        this.inputs[0].close();
    }

    public int pos() {
        return Math.max(this.ip, this.inputs[this.ip].size() + this.pp);
    }

    public int line() {
        return this.line;
    }

    public long length() {
        return this.inputs[0].length();
    }
}

