/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.csv;

import org.basex.build.CsvOptions;
import org.basex.build.CsvParserOptions;
import org.basex.io.parse.XmlTokenBuilder;
import org.basex.io.parse.csv.CsvConverter;
import org.basex.query.value.item.Str;
import org.basex.util.Token;
import org.basex.util.XMLToken;
import org.basex.util.list.TokenList;

public final class CsvStringConverter
extends CsvConverter {
    private static final byte[] CSV = Token.token("csv");
    private static final byte[] RECORD = Token.token("record");
    private static final byte[] ENTRY = Token.token("entry");
    private static final byte[] NAME = Token.token("name");
    private final TokenList headers = new TokenList();
    private final boolean atts;
    private final boolean lax;
    private final XmlTokenBuilder xml = new XmlTokenBuilder();
    private boolean record;
    private int col;

    public CsvStringConverter(CsvParserOptions opts) {
        super(opts);
        this.lax = opts.get(CsvOptions.LAX);
        this.atts = opts.get(CsvOptions.FORMAT) == CsvOptions.CsvFormat.ATTRIBUTES;
        this.xml.openElement(CSV, new byte[0][]);
    }

    @Override
    public void record() {
        if (this.record) {
            this.xml.closeElement(RECORD);
        }
        this.xml.openElement(RECORD, new byte[0][]);
        this.record = true;
        this.col = 0;
    }

    @Override
    public void header(byte[] value) {
        this.headers.add(this.atts ? value : XMLToken.encode(value, this.lax));
    }

    @Override
    public void entry(byte[] entry) {
        byte[] name = this.headers.get(this.col++);
        byte[] elem = ENTRY;
        byte[] attr = null;
        if (this.atts) {
            attr = name;
        } else if (name != null) {
            elem = name;
        }
        this.xml.openElement(elem, NAME, attr);
        this.xml.addText(entry);
        this.xml.closeElement(elem);
    }

    @Override
    public Str finish() {
        if (this.record) {
            this.xml.closeElement(RECORD);
        }
        this.xml.closeElement(CSV);
        return Str.get(this.xml.array());
    }
}

