/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import org.basex.build.JsonOptions;
import org.basex.build.JsonParserOptions;
import org.basex.io.parse.json.JsonConverter;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.InputParser;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

final class JsonParser
extends InputParser {
    private static final String[] CTRL = new String[]{"NUL", "SOH", "STX", "ETX", "EOT", "ENQ", "ACK", "BEL", "BS", "TAB", "LF", "VT", "FF", "CR", "SO", "SI", "DLE", "DC1", "DC2", "DC3", "DC4", "NAK", "SYN", "ETB", "CAN", "EM", "SUB", "ESC", "FS", "GS", "RS", "US"};
    private final JsonConverter conv;
    private final JsonOptions.JsonSpec spec;
    private final boolean unescape;
    private final TokenBuilder tb = new TokenBuilder();

    private JsonParser(String in, JsonParserOptions opts, JsonConverter cnv) {
        super(in);
        this.spec = opts.get(JsonOptions.SPEC);
        this.unescape = opts.get(JsonParserOptions.UNESCAPE);
        this.conv = cnv;
    }

    static void parse(String input, String path, JsonParserOptions opts, JsonConverter conv) throws QueryIOException {
        JsonParser parser = new JsonParser(input, opts, conv);
        parser.file = path;
        parser.parse();
    }

    private void parse() throws QueryIOException {
        this.skipWs();
        if (this.spec == JsonOptions.JsonSpec.RFC4627 && this.curr() != '{' && this.curr() != '[') {
            throw this.error("Expected '{' or '[', found %", this.rest());
        }
        this.value();
        if (this.more()) {
            throw this.error("Unexpected trailing content: %", this.rest());
        }
    }

    private void value() throws QueryIOException {
        if (this.pos >= this.length) {
            throw this.eof(", expected JSON value.");
        }
        switch (this.curr()) {
            case '[': {
                this.array();
                break;
            }
            case '{': {
                this.object();
                break;
            }
            case '\"': {
                this.conv.stringLit(this.string());
                break;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.conv.numberLit(this.number());
                break;
            }
            default: {
                if (this.consume("true")) {
                    this.conv.booleanLit(Token.TRUE);
                } else if (this.consume("false")) {
                    this.conv.booleanLit(Token.FALSE);
                } else if (this.consume("null")) {
                    this.conv.nullLit();
                } else if (this.spec == JsonOptions.JsonSpec.LIBERAL && this.consume("new") && Character.isWhitespace(this.curr())) {
                    this.constr();
                } else {
                    throw this.error("Unexpected JSON value: '%'", this.rest());
                }
                this.skipWs();
            }
        }
    }

    private void object() throws QueryIOException {
        this.consumeWs('{', true);
        this.conv.openObject();
        if (!this.consumeWs('}', false)) {
            do {
                this.conv.openPair(this.spec != JsonOptions.JsonSpec.LIBERAL || this.curr() == '\"' ? this.string() : this.unquoted());
                this.consumeWs(':', true);
                this.value();
                this.conv.closePair();
            } while (this.consumeWs(',', false) && (this.spec != JsonOptions.JsonSpec.LIBERAL || this.curr() != '}'));
            this.consumeWs('}', true);
        }
        this.conv.closeObject();
    }

    private void array() throws QueryIOException {
        this.consumeWs('[', true);
        this.conv.openArray();
        if (!this.consumeWs(']', false)) {
            do {
                this.conv.openItem();
                this.value();
                this.conv.closeItem();
            } while (this.consumeWs(',', false) && (this.spec != JsonOptions.JsonSpec.LIBERAL || this.curr() != ']'));
            this.consumeWs(']', true);
        }
        this.conv.closeArray();
    }

    private void constr() throws QueryIOException {
        this.skipWs();
        if (!this.input.substring(this.pos).matches("^[a-zA-Z0-9_-]+\\(.*")) {
            throw this.error("Wrong constructor syntax: '%'", this.rest());
        }
        int p = this.input.indexOf(40, this.pos);
        this.conv.openConstr(Token.token(this.input.substring(this.pos, p)));
        this.pos = p + 1;
        this.skipWs();
        if (!this.consumeWs(')', false)) {
            do {
                this.conv.openArg();
                this.value();
                this.conv.closeArg();
            } while (this.consumeWs(',', false));
            this.consumeWs(')', true);
        }
        this.conv.closeConstr();
    }

    private byte[] unquoted() throws QueryIOException {
        int cp;
        int n = cp = this.more() ? this.input.codePointAt(this.pos) : -1;
        if (cp < 0 || !Character.isJavaIdentifierStart(cp)) {
            throw this.error("Expected unquoted string, found %", this.rest());
        }
        this.tb.reset();
        do {
            this.tb.add(cp);
        } while (Character.isJavaIdentifierPart(cp = this.input.codePointAt(this.pos += cp < 65536 ? 1 : 2)));
        this.skipWs();
        return this.tb.finish();
    }

    private byte[] number() throws QueryIOException {
        this.tb.reset();
        char ch = this.consume();
        this.tb.addByte((byte)ch);
        if (ch == '-') {
            ch = this.consume();
            if (ch < '0' || ch > '9') {
                throw this.error("Number expected after '-'", new Object[0]);
            }
            this.tb.addByte((byte)ch);
        }
        boolean zero = ch == '0';
        ch = this.curr();
        if (zero && ch >= '0' && ch <= '9') {
            throw this.error("No digit allowed after '0'", new Object[0]);
        }
        block4: while (true) {
            switch (ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.tb.addByte((byte)ch);
                    ++this.pos;
                    ch = this.curr();
                    continue block4;
                }
                case '.': 
                case 'E': 
                case 'e': {
                    break block4;
                }
                default: {
                    this.skipWs();
                    return this.tb.finish();
                }
            }
            break;
        }
        if (this.consume(46)) {
            this.tb.addByte((byte)46);
            ch = this.curr();
            if (ch < '0' || ch > '9') {
                throw this.error("Number expected after '.'", new Object[0]);
            }
            do {
                this.tb.addByte((byte)ch);
                ++this.pos;
            } while ((ch = this.curr()) >= '0' && ch <= '9');
            if (ch != 'e' && ch != 'E') {
                this.skipWs();
                return this.tb.finish();
            }
        }
        this.tb.addByte((byte)this.consume());
        ch = this.curr();
        if (ch == '-' || ch == '+') {
            this.tb.addByte((byte)this.consume());
            ch = this.curr();
        }
        if (ch < '0' || ch > '9') {
            throw this.error("Exponent expected", new Object[0]);
        }
        do {
            this.tb.addByte((byte)this.consume());
        } while ((ch = this.curr()) >= '0' && ch <= '9');
        this.skipWs();
        return this.tb.finish();
    }

    private byte[] string() throws QueryIOException {
        if (!this.consume(34)) {
            throw this.error("Expected string, found '%'", Character.valueOf(this.curr()));
        }
        this.tb.reset();
        int hi = 0;
        while (this.pos < this.length) {
            int ch;
            block31: {
                block30: {
                    ch = this.consume();
                    if (ch == 34) {
                        if (hi != 0) {
                            this.tb.add(hi);
                        }
                        this.skipWs();
                        return this.tb.finish();
                    }
                    if (ch != 92) break block30;
                    if (!this.unescape) {
                        if (hi != 0) {
                            this.tb.add(hi);
                            hi = 0;
                        }
                        this.tb.addByte((byte)92);
                    }
                    int n = this.consume();
                    switch (n) {
                        case 34: 
                        case 47: 
                        case 92: {
                            ch = n;
                            break;
                        }
                        case 98: {
                            ch = this.unescape ? 8 : 98;
                            break;
                        }
                        case 102: {
                            ch = this.unescape ? 12 : 102;
                            break;
                        }
                        case 116: {
                            ch = this.unescape ? 9 : 116;
                            break;
                        }
                        case 114: {
                            ch = this.unescape ? 13 : 114;
                            break;
                        }
                        case 110: {
                            ch = this.unescape ? 10 : 110;
                            break;
                        }
                        case 117: {
                            char x;
                            int i;
                            if (this.pos + 4 >= this.length) {
                                throw this.eof(", expected four-digit hex value");
                            }
                            if (this.unescape) {
                                ch = 0;
                                for (i = 0; i < 4; ++i) {
                                    x = this.consume();
                                    if (x >= '0' && x <= '9') {
                                        ch = 16 * ch + x - 48;
                                        continue;
                                    }
                                    if (x >= 'a' && x <= 'f') {
                                        ch = 16 * ch + x + 10 - 97;
                                        continue;
                                    }
                                    if (x >= 'A' && x <= 'F') {
                                        ch = 16 * ch + x + 10 - 65;
                                        continue;
                                    }
                                    throw this.error("Illegal hexadecimal digit: '%'", Character.valueOf(x));
                                }
                            } else {
                                this.tb.addByte((byte)117);
                                for (i = 0; i < 4; ++i) {
                                    x = this.consume();
                                    if (x >= '0' && x <= '9' || x >= 'a' && x <= 'f' || x >= 'A' && x <= 'F') {
                                        if (i < 3) {
                                            this.tb.addByte((byte)x);
                                            continue;
                                        }
                                        ch = x;
                                        continue;
                                    }
                                    throw this.error("Illegal hexadecimal digit: '%'", Character.valueOf(x));
                                }
                            }
                            break block31;
                        }
                        default: {
                            throw this.error("Unknown character escape: '\\%'", n);
                        }
                    }
                    break block31;
                }
                if (this.spec != JsonOptions.JsonSpec.LIBERAL && ch <= 31) {
                    throw this.error("Non-escaped control character: '\\%'", CTRL[ch]);
                }
            }
            if (hi != 0) {
                if (ch >= 56320 && ch <= 57343) {
                    ch = (hi - 55296 << 10) + ch - 56320 + 65536;
                } else {
                    this.tb.add(hi);
                }
                hi = 0;
            }
            if (ch >= 55296 && ch <= 56319) {
                hi = (char)ch;
                continue;
            }
            this.tb.add(ch);
        }
        throw this.eof(" in string literal");
    }

    private void skipWs() {
        block3: while (this.pos < this.length) {
            switch (this.input.charAt(this.pos)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\u00a0': {
                    ++this.pos;
                    continue block3;
                }
            }
            return;
        }
    }

    private boolean consumeWs(char ch, boolean err) throws QueryIOException {
        if (this.consume() != ch) {
            --this.pos;
            if (err) {
                throw this.error("Expected '%', found '%'", Character.valueOf(ch), Character.valueOf(this.curr()));
            }
            return false;
        }
        this.skipWs();
        return true;
    }

    private QueryIOException eof(String desc) throws QueryIOException {
        throw this.error("Unexpected end of input%", desc);
    }

    private QueryIOException error(String msg, Object ... ext) throws QueryIOException {
        InputInfo info = new InputInfo(this);
        QueryException qe = Err.BXJS_PARSE.get(info, info.line(), info.column(), Util.inf(msg, ext));
        throw new QueryIOException(qe);
    }
}

