/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.random;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.basex.io.IOFile;
import org.basex.io.random.Buffer;
import org.basex.io.random.Buffers;
import org.basex.util.Util;

public final class DataAccess {
    private final Buffers bm = new Buffers();
    private final RandomAccessFile file;
    private long len;
    private boolean changed;
    private int off;

    public DataAccess(IOFile fl) throws IOException {
        RandomAccessFile f = null;
        try {
            f = new RandomAccessFile(fl.file(), "rw");
            this.len = f.length();
        }
        catch (IOException ex) {
            if (f != null) {
                f.close();
            }
            throw ex;
        }
        this.file = f;
        this.cursor(0L);
    }

    public synchronized void flush() {
        try {
            for (Buffer b : this.bm.all()) {
                if (!b.dirty) continue;
                this.writeBlock(b);
            }
            if (this.changed) {
                this.file.setLength(this.len);
                this.changed = false;
            }
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }

    public synchronized void close() {
        this.flush();
        try {
            this.file.close();
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }

    public long cursor() {
        return this.buffer((boolean)false).pos + (long)this.off;
    }

    private synchronized void length(long l) {
        this.changed |= l != this.len;
        this.len = l;
    }

    public long length() {
        return this.len;
    }

    public boolean more() {
        return this.cursor() < this.len;
    }

    private int read() {
        Buffer bf = this.buffer(this.off == 4096);
        return bf.data[this.off++] & 0xFF;
    }

    public synchronized byte read1(long p) {
        this.cursor(p);
        return this.read1();
    }

    public synchronized byte read1() {
        return (byte)this.read();
    }

    public synchronized int read4(long p) {
        this.cursor(p);
        return this.read4();
    }

    public synchronized int read4() {
        return (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
    }

    public synchronized long read5(long p) {
        this.cursor(p);
        return this.read5();
    }

    public synchronized long read5() {
        return ((long)this.read() << 32) + ((long)this.read() << 24) + (long)(this.read() << 16) + (long)(this.read() << 8) + (long)this.read();
    }

    public synchronized int readNum(long p) {
        this.cursor(p);
        return this.readNum();
    }

    public synchronized byte[] readToken(long p) {
        this.cursor(p);
        return this.readToken();
    }

    public synchronized byte[] readToken() {
        int l = this.readNum();
        return this.readBytes(l);
    }

    public synchronized byte[] readBytes(long p, int l) {
        this.cursor(p);
        return this.readBytes(l);
    }

    public synchronized byte[] readBytes(int n) {
        int l = n;
        int ll = 4096 - this.off;
        byte[] b = new byte[l];
        System.arraycopy(this.buffer((boolean)false).data, this.off, b, 0, Math.min(l, ll));
        if (l > ll) {
            l -= ll;
            while (l > 4096) {
                System.arraycopy(this.buffer((boolean)true).data, 0, b, ll, 4096);
                ll += 4096;
                l -= 4096;
            }
            System.arraycopy(this.buffer((boolean)true).data, 0, b, ll, l);
        }
        this.off += l;
        return b;
    }

    public void cursor(long p) {
        this.off = (int)(p & 0xFFFL);
        long b = p - (long)this.off;
        if (!this.bm.cursor(b)) {
            return;
        }
        Buffer bf = this.bm.current();
        try {
            if (bf.dirty) {
                this.writeBlock(bf);
            }
            bf.pos = b;
            this.file.seek(bf.pos);
            if (bf.pos < this.file.length()) {
                this.file.readFully(bf.data, 0, (int)Math.min(this.len - bf.pos, 4096L));
            }
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }

    public synchronized int readNum() {
        int v = this.read();
        switch (v & 0xC0) {
            case 0: {
                return v;
            }
            case 64: {
                return (v - 64 << 8) + this.read();
            }
            case 128: {
                return (v - 128 << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
            }
        }
        return (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
    }

    private void write(int b) {
        Buffer bf = this.buffer(this.off == 4096);
        bf.dirty = true;
        bf.data[this.off++] = (byte)b;
        long nl = bf.pos + (long)this.off;
        if (nl > this.len) {
            this.length(nl);
        }
    }

    public void write5(long p, long v) {
        this.cursor(p);
        this.write((byte)(v >>> 32));
        this.write((byte)(v >>> 24));
        this.write((byte)(v >>> 16));
        this.write((byte)(v >>> 8));
        this.write((byte)v);
    }

    public void write4(long p, int v) {
        this.cursor(p);
        this.write4(v);
    }

    public void write4(int v) {
        this.write(v >>> 24);
        this.write(v >>> 16);
        this.write(v >>> 8);
        this.write(v);
    }

    public void writeNum(long p, int v) {
        this.cursor(p);
        this.writeNum(v);
    }

    public void writeNums(long p, int[] v) {
        this.cursor(p);
        this.writeNum(v.length);
        for (int n : v) {
            this.writeNum(n);
        }
    }

    public long appendNums(int[] v) {
        long end = this.len;
        this.writeNums(end, v);
        return end;
    }

    public void writeToken(long p, byte[] v) {
        this.cursor(p);
        this.writeToken(v, 0, v.length);
    }

    private void writeToken(byte[] buf, int offset, int length) {
        int l;
        this.writeNum(length);
        int last = offset + length;
        for (int o = offset; o < last; o += l) {
            Buffer bf = this.buffer(this.off == 4096);
            l = Math.min(last - o, 4096 - this.off);
            System.arraycopy(buf, o, bf.data, this.off, l);
            bf.dirty = true;
            this.off += l;
        }
        long nl = this.bm.current().pos + (long)this.off;
        if (nl > this.len) {
            this.length(nl);
        }
    }

    private void writeNum(int v) {
        if (v < 0 || v > 0x3FFFFFFF) {
            this.write(192);
            this.write(v >>> 24);
            this.write(v >>> 16);
            this.write(v >>> 8);
            this.write(v);
        } else if (v > 16383) {
            this.write(v >>> 24 | 0x80);
            this.write(v >>> 16);
            this.write(v >>> 8);
            this.write(v);
        } else if (v > 63) {
            this.write(v >>> 8 | 0x40);
            this.write(v);
        } else {
            this.write(v);
        }
    }

    public long free(long pos, int size) {
        int os;
        this.cursor(pos + (long)os);
        for (os = this.readNum(pos) + (int)(this.cursor() - pos); pos + (long)os < this.len && os < size && this.read() == 255; ++os) {
        }
        long o = pos;
        if (pos + (long)os == this.len) {
            this.length(pos);
        } else {
            int t = size;
            if (os < size) {
                this.cursor(pos);
                t = 0;
                o = this.len;
            } else {
                this.cursor(pos + (long)size);
            }
            while (t++ < os) {
                this.write(255);
            }
        }
        return o;
    }

    private void writeBlock(Buffer bf) throws IOException {
        this.file.seek(bf.pos);
        this.file.write(bf.data);
        bf.dirty = false;
    }

    private Buffer buffer(boolean next) {
        if (next) {
            this.cursor(this.bm.current().pos + 4096L);
        }
        return this.bm.current();
    }
}

