/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.random;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Arrays;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.data.MetaData;
import org.basex.io.IOFile;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.io.random.Buffer;
import org.basex.io.random.Buffers;
import org.basex.io.random.TableAccess;
import org.basex.util.Array;
import org.basex.util.BitArray;
import org.basex.util.Util;

public final class TableDiskAccess
extends TableAccess {
    private final Buffers bm = new Buffers();
    private final RandomAccessFile file;
    private BitArray usedPages;
    private FileLock fl;
    private int[] fpres;
    private int[] pages;
    private int page = -1;
    private int fpre = -1;
    private int npre = -1;
    private int blocks;
    private int used;

    public TableDiskAccess(MetaData md, boolean lock) throws IOException {
        super(md);
        boolean regular;
        int b;
        DataInput in = new DataInput(this.meta.dbfile("tbli"));
        this.blocks = b = in.readNum();
        int u = in.readNum();
        boolean bl = regular = u == 0 || u == Integer.MAX_VALUE;
        if (regular) {
            this.used = u == 0 ? 0 : b;
        } else {
            this.used = u;
            this.fpres = in.readNums();
            this.pages = in.readNums();
        }
        if (!regular) {
            int psize = in.readNum();
            this.usedPages = new BitArray(in.readLongs(psize), this.used);
        }
        in.close();
        this.file = new RandomAccessFile(this.meta.dbfile("tbl").file(), "rw");
        if (lock) {
            this.exclusiveLock();
        } else {
            this.sharedLock();
        }
        if (this.fl == null) {
            throw new BaseXException(Text.DB_PINNED_X, md.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean locked(String db, Context ctx) {
        boolean bl;
        IOFile table = MetaData.file(ctx.globalopts.dbpath(db), "tbl");
        if (!table.exists()) {
            return false;
        }
        RandomAccessFile file = new RandomAccessFile(table.file(), "rw");
        try {
            bl = file.getChannel().tryLock() == null;
        }
        catch (Throwable throwable) {
            try {
                file.close();
                throw throwable;
            }
            catch (OverlappingFileLockException ex) {
                return true;
            }
            catch (ClosedChannelException ex) {
                return false;
            }
            catch (IOException ex) {
                return true;
            }
        }
        file.close();
        return bl;
    }

    @Override
    public synchronized void flush() throws IOException {
        int a;
        for (Buffer b : this.bm.all()) {
            if (!b.dirty) continue;
            this.writeBlock(b);
        }
        if (!this.dirty) {
            return;
        }
        DataOutput out = new DataOutput(this.meta.dbfile("tbli"));
        out.writeNum(this.blocks);
        out.writeNum(this.used);
        out.writeNum(this.blocks);
        for (a = 0; a < this.blocks; ++a) {
            out.writeNum(this.fpres[a]);
        }
        out.writeNum(this.blocks);
        for (a = 0; a < this.blocks; ++a) {
            out.writeNum(this.pages[a]);
        }
        out.writeLongs(this.usedPages.toArray());
        out.close();
        this.dirty = false;
    }

    @Override
    public synchronized void close() throws IOException {
        this.flush();
        this.file.close();
    }

    @Override
    public boolean lock(boolean lock) {
        try {
            if (lock) {
                if (this.exclusiveLock()) {
                    return true;
                }
                if (this.sharedLock()) {
                    return false;
                }
            } else if (this.sharedLock()) {
                return true;
            }
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
        throw Util.notExpected((lock ? "Exclusive" : "Shared") + " lock could not be acquired.");
    }

    private boolean exclusiveLock() throws IOException {
        return this.lck(false);
    }

    private boolean sharedLock() throws IOException {
        return this.lck(true);
    }

    private boolean lck(boolean shared) throws IOException {
        if (this.fl != null && shared == this.fl.isShared()) {
            return true;
        }
        if (this.fl != null) {
            this.fl.release();
        }
        this.fl = this.file.getChannel().tryLock(0L, Long.MAX_VALUE, shared);
        return this.fl != null;
    }

    @Override
    public synchronized int read1(int pre, int off) {
        int o = off + this.cursor(pre);
        byte[] b = this.bm.current().data;
        return b[o] & 0xFF;
    }

    @Override
    public synchronized int read2(int pre, int off) {
        int o = off + this.cursor(pre);
        byte[] b = this.bm.current().data;
        return ((b[o] & 0xFF) << 8) + (b[o + 1] & 0xFF);
    }

    @Override
    public synchronized int read4(int pre, int off) {
        int o = off + this.cursor(pre);
        byte[] b = this.bm.current().data;
        return ((b[o] & 0xFF) << 24) + ((b[o + 1] & 0xFF) << 16) + ((b[o + 2] & 0xFF) << 8) + (b[o + 3] & 0xFF);
    }

    @Override
    public synchronized long read5(int pre, int off) {
        int o = off + this.cursor(pre);
        byte[] b = this.bm.current().data;
        return ((long)(b[o] & 0xFF) << 32) + ((long)(b[o + 1] & 0xFF) << 24) + (long)((b[o + 2] & 0xFF) << 16) + (long)((b[o + 3] & 0xFF) << 8) + (long)(b[o + 4] & 0xFF);
    }

    @Override
    public void write1(int pre, int off, int v) {
        int o = off + this.cursor(pre);
        Buffer bf = this.bm.current();
        byte[] b = bf.data;
        b[o] = (byte)v;
        bf.dirty = true;
    }

    @Override
    public void write2(int pre, int off, int v) {
        int o = off + this.cursor(pre);
        Buffer bf = this.bm.current();
        byte[] b = bf.data;
        b[o] = (byte)(v >>> 8);
        b[o + 1] = (byte)v;
        bf.dirty = true;
    }

    @Override
    public void write4(int pre, int off, int v) {
        int o = off + this.cursor(pre);
        Buffer bf = this.bm.current();
        byte[] b = bf.data;
        b[o] = (byte)(v >>> 24);
        b[o + 1] = (byte)(v >>> 16);
        b[o + 2] = (byte)(v >>> 8);
        b[o + 3] = (byte)v;
        bf.dirty = true;
    }

    @Override
    public void write5(int pre, int off, long v) {
        int o = off + this.cursor(pre);
        Buffer bf = this.bm.current();
        byte[] b = bf.data;
        b[o] = (byte)(v >>> 32);
        b[o + 1] = (byte)(v >>> 24);
        b[o + 2] = (byte)(v >>> 16);
        b[o + 3] = (byte)(v >>> 8);
        b[o + 4] = (byte)v;
        bf.dirty = true;
    }

    @Override
    protected void copy(byte[] entries, int pre, int last) {
        int o = 0;
        int i = pre;
        while (i < last) {
            int off = this.cursor(i);
            Buffer bf = this.bm.current();
            System.arraycopy(entries, o, bf.data, off, 16);
            bf.dirty = true;
            ++i;
            o += 16;
        }
    }

    @Override
    public void delete(int pre, int nr) {
        if (nr == 0) {
            return;
        }
        this.dirty();
        this.cursor(pre);
        int from = pre - this.fpre;
        int last = pre + nr;
        if (last - 1 < this.npre) {
            Buffer bf = this.bm.current();
            this.copy(bf.data, from + nr, bf.data, from, this.npre - last);
            this.updatePre(nr);
            if (this.npre == this.fpre) {
                this.usedPages.clear(this.pages[this.page]);
                Array.move(this.fpres, this.page + 1, -1, this.used - this.page - 1);
                Array.move(this.pages, this.page + 1, -1, this.used - this.page - 1);
                --this.used;
                this.readPage(this.page);
            }
            return;
        }
        int unused = 0;
        while (this.npre < last) {
            if (from == 0) {
                ++unused;
                this.usedPages.clear(this.pages[this.page]);
            }
            this.setPage(this.page + 1);
            from = 0;
        }
        this.readBlock(this.pages[this.page]);
        Buffer bf = this.bm.current();
        if (this.npre == last) {
            this.usedPages.clear((int)bf.pos);
            ++unused;
            if (this.page < this.used - 1) {
                this.readPage(this.page + 1);
            } else {
                ++this.page;
            }
        } else {
            this.copy(bf.data, last - this.fpre, bf.data, 0, this.npre - last);
        }
        if (unused > 0) {
            Array.move(this.fpres, this.page, -unused, this.used - this.page);
            Array.move(this.pages, this.page, -unused, this.used - this.page);
            this.used -= unused;
            this.page -= unused;
        }
        this.fpres[this.page] = pre;
        this.fpre = pre;
        this.updatePre(nr);
    }

    @Override
    public void insert(int pre, byte[] entries) {
        int exp;
        int nnew = entries.length;
        if (nnew == 0) {
            return;
        }
        this.dirty();
        int nr = nnew >>> 4;
        int split = 0;
        if (this.used == 0) {
            this.readPage(0);
            this.usedPages.set(0);
            ++this.used;
        } else if (pre > 0) {
            split = this.cursor(pre - 1) + 16;
        } else {
            throw Util.notExpected("Insertion at beginning of populated table.");
        }
        int nold = this.npre - this.fpre << 4;
        int moved = nold - split;
        Buffer bf = this.bm.current();
        if (nold + nnew <= 4096) {
            Array.move(bf.data, split, nnew, moved);
            System.arraycopy(entries, 0, bf.data, split, nnew);
            bf.dirty = true;
            int i = this.page + 1;
            while (i < this.used) {
                int n = i++;
                this.fpres[n] = this.fpres[n] + nr;
            }
            this.npre += nr;
            this.meta.size += nr;
            return;
        }
        byte[] all = new byte[nnew + moved];
        System.arraycopy(entries, 0, all, 0, nnew);
        System.arraycopy(bf.data, split, all, nnew, moved);
        int nrem = 4096 - split;
        if (nrem > 0) {
            System.arraycopy(all, 0, bf.data, split, nrem);
            bf.dirty = true;
        }
        int req = all.length - nrem;
        int needed = req / 4096;
        int remain = req % 4096;
        if (remain > 0) {
            if (this.page + 1 < this.used) {
                int o = this.occSpace(this.page + 1) << 4;
                if (remain <= 4096 - o) {
                    this.readPage(this.page + 1);
                    bf = this.bm.current();
                    System.arraycopy(bf.data, 0, bf.data, remain, o);
                    System.arraycopy(all, all.length - remain, bf.data, 0, remain);
                    bf.dirty = true;
                    int n = this.page;
                    this.fpres[n] = this.fpres[n] - (remain >>> 4);
                    this.readPage(this.page - 1);
                } else {
                    ++needed;
                }
            } else {
                ++needed;
            }
        }
        if ((exp = this.blocks + needed - (this.blocks - this.used)) > this.fpres.length) {
            int ns = Math.max(this.fpres.length << 1, exp);
            this.fpres = Arrays.copyOf(this.fpres, ns);
            this.pages = Arrays.copyOf(this.pages, ns);
        }
        Array.move(this.fpres, this.page + 1, needed, this.used - this.page - 1);
        Array.move(this.pages, this.page + 1, needed, this.used - this.page - 1);
        while (needed-- > 0) {
            this.freeBlock();
            nrem += this.write(all, nrem);
            this.fpres[this.page] = this.fpres[this.page - 1] + 256;
            this.pages[this.page] = (int)this.bm.current().pos;
        }
        int i = this.page + 1;
        while (i < this.used) {
            int n = i++;
            this.fpres[n] = this.fpres[n] + nr;
        }
        this.meta.size += nr;
        this.fpre = this.fpres[this.page];
        this.npre = this.page + 1 < this.used && this.fpres[this.page + 1] < this.meta.size ? this.fpres[this.page + 1] : this.meta.size;
    }

    @Override
    protected void dirty() {
        if (this.fpres == null) {
            int b = this.blocks;
            this.fpres = new int[b];
            this.pages = new int[b];
            for (int i = 0; i < b; ++i) {
                this.fpres[i] = i * 256;
                this.pages[i] = i;
            }
            this.usedPages = new BitArray(this.used, true);
        }
        this.dirty = true;
    }

    private int cursor(int pre) {
        int fp = this.fpre;
        int np = this.npre;
        if (pre < fp || pre >= np) {
            int last = this.used - 1;
            int l = 0;
            int h = last;
            int m = this.page;
            while (l <= h) {
                if (pre < fp) {
                    h = m - 1;
                } else {
                    if (pre < np) break;
                    l = m + 1;
                }
                m = h + l >>> 1;
                fp = this.fpre(m);
                np = m == last ? this.meta.size : this.fpre(m + 1);
            }
            if (l > h) {
                throw Util.notExpected("Data Access out of bounds:\n- pre value: " + pre + "\n- #used blocks: " + this.used + "\n- #total locks: " + this.blocks + "\n- access: " + m + " (" + l + " > " + h + ']');
            }
            this.readPage(m);
        }
        return pre - this.fpre << 4;
    }

    private void setPage(int p) {
        this.page = p;
        this.fpre = this.fpre(p);
        this.npre = p + 1 >= this.used ? this.meta.size : this.fpre(p + 1);
    }

    private void readPage(int p) {
        this.setPage(p);
        this.readBlock(this.page(p));
    }

    private int page(int p) {
        return this.pages == null ? p : this.pages[p];
    }

    private int fpre(int p) {
        return this.fpres == null ? p * 256 : this.fpres[p];
    }

    private void readBlock(int b) {
        if (!this.bm.cursor(b)) {
            return;
        }
        Buffer bf = this.bm.current();
        try {
            if (bf.dirty) {
                this.writeBlock(bf);
            }
            bf.pos = b;
            if (b >= this.blocks) {
                this.blocks = b + 1;
            } else {
                this.file.seek(bf.pos * 4096L);
                this.file.readFully(bf.data);
            }
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }

    private void freeBlock() {
        int b = this.usedPages.nextFree(0);
        this.usedPages.set(b);
        this.readBlock(b);
        ++this.used;
        ++this.page;
    }

    private void writeBlock(Buffer bf) throws IOException {
        this.file.seek(bf.pos * 4096L);
        this.file.write(bf.data);
        bf.dirty = false;
    }

    private void updatePre(int nr) {
        int i = this.page + 1;
        while (i < this.used) {
            int n = i++;
            this.fpres[n] = this.fpres[n] - nr;
        }
        this.meta.size -= nr;
        this.npre = this.page + 1 < this.used && this.fpres[this.page + 1] < this.meta.size ? this.fpres[this.page + 1] : this.meta.size;
    }

    private void copy(byte[] s, int sp, byte[] d, int dp, int l) {
        System.arraycopy(s, sp << 4, d, dp << 4, l << 4);
        this.bm.current().dirty = true;
    }

    private int write(byte[] s, int o) {
        Buffer bf = this.bm.current();
        int len = Math.min(4096, s.length - o);
        System.arraycopy(s, o, bf.data, 0, len);
        bf.dirty = true;
        return len;
    }

    private int occSpace(int i) {
        return (i + 1 < this.used ? this.fpres[i + 1] : this.meta.size) - this.fpres[i];
    }
}

