/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial.json;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.build.JsonOptions;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.json.JsonSerializer;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.Map;
import org.basex.query.value.type.AtomType;
import org.basex.util.Token;

public class JsonMapSerializer
extends JsonSerializer {
    public JsonMapSerializer(OutputStream os, SerializerOptions opts) throws IOException {
        super(os, opts);
    }

    @Override
    public void serialize(Item item) throws IOException {
        if (this.sep && this.level == 0) {
            this.print(32);
        }
        try {
            if (item instanceof Map) {
                Map map = (Map)item;
                ++this.level;
                Value keys = map.keys();
                long num = 0L;
                boolean object = false;
                for (Item k : keys) {
                    if (k.type == AtomType.ITR) {
                        long n = k.itr(null);
                        if (n <= 0L) {
                            throw Err.BXJS_SERIAL.getIO("Integer key " + k + " ist not positive");
                        }
                        num = Math.max(num, n);
                    } else {
                        object = true;
                        if (k.type != AtomType.STR) {
                            num = -1L;
                        }
                    }
                    if (!object || num == 0L) continue;
                    throw Err.BXJS_SERIAL.getIO("Keys must either be strings or integers");
                }
                object = num == 0L;
                this.print(object ? 123 : 91);
                if (object) {
                    num = keys.size();
                }
                boolean f = false;
                int i = 0;
                while ((long)i < num) {
                    Value v;
                    Item k;
                    Item item2 = k = object ? keys.itemAt(i) : Int.get(i + 1);
                    if (f) {
                        this.print(44);
                    }
                    this.indent();
                    if (object) {
                        this.serialize(k);
                        this.print(58);
                        if (this.indent) {
                            this.print(32);
                        }
                    }
                    if ((v = map.get(k, null)).size() > 1L) {
                        throw Err.BXJS_SERIAL.getIO("More than one item specified for key " + k);
                    }
                    this.serialize(v.isEmpty() ? null : (Item)v);
                    f = true;
                    ++i;
                }
                --this.level;
                this.indent();
                this.print(object ? 125 : 93);
            } else {
                if (this.level == 0 && this.spec == JsonOptions.JsonSpec.RFC4627) {
                    throw Err.BXJS_SERIAL.getIO("Top level must be a map; " + item.type + " found");
                }
                if (item == null) {
                    this.print(Token.NULL);
                } else {
                    boolean quote;
                    byte[] str = item.string(null);
                    boolean bl = quote = item.type != AtomType.BLN && (!item.type.isNumber() || Token.eq(str, Token.NAN, Token.INF, Token.NINF));
                    if (quote) {
                        this.print(34);
                    }
                    byte[] atom = item.string(null);
                    for (int a = 0; a < atom.length; a += Token.cl(atom, a)) {
                        this.encode(Token.cp(atom, a));
                    }
                    if (quote) {
                        this.print(34);
                    }
                }
            }
        }
        catch (QueryException ex) {
            throw new QueryIOException(ex);
        }
        this.sep = true;
    }

    @Override
    protected final void indent() throws IOException {
        if (!this.indent) {
            return;
        }
        this.print(this.nl);
        int ls = this.level * this.indents;
        for (int l = 0; l < ls; ++l) {
            this.print(this.tab);
        }
    }
}

