/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.CName;
import org.basex.query.expr.Constr;
import org.basex.query.expr.Expr;
import org.basex.query.util.Err;
import org.basex.query.util.NSContext;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FAttr;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.IntObjMap;

public final class CElem
extends CName {
    private final Atts nspaces;
    private final boolean comp;

    public CElem(StaticContext sctx, InputInfo ii, Expr t, Atts ns, Expr ... cont) {
        super("element", sctx, ii, t, cont);
        this.nspaces = ns == null ? new Atts() : ns;
        this.comp = ns == null;
        this.type = SeqType.ELM;
    }

    @Override
    public CElem compile(QueryContext ctx, VarScope scp) throws QueryException {
        int s = this.addNS();
        super.compile(ctx, scp);
        this.sc.ns.size(s);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FElem item(QueryContext ctx, InputInfo ii) throws QueryException {
        int s = this.addNS();
        try {
            int a;
            Atts ns = new Atts();
            for (int i = 0; i < this.nspaces.size(); ++i) {
                ns.add(this.nspaces.name(i), this.nspaces.value(i));
            }
            QNm nm = this.qname(ctx, ii);
            byte[] cp = nm.prefix();
            byte[] cu = nm.uri();
            if (Token.eq(cp, Token.XML) ^ Token.eq(cu, QueryText.XMLURI)) {
                throw Err.CEXML.get(this.info, cu, cp);
            }
            if (Token.eq(cu, QueryText.XMLNSURI)) {
                throw Err.CEINV.get(this.info, new Object[]{cu});
            }
            if (Token.eq(cp, Token.XMLNS)) {
                throw Err.CEINV.get(this.info, new Object[]{cp});
            }
            if (!nm.hasURI() && nm.hasPrefix()) {
                throw Err.INVPREF.get(this.info, nm);
            }
            if (!Token.eq(cp, Token.XML)) {
                byte[] uri = this.sc.ns.uri(cp);
                if (nm.hasURI()) {
                    if (!(this.comp || uri != null && Token.eq(uri, cu))) {
                        this.sc.ns.add(cp, cu);
                    }
                    if (!ns.contains(cp)) {
                        ns.add(cp, cu);
                    }
                } else {
                    nm.uri(uri);
                }
            }
            Constr constr = new Constr(ii, this.sc);
            FElem node = new FElem(nm, ns, constr.children, constr.atts);
            constr.add(ctx, this.expr);
            if (constr.errAtt) {
                throw Err.NOATTALL.get(this.info, new Object[0]);
            }
            if (constr.errNS) {
                throw Err.NONSALL.get(this.info, new Object[0]);
            }
            if (constr.duplAtt != null) {
                throw Err.CATTDUPL.get(this.info, new Object[]{constr.duplAtt});
            }
            if (constr.duplNS != null) {
                throw Err.DUPLNSCONS.get(this.info, new Object[]{constr.duplNS});
            }
            if (constr.nspaces.contains(Token.EMPTY) && !nm.hasURI()) {
                throw Err.DUPLNSCONS.get(this.info, new Object[]{Token.EMPTY});
            }
            Atts cns = constr.nspaces;
            for (a = 0; a < cns.size(); ++a) {
                CElem.addNS(cns.name(a), cns.value(a), ns);
            }
            for (a = 0; a < constr.atts.size(); ++a) {
                byte[] auri;
                byte[] npref;
                byte[] apref;
                ANode att = constr.atts.get(a);
                QNm qnm = att.qname();
                if (!qnm.hasPrefix() || !qnm.hasURI() || Token.eq(apref = qnm.prefix(), Token.XML) || (npref = CElem.addNS(apref, auri = qnm.uri(), ns)) == null) continue;
                QNm aname = new QNm(Token.concat(npref, Token.COLON, qnm.local()), auri);
                constr.atts.set(a, new FAttr(aname, att.string()));
            }
            for (int c = 0; c < constr.children.size(); ++c) {
                constr.children.get(c).optimize();
            }
            FElem fElem = node.optimize();
            return fElem;
        }
        finally {
            this.sc.ns.size(s);
        }
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return new CElem(this.sc, this.info, this.name.copy(ctx, scp, vs), this.comp ? null : this.nspaces.copy(), CElem.copyAll((QueryContext)ctx, (VarScope)scp, vs, (Expr[])this.expr));
    }

    private static byte[] addNS(byte[] pref, byte[] uri, Atts ns) {
        byte[] u = ns.value(pref);
        if (u == null) {
            ns.add(pref, uri);
        } else if (!Token.eq(u, uri)) {
            byte[] apref = null;
            for (int c = 0; c < ns.size(); ++c) {
                if (!Token.eq(ns.value(c), uri)) continue;
                apref = ns.name(c);
            }
            if (apref == null) {
                int i = 1;
                while (ns.contains(apref = Token.concat(pref, new byte[]{95}, Token.token(i++)))) {
                }
                ns.add(apref, uri);
            }
            return apref;
        }
        return null;
    }

    private int addNS() {
        NSContext ns = this.sc.ns;
        int s = ns.size();
        for (int n = 0; n < this.nspaces.size(); ++n) {
            ns.add(this.nspaces.name(n), this.nspaces.value(n));
        }
        return s;
    }
}

