/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.func.FNInfo;
import org.basex.query.path.NameTest;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.IntObjMap;

public final class Catch
extends Single {
    public static final QNm[] NAMES = new QNm[]{Catch.create(QueryText.E_CODE), Catch.create(QueryText.E_DESCRIPTION), Catch.create(QueryText.E_VALUE), Catch.create(QueryText.E_MODULE), Catch.create(QueryText.E_LINE_NUMBER), Catch.create(QueryText.E_COLUM_NUMBER), Catch.create(QueryText.E_ADDITIONAL)};
    public static final SeqType[] TYPES = new SeqType[]{SeqType.QNM, SeqType.STR_ZO, SeqType.ITEM_ZM, SeqType.STR_ZO, SeqType.ITR_ZO, SeqType.ITR_ZO, SeqType.ITEM_ZM};
    private final Var[] vars;
    private final NameTest[] codes;

    public Catch(InputInfo ii, NameTest[] c, Var[] vs) {
        super(ii, null);
        this.vars = vs;
        this.codes = c;
    }

    @Override
    public Catch compile(QueryContext ctx, VarScope scp) {
        try {
            this.expr = this.expr.compile(ctx, scp);
            this.type = this.expr.type();
        }
        catch (QueryException qe) {
            this.expr = FNInfo.error(qe, this.expr.type());
        }
        return this;
    }

    Value value(QueryContext ctx, QueryException ex) throws QueryException {
        int i = 0;
        byte[] io = ex.file() == null ? Token.EMPTY : Token.token(ex.file());
        Value val = ex.value();
        for (Value v : new Value[]{ex.qname(), Str.get(ex.getLocalizedMessage()), val == null ? Empty.SEQ : val, Str.get(io), Int.get(ex.line()), Int.get(ex.column()), Str.get(ex.getMessage().replaceAll("\r\n?", "\n"))}) {
            ctx.set(this.vars[i++], v, this.info);
        }
        return ctx.value(this.expr);
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        Var[] vrs = new Var[NAMES.length];
        for (int i = 0; i < vrs.length; ++i) {
            vrs[i] = scp.newLocal(ctx, NAMES[i], TYPES[i], false);
        }
        Catch ctch = new Catch(this.info, (NameTest[])this.codes.clone(), vrs);
        for (int i = 0; i < this.vars.length; ++i) {
            vs.put(this.vars[i].id, ctch.vars[i]);
        }
        ctch.expr = this.expr.copy(ctx, scp, vs);
        return ctch;
    }

    @Override
    public Catch inline(QueryContext ctx, VarScope scp, Var v, Expr e) {
        try {
            Expr sub = this.expr.inline(ctx, scp, v, e);
            if (sub == null) {
                return null;
            }
            this.expr = sub;
        }
        catch (QueryException qe) {
            this.expr = FNInfo.error(qe, this.type);
        }
        return this;
    }

    Expr asExpr(QueryException ex, QueryContext ctx, VarScope scp) throws QueryException {
        if (this.expr.isValue()) {
            return this.expr;
        }
        int i = 0;
        Expr e = this.expr;
        for (Value v : Catch.values(ex)) {
            Expr e2;
            if ((e2 = e.inline(ctx, scp, this.vars[i++], v)) != null) {
                e = e2;
            }
            if (e.isValue()) break;
        }
        return e;
    }

    public static Value[] values(QueryException ex) {
        byte[] io = ex.file() == null ? Token.EMPTY : Token.token(ex.file());
        Value val = ex.value();
        return new Value[]{ex.qname(), Str.get(ex.getLocalizedMessage()), val == null ? Empty.SEQ : val, Str.get(io), Int.get(ex.line()), Int.get(ex.column()), Str.get(ex.getMessage().replaceAll("\r\n?", "\n"))};
    }

    boolean matches(QueryException qe) {
        QNm code = qe.qname();
        for (NameTest c : this.codes) {
            if (!c.eq(code)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "catch * { " + this.expr + " }";
    }

    private static QNm create(byte[] n) {
        return new QNm(Token.concat(QueryText.ERR, Token.COLON, n), QueryText.ERRORURI);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        for (Var v : this.vars) {
            if (visitor.declared(v)) continue;
            return false;
        }
        return Catch.visitAll(visitor, this.expr);
    }

    @Override
    public int exprSize() {
        return this.expr.exprSize();
    }
}

