/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.index.query.StringRange;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.expr.StringRangeAccess;
import org.basex.query.iter.Iter;
import org.basex.query.path.Step;
import org.basex.query.util.Collation;
import org.basex.query.util.Err;
import org.basex.query.util.IndexCosts;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;

public final class CmpSR
extends Single {
    private final Collation collation;
    private final byte[] min;
    private final boolean mni;
    private final byte[] max;
    private final boolean mxi;
    private StringRange rt;
    private final boolean atomic;

    private CmpSR(Expr e, byte[] mn, boolean in, byte[] mx, boolean ix, Collation coll, InputInfo ii) {
        super(ii, e);
        this.collation = coll;
        this.min = mn;
        this.mni = in;
        this.max = mx;
        this.mxi = ix;
        this.type = SeqType.BLN;
        this.atomic = e.type().zeroOrOne();
    }

    static Expr get(CmpG ex) throws QueryException {
        if (!(ex.expr[1] instanceof AStr)) {
            return ex;
        }
        byte[] d = ((Item)ex.expr[1]).string(ex.info);
        Expr e = ex.expr[0];
        switch (ex.op.op) {
            case GE: {
                return new CmpSR(e, d, true, null, true, ex.collation, ex.info);
            }
            case GT: {
                return new CmpSR(e, d, false, null, true, ex.collation, ex.info);
            }
            case LE: {
                return new CmpSR(e, null, true, d, true, ex.collation, ex.info);
            }
            case LT: {
                return new CmpSR(e, null, true, d, false, ex.collation, ex.info);
            }
        }
        return ex;
    }

    @Override
    public Bln item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it;
        if (this.atomic) {
            Item it2 = this.expr.item(ctx, this.info);
            return Bln.get(it2 != null && this.eval(it2));
        }
        Iter ir = ctx.iter(this.expr);
        while ((it = ir.next()) != null) {
            if (!this.eval(it)) continue;
            return Bln.TRUE;
        }
        return Bln.FALSE;
    }

    private boolean eval(Item it) throws QueryException {
        int mx;
        int mn;
        if (!it.type.isStringOrUntyped()) {
            throw Err.INVTYPECMP.get(this.info, it.type, AtomType.STR);
        }
        byte[] s = it.string(this.info);
        int n = this.min == null ? 1 : (mn = this.collation == null ? Token.diff(s, this.min) : this.collation.compare(s, this.min));
        int n2 = this.max == null ? -1 : (mx = this.collation == null ? Token.diff(s, this.max) : this.collation.compare(s, this.max));
        return (this.mni ? mn >= 0 : mn > 0) && (this.mxi ? mx <= 0 : mx < 0);
    }

    Expr intersect(CmpSR c) {
        byte[] mx;
        byte[] mn;
        if (this.collation != null || !c.expr.sameAs(this.expr)) {
            return null;
        }
        byte[] byArray = this.min == null ? c.min : (mn = c.min == null ? this.min : Token.max(this.min, c.min));
        byte[] byArray2 = this.max == null ? c.max : (mx = c.max == null ? this.max : Token.min(this.max, c.max));
        if (mn != null && mx != null) {
            int d = Token.diff(mn, mx);
            if (d > 0) {
                return Bln.FALSE;
            }
            if (d == 0) {
                return this.mni && this.mxi ? new CmpG(this.expr, (Expr)Str.get(mn), CmpG.OpG.EQ, null, this.info) : Bln.FALSE;
            }
        }
        return new CmpSR(c.expr, mn, this.mni && c.mni, mx, this.mxi && c.mxi, null, this.info);
    }

    @Override
    public boolean indexAccessible(IndexCosts ic) {
        boolean attr;
        Step s = CmpG.indexStep(this.expr);
        Data data = ic.ictx.data;
        if (this.collation != null || s == null || data.inMemory()) {
            return false;
        }
        boolean text = s.test.type == NodeType.TXT && data.meta.textindex;
        boolean bl = attr = s.test.type == NodeType.ATT && data.meta.attrindex;
        if (!text && !attr || this.min == null || this.max == null) {
            return false;
        }
        this.rt = new StringRange(text ? IndexType.TEXT : IndexType.ATTRIBUTE, this.min, this.mni, this.max, this.mxi);
        ic.costs(Math.max(1, data.meta.size / 10));
        return true;
    }

    @Override
    public Expr indexEquivalent(IndexCosts ic) {
        boolean text = this.rt.type() == IndexType.TEXT;
        ic.ctx.compInfo("applying string range index", new Object[0]);
        return ic.invert(this.expr, new StringRangeAccess(this.info, this.rt, ic.ictx), text);
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        CmpSR res = new CmpSR(this.expr.copy(ctx, scp, vs), this.min, this.mni, this.max, this.mxi, this.collation, this.info);
        res.rt = this.rt;
        return res;
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.MIN, this.min != null ? (Object)this.min : "", QueryText.MAX, this.max != null ? (Object)this.max : ""), this.expr);
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder();
        if (this.min != null) {
            tb.add(34).add(this.min).add(34).add(this.mni ? " <= " : " < ");
        }
        tb.addExt(this.expr, new Object[0]);
        if (this.max != null) {
            tb.add(this.mxi ? " <= " : " < ").add(34).add(this.max).add(34);
        }
        return tb.toString();
    }
}

