/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.And;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Or;
import org.basex.query.expr.TypeCheck;
import org.basex.query.func.FNInfo;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.IndexCosts;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class If
extends Arr {
    private Expr cond;

    public If(InputInfo ii, Expr c, Expr t, Expr e) {
        super(ii, t, e);
        this.cond = c;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.cond);
        this.checkAllUp(this.expr);
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        this.cond = this.cond.compile(ctx, scp).compEbv(ctx);
        if (this.cond.isValue()) {
            return this.optPre(this.eval(ctx).compile(ctx, scp), ctx);
        }
        int es = this.expr.length;
        for (int e = 0; e < es; ++e) {
            try {
                this.expr[e] = this.expr[e].compile(ctx, scp);
                continue;
            }
            catch (QueryException ex) {
                this.expr[e] = FNInfo.error(ex, this.type);
            }
        }
        return this.optimize(ctx, scp);
    }

    @Override
    public Expr optimize(QueryContext ctx, VarScope scp) throws QueryException {
        if (this.cond.isValue()) {
            return this.optPre(this.eval(ctx), ctx);
        }
        if (this.expr[0].sameAs(this.expr[1])) {
            return this.optPre(this.expr[0], ctx);
        }
        if (this.cond.isFunction(Function.NOT)) {
            ctx.compInfo("rewriting %", this);
            this.cond = ((Arr)this.cond).expr[0];
            Expr tmp = this.expr[0];
            this.expr[0] = this.expr[1];
            this.expr[1] = tmp;
        }
        if (this.expr[0].type().eq(SeqType.BLN) && this.expr[1].type().eq(SeqType.BLN)) {
            Expr a = this.cond;
            Expr b = this.expr[0];
            Expr c = this.expr[1];
            if (b == Bln.TRUE) {
                if (c == Bln.FALSE) {
                    ctx.compInfo("pre-evaluating %", this);
                    return If.compBln(a, this.info);
                }
                ctx.compInfo("rewriting %", this);
                return new Or(this.info, a, c).optimize(ctx, scp);
            }
            if (c == Bln.TRUE) {
                if (b == Bln.FALSE) {
                    ctx.compInfo("pre-evaluating %", this);
                    return Function.NOT.get(null, a).optimize(ctx, scp);
                }
                ctx.compInfo("rewriting %", this);
                Expr notA = Function.NOT.get(null, a).optimize(ctx, scp);
                return new Or(this.info, notA, b).optimize(ctx, scp);
            }
            if (b == Bln.FALSE) {
                ctx.compInfo("rewriting %", this);
                Expr notA = Function.NOT.get(null, a).optimize(ctx, scp);
                return new And(this.info, notA, c).optimize(ctx, scp);
            }
            if (c == Bln.FALSE) {
                ctx.compInfo("rewriting %", this);
                return new And(this.info, a, b).optimize(ctx, scp);
            }
        }
        this.type = this.expr[0].type().union(this.expr[1].type());
        return this;
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        return ctx.iter(this.eval(ctx));
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        return ctx.value(this.eval(ctx));
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        return this.eval(ctx).item(ctx, this.info);
    }

    private Expr eval(QueryContext ctx) throws QueryException {
        return this.expr[this.cond.ebv(ctx, this.info).bool(this.info) ? 0 : 1];
    }

    @Override
    public boolean has(Expr.Flag flag) {
        return this.cond.has(flag) || super.has(flag);
    }

    @Override
    public boolean removable(Var v) {
        return this.cond.removable(v) && super.removable(v);
    }

    @Override
    public VarUsage count(Var v) {
        return this.cond.count(v).plus(VarUsage.maximum(v, this.expr));
    }

    @Override
    public Expr inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        Expr sub = this.cond.inline(ctx, scp, v, e);
        if (sub != null) {
            this.cond = sub;
        }
        boolean te = false;
        int es = this.expr.length;
        for (int i = 0; i < es; ++i) {
            Expr nw;
            try {
                nw = this.expr[i].inline(ctx, scp, v, e);
            }
            catch (QueryException qe) {
                nw = FNInfo.error(qe, this.type);
            }
            if (nw == null) continue;
            this.expr[i] = nw;
            te = true;
        }
        return te || sub != null ? this.optimize(ctx, scp) : null;
    }

    @Override
    public If copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return this.copyType(new If(this.info, this.cond.copy(ctx, scp, vs), this.expr[0].copy(ctx, scp, vs), this.expr[1].copy(ctx, scp, vs)));
    }

    @Override
    public Expr indexEquivalent(IndexCosts ic) throws QueryException {
        int es = this.expr.length;
        for (int e = 0; e < es; ++e) {
            this.expr[e] = this.expr[e].indexEquivalent(ic);
        }
        return this;
    }

    @Override
    public boolean isVacuous() {
        return this.expr[0].isVacuous() && this.expr[1].isVacuous();
    }

    @Override
    public void markTailCalls(QueryContext ctx) {
        this.expr[0].markTailCalls(ctx);
        this.expr[1].markTailCalls(ctx);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.cond, this.expr});
    }

    @Override
    public String toString() {
        return "if(" + this.cond + ") " + "then" + ' ' + this.expr[0] + ' ' + "else" + ' ' + this.expr[1];
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.cond.accept(visitor) && super.accept(visitor);
    }

    @Override
    public int exprSize() {
        int sz = 1;
        for (Expr e : this.expr) {
            sz += e.exprSize();
        }
        return sz + this.cond.exprSize();
    }

    @Override
    public Expr typeCheck(TypeCheck tc, QueryContext ctx, VarScope scp) throws QueryException {
        for (int i = 0; i < this.expr.length; ++i) {
            SeqType tp = this.expr[i].type();
            try {
                this.expr[i] = tc.check(this.expr[i], ctx, scp);
                continue;
            }
            catch (QueryException ex) {
                this.expr[i] = FNInfo.error(ex, tp);
            }
        }
        return this.optimize(ctx, scp);
    }
}

