/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.And;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Or;
import org.basex.query.util.ExprList;
import org.basex.query.value.item.Bln;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;

public abstract class Logical
extends Arr {
    boolean tailCall;

    Logical(InputInfo ii, Expr[] e) {
        super(ii, e);
        this.type = SeqType.BLN;
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        super.compile(ctx, scp);
        boolean and = this instanceof And;
        int es = this.expr.length;
        ExprList el = new ExprList(es);
        for (Expr e : this.expr) {
            Expr ex = e.compEbv(ctx);
            if (ex.isValue()) {
                ctx.compInfo("%: removing %", this, e);
                if (!(ex.ebv(ctx, this.info).bool(this.info) ^ and)) continue;
                return Bln.get(!and);
            }
            el.add(ex);
        }
        if (el.isEmpty()) {
            return Bln.get(and);
        }
        this.expr = el.finish();
        return this;
    }

    @Override
    public final void markTailCalls(QueryContext ctx) {
        Expr last = this.expr[this.expr.length - 1];
        if (last.type().eq(SeqType.BLN)) {
            this.tailCall = true;
            last.markTailCalls(ctx);
        }
    }

    @Override
    public void plan(FElem plan) {
        FElem el = this.planElem(new Object[0]);
        if (this.tailCall) {
            el.add(this.planAttr(QueryText.TCL, true));
        }
        plan.add(el);
        for (Expr e : this.expr) {
            if (e == null) continue;
            e.plan(el);
        }
    }

    final void compFlatten(QueryContext ctx) {
        int es = this.expr.length;
        ExprList tmp = new ExprList(es);
        boolean and = this instanceof And;
        boolean or = this instanceof Or;
        for (Expr ex : this.expr) {
            if (and && ex instanceof And || or && ex instanceof Or) {
                for (Expr e : ((Arr)ex).expr) {
                    tmp.add(e);
                }
                ctx.compInfo("flattening %", ex);
                continue;
            }
            tmp.add(ex);
        }
        if (es != tmp.size()) {
            this.expr = tmp.finish();
        }
    }
}

